/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.guest.notebooks;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.BeFileEditorModel;
import com.jetbrains.rd.ide.model.FileEditorModel;
import com.jetbrains.rd.ide.model.NotebookFileEditorModel;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.notebook.NotebookEditorMouseListener;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.fileEditors.FrontendDefaultFileEditor;
import com.jetbrains.rdclient.fileEditors.FrontendDefaultFileEditorProvider;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorModelHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.ui.editor.DefaultNotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import org.jetbrains.plugins.notebooks.ui.editor.actions.command.mode.NotebookEditorModeListenerAdapter;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookEditorAppearance;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/cwm/guest/notebooks/NotebookFrontendEditorModelHandler;", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorModelHandler;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "model", "Lcom/jetbrains/rd/ide/model/FileEditorModel;", "createEditorWithProvider", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Companion", "intellij.notebooks.frontend.split"})
public final class NotebookFrontendEditorModelHandler
implements FrontendFileEditorModelHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileEditorModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof NotebookFileEditorModel;
    }

    @NotNull
    public FileEditorWithProvider createEditorWithProvider(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull VirtualFile file, @NotNull FileEditorModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        FrontendDefaultFileEditorProvider provider = new FrontendDefaultFileEditorProvider(model.getProvider());
        NotebookFileEditorModel editorModel = (NotebookFileEditorModel)model;
        FrontendDefaultFileEditor fileEditor = new FrontendDefaultFileEditor(file, lifetime, (BeFileEditorModel)editorModel);
        Editor editor = FrontendTextControlHostKt.toEditorOrNull((TextControlId)((NotebookFileEditorModel)model).getEditorId());
        if (editor != null) {
            Companion.customize(project, editor, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null), editorModel);
        }
        return new FileEditorWithProvider((FileEditor)fileEditor, (FileEditorProvider)provider);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/cwm/guest/notebooks/NotebookFrontendEditorModelHandler$Companion;", "", "()V", "customize", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "disposable", "Lcom/intellij/openapi/Disposable;", "editorModel", "Lcom/jetbrains/rd/ide/model/NotebookFileEditorModel;", "intellij.notebooks.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        public final void customize(@NotNull Project project, @NotNull Editor editor, @NotNull Disposable disposable, @NotNull NotebookFileEditorModel editorModel) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            NotebookEditorAppearance.Companion.getNOTEBOOK_APPEARANCE_KEY().set((UserDataHolder)editor, (Object)DefaultNotebookEditorAppearance.INSTANCE);
            if (editor instanceof EditorImpl) {
                editor.addEditorMouseListener((EditorMouseListener)new NotebookEditorMouseListener(editorModel), ((EditorImpl)editor).getDisposable());
            }
            NotebookEditorModeListenerAdapter adapter = new NotebookEditorModeListenerAdapter(editor);
            project.getMessageBus().connect(disposable).subscribe(NotebookEditorModeKt.getNOTEBOOK_EDITOR_MODE(), (Object)adapter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

