/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer;

import com.intellij.ide.startup.importSettings.controllers.TransferSettingsListener;
import com.intellij.ide.startup.importSettings.data.SettingsService;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsPerformContext;
import com.intellij.ide.startup.importSettings.transfer.SettingTransferProductServiceKt;
import com.intellij.ide.startup.importSettings.transfer.backend.models.IdeVersion;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.PluginInstallationState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/TransferSettingsWizardListener;", "Lcom/intellij/ide/startup/importSettings/controllers/TransferSettingsListener;", "ld", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "importFailed", "", "ideVersion", "Lcom/intellij/ide/startup/importSettings/transfer/backend/models/IdeVersion;", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "throwable", "", "importPerformed", "context", "Lcom/intellij/ide/startup/importSettings/providers/TransferSettingsPerformContext;", "importStarted", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nSettingTransferProductService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingTransferProductService.kt\ncom/intellij/ide/startup/importSettings/transfer/TransferSettingsWizardListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,213:1\n23#2:214\n23#2:215\n23#2:216\n*S KotlinDebug\n*F\n+ 1 SettingTransferProductService.kt\ncom/intellij/ide/startup/importSettings/transfer/TransferSettingsWizardListener\n*L\n174#1:214\n179#1:215\n185#1:216\n*E\n"})
public final class TransferSettingsWizardListener
implements TransferSettingsListener {
    @NotNull
    private final LifetimeDefinition ld;

    public TransferSettingsWizardListener(@NotNull LifetimeDefinition ld) {
        Intrinsics.checkNotNullParameter((Object)ld, (String)"ld");
        this.ld = ld;
    }

    @Override
    public void importStarted(@NotNull IdeVersion ideVersion, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        TransferSettingsWizardListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TransferSettingsWizardListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Settings import from " + ideVersion.getName() + " has been started.");
    }

    @Override
    public void importFailed(@NotNull IdeVersion ideVersion, @NotNull Settings settings, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.ld, (boolean)false, (int)1, null);
        TransferSettingsWizardListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TransferSettingsWizardListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Setting import error from " + ideVersion.getName() + ".", throwable);
        SettingTransferProductServiceKt.access$showImportErrorNotification(throwable);
    }

    @Override
    public void importPerformed(@NotNull IdeVersion ideVersion, @NotNull Settings settings, @NotNull TransferSettingsPerformContext context2) {
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.ld, (boolean)false, (int)1, null);
        TransferSettingsWizardListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TransferSettingsWizardListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Setting import error from " + ideVersion.getName() + " has been finished, plugin state: " + context2.getPluginInstallationState() + ".");
        SettingsService.Companion.getInstance().getDoClose().fire((Object)Unit.INSTANCE);
        if (context2.getPluginInstallationState() == PluginInstallationState.RestartRequired) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }
}

