/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsSelectionUtil {
    private VcsSelectionUtil() {
    }

    @Nullable
    public static VcsSelection getSelection(@NotNull AnAction action, @NotNull AnActionEvent e) {
        Editor editor;
        if (action == null) {
            VcsSelectionUtil.$$$reportNull$$$0(0);
        }
        if (e == null) {
            VcsSelectionUtil.$$$reportNull$$$0(1);
        }
        if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) == null) {
            return null;
        }
        VcsSelection atCaret = (VcsSelection)e.getUpdateSession().compute((Object)action, "getSelection", ActionUpdateThread.EDT, () -> {
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection() && !EditorUtil.contextMenuInvokedOutsideOfSelection((AnActionEvent)e)) {
                return new VcsSelection(editor.getDocument(), new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()), VcsBundle.message((String)"action.name.show.history.for.selection", (Object[])new Object[0]));
            }
            return null;
        });
        if (atCaret != null) {
            return atCaret;
        }
        VcsSelection vcsSelection = VcsSelectionUtil.getSelectionFromExtensions(e.getDataContext());
        if (vcsSelection != null) {
            return vcsSelection;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        return new VcsSelection(editor.getDocument(), new TextRange(caret.getOffset(), caret.getOffset()), VcsBundle.message((String)"action.name.show.history.for.selection", (Object[])new Object[0]));
    }

    @Nullable
    private static VcsSelection getSelectionFromExtensions(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsSelectionUtil.$$$reportNull$$$0(2);
        }
        for (VcsSelectionProvider provider : VcsSelectionProvider.EP_NAME.getExtensionList()) {
            try {
                VcsSelection vcsSelection = provider.getSelection(dataContext);
                if (vcsSelection == null) continue;
                return vcsSelection;
            }
            catch (IndexNotReadyException indexNotReadyException) {
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcsUtil/VcsSelectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectionFromExtensions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

