/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.commit.CommitterResultHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\u001a\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0016J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u0018H\u0004J\u001e\u0010\"\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180$H\u0005R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/commit/Committer;", "", "project", "Lcom/intellij/openapi/project/Project;", "commitMessage", "", "Lcom/intellij/openapi/util/NlsSafe;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "_exceptions", "", "Lcom/intellij/openapi/vcs/VcsException;", "commitErrors", "", "getCommitErrors", "()Ljava/util/List;", "getCommitMessage", "()Ljava/lang/String;", "exceptions", "getExceptions", "getProject", "()Lcom/intellij/openapi/project/Project;", "resultHandlers", "Lcom/intellij/vcs/commit/CommitterResultHandler;", "addException", "", "e", "", "addResultHandler", "resultHandler", "finishCommit", "useCustomPostRefresh", "", "canceled", "fireAfterRefresh", "runCommitTask", "task", "Lkotlin/Function0;", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCommitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Committer.kt\ncom/intellij/vcs/commit/Committer\n+ 2 util.kt\ncom/intellij/util/containers/UtilKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,135:1\n194#2,9:136\n194#2,9:145\n194#2,9:154\n194#2,9:163\n13#3:172\n*S KotlinDebug\n*F\n+ 1 Committer.kt\ncom/intellij/vcs/commit/Committer\n*L\n62#1:136,9\n66#1:145,9\n70#1:154,9\n79#1:163,9\n83#1:172\n*E\n"})
public abstract class Committer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String commitMessage;
    @NotNull
    private final List<CommitterResultHandler> resultHandlers;
    @NotNull
    private final List<VcsException> _exceptions;
    @NotNull
    private static final Logger LOG;

    public Committer(@NotNull Project project, @NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        this.project = project;
        this.commitMessage = commitMessage;
        this.resultHandlers = new ArrayList();
        this._exceptions = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getCommitMessage() {
        return this.commitMessage;
    }

    @NotNull
    public final List<VcsException> getExceptions() {
        return CollectionsKt.toList((Iterable)this._exceptions);
    }

    @NotNull
    public final List<VcsException> getCommitErrors() {
        return Companion.collectErrors(this._exceptions);
    }

    public final void addResultHandler(@NotNull CommitterResultHandler resultHandler) {
        Intrinsics.checkNotNullParameter((Object)resultHandler, (String)"resultHandler");
        ((Collection)this.resultHandlers).add(resultHandler);
    }

    protected final void addException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this._exceptions.add(Companion.asVcsException(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RequiresBackgroundThread
    protected final void runCommitTask(boolean useCustomPostRefresh, @NotNull Function0<Unit> task2) {
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Ref.BooleanRef canceled = new Ref.BooleanRef();
        try {
            ProgressManager.checkCanceled();
            task2.invoke();
        }
        catch (ProcessCanceledException e) {
            canceled.element = true;
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, useCustomPostRefresh, canceled){
                final /* synthetic */ Committer this$0;
                final /* synthetic */ boolean $useCustomPostRefresh;
                final /* synthetic */ Ref.BooleanRef $canceled;
                {
                    this.this$0 = $receiver;
                    this.$useCustomPostRefresh = $useCustomPostRefresh;
                    this.$canceled = $canceled;
                    super(0);
                }

                public final void invoke() {
                    Committer.access$finishCommit(this.this$0, this.$useCustomPostRefresh, this.$canceled.element);
                }
            }), (int)1, null);
        }
        catch (Throwable e2) {
            LOG.warn(e2);
            this.addException(e2);
            {
                catch (Throwable throwable) {
                    ActionsKt.runInEdt$default(null, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (int)1, null);
                    throw throwable;
                }
            }
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (int)1, null);
        }
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void finishCommit(boolean useCustomPostRefresh, boolean canceled) {
        List<VcsException> errors = this.getCommitErrors();
        if (canceled) {
            void $this$forEachLoggingErrors$iv;
            LOG.debug("Commit canceled");
            Collection collection = this.resultHandlers;
            Logger logger$iv = LOG;
            boolean $i$f$forEachLoggingErrors = false;
            for (Object it$iv : $this$forEachLoggingErrors$iv) {
                try {
                    CommitterResultHandler it = (CommitterResultHandler)it$iv;
                    boolean bl = false;
                    it.onCancel();
                }
                catch (Throwable e$iv) {
                    logger$iv.error(e$iv);
                }
            }
        } else if (errors.isEmpty()) {
            LOG.debug("Commit successful");
            Collection $this$forEachLoggingErrors$iv = this.resultHandlers;
            Logger logger$iv = LOG;
            boolean $i$f$forEachLoggingErrors = false;
            for (Object it$iv : $this$forEachLoggingErrors$iv) {
                try {
                    CommitterResultHandler it = (CommitterResultHandler)it$iv;
                    boolean bl = false;
                    it.onSuccess();
                }
                catch (Throwable e$iv) {
                    logger$iv.error(e$iv);
                }
            }
        } else {
            LOG.debug("Commit failed");
            Collection $this$forEachLoggingErrors$iv = this.resultHandlers;
            Logger logger$iv = LOG;
            boolean $i$f$forEachLoggingErrors = false;
            for (Object it$iv : $this$forEachLoggingErrors$iv) {
                try {
                    CommitterResultHandler it = (CommitterResultHandler)it$iv;
                    boolean bl = false;
                    it.onFailure();
                }
                catch (Throwable e$iv) {
                    logger$iv.error(e$iv);
                }
            }
        }
        if (!useCustomPostRefresh) {
            this.fireAfterRefresh();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void fireAfterRefresh() {
        void $this$forEachLoggingErrors$iv;
        Collection collection = this.resultHandlers;
        Logger logger$iv = LOG;
        boolean $i$f$forEachLoggingErrors = false;
        for (Object it$iv : $this$forEachLoggingErrors$iv) {
            try {
                CommitterResultHandler it = (CommitterResultHandler)it$iv;
                boolean bl = false;
                it.onAfterRefresh();
            }
            catch (Throwable e$iv) {
                logger$iv.error(e$iv);
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final List<VcsException> collectErrors(@NotNull List<? extends VcsException> exceptions) {
        return Companion.collectErrors(exceptions);
    }

    public static final /* synthetic */ void access$finishCommit(Committer $this, boolean useCustomPostRefresh, boolean canceled) {
        $this.finishCommit(useCustomPostRefresh, canceled);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Committer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007J\n\u0010\t\u001a\u00020\u0007*\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/commit/Committer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "collectErrors", "", "Lcom/intellij/openapi/vcs/VcsException;", "exceptions", "asVcsException", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nCommitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Committer.kt\ncom/intellij/vcs/commit/Committer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n819#2:136\n847#2,2:137\n*S KotlinDebug\n*F\n+ 1 Committer.kt\ncom/intellij/vcs/commit/Committer$Companion\n*L\n86#1:136\n86#1:137,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<VcsException> collectErrors(@NotNull List<? extends VcsException> exceptions) {
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
            Iterable $this$filterNot$iv = exceptions;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                VcsException it = (VcsException)((Object)element$iv$iv);
                boolean bl = false;
                if (it.isWarning()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final VcsException asVcsException(@NotNull Throwable $this$asVcsException) {
            Intrinsics.checkNotNullParameter((Object)$this$asVcsException, (String)"<this>");
            return $this$asVcsException instanceof VcsException ? (VcsException)$this$asVcsException : new VcsException($this$asVcsException);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

