/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsExecutablePathSelector {
    private final JPanel myMainPanel;
    private final TextFieldWithBrowseButton myPathSelector;
    private final JBCheckBox myProjectPathCheckbox;
    private final JButton myTestButton;
    private final BorderLayoutPanel myErrorComponent;
    @Nullable
    private String mySavedPath;
    @Nullable
    private String myAutoDetectedPath;

    public VcsExecutablePathSelector(@NotNull @Nls String vcsName, @Nullable Disposable disposable, @NotNull ExecutableHandler handler) {
        if (vcsName == null) {
            VcsExecutablePathSelector.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            VcsExecutablePathSelector.$$$reportNull$$$0(1);
        }
        this.myErrorComponent = new BorderLayoutPanel(10, 0);
        this.myAutoDetectedPath = null;
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((int)10, (int)0);
        this.myPathSelector = new TextFieldWithBrowseButton(null, disposable);
        this.myPathSelector.addBrowseFolderListener(VcsBundle.message((String)"executable.select.title", (Object[])new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), (TextComponentAccessor)new MyTextComponentAccessor(handler));
        this.myPathSelector.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsExecutablePathSelector.this.updateTestButtonAvailability();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/VcsExecutablePathSelector$1", "textChanged"));
            }
        });
        panel2.addToCenter((Component)this.myPathSelector);
        this.myTestButton = new JButton(VcsBundle.message((String)"executable.test", (Object[])new Object[0]));
        this.myTestButton.addActionListener(e -> this.testExecutable(handler));
        panel2.addToRight((Component)this.myTestButton);
        this.myProjectPathCheckbox = new JBCheckBox(VcsBundle.message((String)"executable.project.override", (Object[])new Object[0]));
        this.myProjectPathCheckbox.addActionListener(e -> this.handleProjectOverrideStateChanged());
        JBLabel label = new JBLabel(VcsBundle.message((String)"executable.select.label", (Object[])new Object[]{vcsName}));
        label.setLabelFor((Component)panel2);
        this.myMainPanel = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultAnchor(17);
        this.myMainPanel.add((Component)label, gb.nextLine().next().insets((Insets)JBUI.insetsRight((int)10)));
        this.myMainPanel.add((Component)panel2, gb.next().fillCellHorizontally().weightx(1.0));
        this.myMainPanel.add((Component)this.myProjectPathCheckbox, gb.nextLine().next().next());
        this.myMainPanel.add((Component)this.myErrorComponent, gb.nextLine().next().next().insets((Insets)JBUI.insets((int)4, (int)4, (int)0, (int)0)));
    }

    @NotNull
    public BorderLayoutPanel getErrorComponent() {
        BorderLayoutPanel borderLayoutPanel = this.myErrorComponent;
        if (borderLayoutPanel == null) {
            VcsExecutablePathSelector.$$$reportNull$$$0(2);
        }
        return borderLayoutPanel;
    }

    private void handleProjectOverrideStateChanged() {
        if (this.myProjectPathCheckbox.isSelected()) {
            this.mySavedPath = this.getCurrentPath();
        } else if (!Objects.equals(this.getCurrentPath(), this.mySavedPath)) {
            switch (Messages.showYesNoCancelDialog((Component)this.myMainPanel, (String)VcsBundle.message((String)"executable.project.override.reset.message", (Object[])new Object[0]), (String)VcsBundle.message((String)"executable.project.override.reset.title", (Object[])new Object[0]), (String)VcsBundle.message((String)"executable.project.override.reset.globalize", (Object[])new Object[0]), (String)VcsBundle.message((String)"executable.project.override.reset.revert", (Object[])new Object[0]), (String)Messages.getCancelButton(), null)) {
                case 1: {
                    this.myPathSelector.setText(this.mySavedPath);
                    break;
                }
                case 2: {
                    this.myProjectPathCheckbox.setSelected(true);
                }
            }
        }
    }

    @Nullable
    public String getCurrentPath() {
        return StringUtil.nullize((String)this.myPathSelector.getText().trim());
    }

    public boolean isOverridden() {
        return this.myProjectPathCheckbox.isSelected();
    }

    public void setAutoDetectedPath(@Nullable @NlsSafe String autoDetectedPath) {
        StatusText emptyText = ((JBTextField)this.myPathSelector.getTextField()).getEmptyText();
        emptyText.setText((String)(autoDetectedPath != null ? VcsBundle.message((String)"settings.auto.detected", (Object[])new Object[0]) + autoDetectedPath : VcsBundle.message((String)"settings.auto.detected.progress", (Object[])new Object[0])));
        this.myAutoDetectedPath = autoDetectedPath;
        this.updateTestButtonAvailability();
    }

    public void reset(@Nullable @NlsSafe String globalPath, boolean overridden, @Nullable @NlsSafe String projectPath) {
        this.myProjectPathCheckbox.setSelected(overridden);
        if (overridden) {
            this.mySavedPath = globalPath;
            this.myPathSelector.setText(projectPath);
        } else {
            this.myPathSelector.setText(globalPath);
        }
    }

    public boolean isModified(@Nullable String globalPath, boolean overridden, @Nullable String projectPath) {
        if (this.myProjectPathCheckbox.isSelected() != overridden) {
            return true;
        }
        if (this.myProjectPathCheckbox.isSelected()) {
            return !Objects.equals(this.getCurrentPath(), projectPath);
        }
        return !Objects.equals(this.getCurrentPath(), globalPath);
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            VcsExecutablePathSelector.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Nullable
    private String getExecutablePath() {
        return (String)ObjectUtils.chooseNotNull((Object)this.getCurrentPath(), (Object)this.myAutoDetectedPath);
    }

    private void updateTestButtonAvailability() {
        this.myTestButton.setEnabled(this.getExecutablePath() != null);
    }

    private void testExecutable(@NotNull ExecutableHandler handler) {
        String executable;
        if (handler == null) {
            VcsExecutablePathSelector.$$$reportNull$$$0(4);
        }
        if ((executable = this.getExecutablePath()) != null) {
            handler.testExecutable(executable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/VcsExecutablePathSelector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/VcsExecutablePathSelector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "testExecutable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class MyTextComponentAccessor
    implements TextComponentAccessor<JTextField> {
        private final ExecutableHandler myHandler;

        private MyTextComponentAccessor(ExecutableHandler handler) {
            this.myHandler = handler;
        }

        public String getText(JTextField textField) {
            return textField.getText();
        }

        public void setText(JTextField textField, @NotNull String text2) {
            String patchedText;
            if (text2 == null) {
                MyTextComponentAccessor.$$$reportNull$$$0(0);
            }
            textField.setText((patchedText = this.myHandler.patchExecutable(text2)) != null ? patchedText : text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/ui/VcsExecutablePathSelector$MyTextComponentAccessor", "setText"));
        }
    }

    public static interface ExecutableHandler {
        @Nullable
        default public String patchExecutable(@NotNull String executable) {
            if (executable == null) {
                ExecutableHandler.$$$reportNull$$$0(0);
            }
            return null;
        }

        public void testExecutable(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/intellij/util/ui/VcsExecutablePathSelector$ExecutableHandler", "patchExecutable"));
        }
    }
}

