/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.projectlevelman.VcsDefaultMappingDetector;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/impl/projectlevelman/VcsDefaultMappingDetector;", "", "project", "Lcom/intellij/openapi/project/Project;", "rootChecker", "Lcom/intellij/openapi/vcs/VcsRootChecker;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/VcsRootChecker;)V", "checkedDirs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "detectProjectMappings", "", "projectRoots", "", "mappedDirs", "detectVcsForProjectRoot", "projectRoot", "isUnderProject", "f", "isUnderVcsRoot", "file", "isVcsRoot", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsDefaultMappingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDefaultMappingUtils.kt\ncom/intellij/openapi/vcs/impl/projectlevelman/VcsDefaultMappingDetector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,109:1\n1247#2,2:110\n*S KotlinDebug\n*F\n+ 1 VcsDefaultMappingUtils.kt\ncom/intellij/openapi/vcs/impl/projectlevelman/VcsDefaultMappingDetector\n*L\n93#1:110,2\n*E\n"})
final class VcsDefaultMappingDetector {
    @NotNull
    private final Project project;
    @NotNull
    private final VcsRootChecker rootChecker;
    @NotNull
    private final ProjectFileIndex fileIndex;
    @NotNull
    private final Map<VirtualFile, Boolean> checkedDirs;

    public VcsDefaultMappingDetector(@NotNull Project project, @NotNull VcsRootChecker rootChecker) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootChecker, (String)"rootChecker");
        this.project = project;
        this.rootChecker = rootChecker;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        this.fileIndex = projectFileIndex;
        this.checkedDirs = new LinkedHashMap();
    }

    @NotNull
    public final Set<VirtualFile> detectProjectMappings(@NotNull Collection<? extends VirtualFile> projectRoots, @NotNull Set<? extends VirtualFile> mappedDirs) {
        Intrinsics.checkNotNullParameter(projectRoots, (String)"projectRoots");
        Intrinsics.checkNotNullParameter(mappedDirs, (String)"mappedDirs");
        for (VirtualFile virtualFile : mappedDirs) {
            this.checkedDirs.put(virtualFile, true);
        }
        Set vcsRoots = new LinkedHashSet();
        for (VirtualFile virtualFile : projectRoots) {
            VirtualFile root = this.detectVcsForProjectRoot(virtualFile);
            if (root == null) continue;
            vcsRoots.add(root);
        }
        vcsRoots.removeAll((Collection)mappedDirs);
        return vcsRoots;
    }

    private final VirtualFile detectVcsForProjectRoot(VirtualFile projectRoot) {
        for (VirtualFile file : SequencesKt.generateSequence((Object)projectRoot, (Function1)detectVcsForProjectRoot.1.INSTANCE)) {
            if (this.isVcsRoot(file)) {
                return file;
            }
            VirtualFile parent = file.getParent();
            if (parent == null || this.isUnderProject(parent)) continue;
            if (this.rootChecker.areChildrenValidMappings() && this.isUnderVcsRoot(parent)) {
                return file;
            }
            return null;
        }
        return null;
    }

    private final boolean isUnderVcsRoot(VirtualFile file) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)file, (Function1)isUnderVcsRoot.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if (!this.isVcsRoot(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isVcsRoot(VirtualFile file) {
        ProgressManager.checkCanceled();
        Boolean bl = this.checkedDirs.computeIfAbsent(file, arg_0 -> VcsDefaultMappingDetector.isVcsRoot$lambda$1((Function1)new Function1<VirtualFile, Boolean>(this){
            final /* synthetic */ VcsDefaultMappingDetector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VirtualFile key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return VcsDefaultMappingDetector.access$getRootChecker$p(this.this$0).isRoot(key);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"computeIfAbsent(...)");
        return bl;
    }

    private final boolean isUnderProject(VirtualFile f) {
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this, f){
            final /* synthetic */ VcsDefaultMappingDetector this$0;
            final /* synthetic */ VirtualFile $f;
            {
                this.this$0 = $receiver;
                this.$f = $f;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                if (VcsDefaultMappingDetector.access$getProject$p(this.this$0).isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return VcsDefaultMappingDetector.access$getFileIndex$p(this.this$0).isInContent(this.$f);
            }
        }));
    }

    private static final Boolean isVcsRoot$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ VcsRootChecker access$getRootChecker$p(VcsDefaultMappingDetector $this) {
        return $this.rootChecker;
    }

    public static final /* synthetic */ Project access$getProject$p(VcsDefaultMappingDetector $this) {
        return $this.project;
    }

    public static final /* synthetic */ ProjectFileIndex access$getFileIndex$p(VcsDefaultMappingDetector $this) {
        return $this.fileIndex;
    }
}

