/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.ContentRootChangeListener;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ModuleDefaultVcsRootPolicy;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.project.ProjectKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleDefaultVcsRootPolicy;", "Lcom/intellij/openapi/vcs/impl/DefaultVcsRootPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getDefaultVcsRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "MyModulesListener", "intellij.platform.vcs.impl"})
public class ModuleDefaultVcsRootPolicy
extends DefaultVcsRootPolicy {
    public ModuleDefaultVcsRootPolicy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        project.getMessageBus().connect().subscribe(WorkspaceModelTopics.CHANGED, (Object)new MyModulesListener());
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDefaultVcsRoots() {
        Set result2 = new LinkedHashSet();
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null) {
            VirtualFile ideaDir;
            result2.add(baseDir);
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            Path directoryStorePath = ProjectKt.getStateStore((Project)project).getDirectoryStorePath();
            if (directoryStorePath != null && (ideaDir = LocalFileSystem.getInstance().findFileByNioFile(directoryStorePath)) != null) {
                result2.add(ideaDir);
            }
        }
        CollectionsKt.addAll((Collection)result2, (Sequence)((Sequence)ActionsKt.runReadAction((Function0)((Function0)new Function0<Sequence<? extends VirtualFile>>(this){
            final /* synthetic */ ModuleDefaultVcsRootPolicy this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Sequence<VirtualFile> invoke() {
                Project project = this.this$0.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                return SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)WorkspaceModel.Companion.getInstance(project).getCurrentSnapshot().entities(ContentRootEntity.class), (Function1)getDefaultVcsRoots.1.INSTANCE), (Function1)getDefaultVcsRoots.2.INSTANCE), (Function1)getDefaultVcsRoots.3.INSTANCE);
            }
        }))));
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleDefaultVcsRootPolicy$MyModulesListener;", "Lcom/intellij/openapi/vcs/impl/ContentRootChangeListener;", "(Lcom/intellij/openapi/vcs/impl/ModuleDefaultVcsRootPolicy;)V", "contentRootsChanged", "", "removed", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "added", "intellij.platform.vcs.impl"})
    private final class MyModulesListener
    extends ContentRootChangeListener {
        public MyModulesListener() {
            super(true);
        }

        @Override
        public void contentRootsChanged(@NotNull List<? extends VirtualFile> removed2, @NotNull List<? extends VirtualFile> added2) {
            Intrinsics.checkNotNullParameter(removed2, (String)"removed");
            Intrinsics.checkNotNullParameter(added2, (String)"added");
            ModuleDefaultVcsRootPolicy.this.scheduleMappedRootsUpdate();
            ModuleDefaultVcsRootPolicy.this.scheduleRootsChangeProcessing((Collection<VirtualFile>)removed2, (Collection<VirtualFile>)added2);
        }
    }
}

