/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalChangesUnderRoots {
    @NotNull
    public static Map<VirtualFile, Collection<Change>> getChangesUnderRoots(@NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull Project project) {
        if (rootsToSave == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(0);
        }
        if (project == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(1);
        }
        return LocalChangesUnderRoots.getChangesUnderRoots(rootsToSave, ChangeListManager.getInstance((Project)project), project);
    }

    @NotNull
    public static Map<VirtualFile, Collection<Change>> getChangesUnderRoots(@NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull ChangeListManager changeListManager, @NotNull Project project) {
        if (rootsToSave == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(2);
        }
        if (changeListManager == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(3);
        }
        if (project == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(4);
        }
        return LocalChangesUnderRoots.groupChanges(rootsToSave, changeListManager.getAllChanges(), ProjectLevelVcsManager.getInstance((Project)project));
    }

    @NotNull
    private static Map<VirtualFile, Collection<Change>> groupChanges(@NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull Collection<? extends Change> allChanges, @NotNull ProjectLevelVcsManager vcsManager2) {
        if (rootsToSave == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(5);
        }
        if (allChanges == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(6);
        }
        if (vcsManager2 == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(7);
        }
        HashMap<VirtualFile, Collection<Change>> result2 = new HashMap<VirtualFile, Collection<Change>>();
        for (Change change : allChanges) {
            VirtualFile root = LocalChangesUnderRoots.getRootForChange(change, vcsManager2);
            if (root == null || !rootsToSave.contains(root)) continue;
            Collection changes = result2.computeIfAbsent(root, key -> new HashSet());
            changes.add(change);
        }
        HashMap<VirtualFile, Collection<Change>> hashMap = result2;
        if (hashMap == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @Nullable
    private static VirtualFile getRootForChange(@NotNull Change change, @NotNull ProjectLevelVcsManager vcsManager2) {
        if (change == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(9);
        }
        if (vcsManager2 == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(10);
        }
        FilePath bPath = ChangesUtil.getBeforePath((Change)change);
        FilePath aPath = ChangesUtil.getAfterPath((Change)change);
        VirtualFile root = LocalChangesUnderRoots.getRootForPath(aPath, vcsManager2);
        if (root == null && !Comparing.equal((Object)bPath, (Object)aPath)) {
            root = LocalChangesUnderRoots.getRootForPath(bPath, vcsManager2);
        }
        return root;
    }

    @Nullable
    private static VirtualFile getRootForPath(@Nullable FilePath file, @NotNull ProjectLevelVcsManager vcsManager2) {
        if (vcsManager2 == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(11);
        }
        return file == null ? null : vcsManager2.getVcsRootFor(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allChanges";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "groupChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChangesUnderRoots";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "groupChanges";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRootForChange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRootForPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

