/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsBaseRevisionAdviser;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultPatchBaseVersionProvider {
    private static final Logger LOG = Logger.getInstance(DefaultPatchBaseVersionProvider.class);
    private static final Pattern ourTsPattern = Pattern.compile("\\(date ([0-9]+)\\)");
    private static final String ourRevisionPatternTemplate = "\\(revision (%s)\\)";

    public static void getBaseVersionContent(@NotNull Project project, @NotNull String versionId, @NotNull VirtualFile file, @NotNull FilePath pathBeforeRename, @NotNull Processor<? super String> processor2) throws VcsException {
        if (project == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(0);
        }
        if (versionId == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(2);
        }
        if (pathBeforeRename == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(4);
        }
        DefaultPatchBaseVersionProvider.runWithModalProgressIfNeeded(project, VcsBundle.message((String)"progress.text.loading.patch.base.revision", (Object[])new Object[0]), () -> {
            VcsRevisionNumber revision;
            VcsBaseRevisionAdviser revisionAdviser;
            boolean success2;
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
            if (vcs == null) {
                return;
            }
            VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
            if (historyProvider == null) {
                return;
            }
            String vcsRevisionString = DefaultPatchBaseVersionProvider.parseVersionAsRevision(versionId, vcs);
            Date versionDate = DefaultPatchBaseVersionProvider.parseVersionAsDate(versionId);
            if (historyProvider instanceof VcsBaseRevisionAdviser && (success2 = (revisionAdviser = (VcsBaseRevisionAdviser)historyProvider).getBaseVersionContent(pathBeforeRename, processor2, vcsRevisionString != null ? vcsRevisionString : versionId))) {
                return;
            }
            VcsRevisionNumber vcsRevisionNumber = revision = vcsRevisionString != null ? vcs.parseRevisionNumber(vcsRevisionString, pathBeforeRename) : null;
            if (revision == null && versionDate == null) {
                return;
            }
            if (revision != null && !(historyProvider instanceof VcsBaseRevisionAdviser)) {
                boolean loadedExactRevision = false;
                DiffProvider diffProvider = vcs.getDiffProvider();
                if (diffProvider != null) {
                    ContentRevision fileContent = diffProvider.createFileContent(revision, file);
                    boolean bl = loadedExactRevision = fileContent != null && !processor2.process((Object)fileContent.getContent());
                }
                if (loadedExactRevision) {
                    return;
                }
            }
            ProgressManager.progress2((String)VcsBundle.message((String)"loading.text2.file.history.progress", (Object[])new Object[0]));
            VcsHistorySession historySession = historyProvider.createSessionFor(pathBeforeRename);
            if (historySession == null) {
                return;
            }
            List list = historySession.getRevisionList();
            if (list == null) {
                return;
            }
            VcsFileRevision foundRevision = (VcsFileRevision)ContainerUtil.find((Iterable)list, fileRevision -> {
                if (revision != null) {
                    return fileRevision.getRevisionNumber().compareTo((Object)revision) <= 0;
                }
                Date date = fileRevision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)fileRevision).getAuthorDate() : fileRevision.getRevisionDate();
                return date != null && (date.before(versionDate) || date.equals(versionDate));
            });
            if (foundRevision != null) {
                try {
                    byte[] byteContent = foundRevision.loadContent();
                    if (byteContent == null) {
                        return;
                    }
                    CharSequence content = LoadTextUtil.getTextByBinaryPresentation((byte[])byteContent, (VirtualFile)file, (boolean)false, (boolean)false);
                    processor2.process((Object)content.toString());
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
    }

    @Nullable
    private static String parseVersionAsRevision(@NotNull String versionId, @NotNull AbstractVcs vcs) {
        Pattern revisionPattern;
        Matcher revisionMatcher;
        String vcsPattern;
        if (versionId == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(5);
        }
        if (vcs == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(6);
        }
        if ((vcsPattern = vcs.getRevisionPattern()) != null && (revisionMatcher = (revisionPattern = Pattern.compile(String.format(ourRevisionPatternTemplate, vcsPattern))).matcher(versionId)).find()) {
            return revisionMatcher.group(1);
        }
        return null;
    }

    @Nullable
    private static Date parseVersionAsDate(@NotNull String versionId) {
        if (versionId == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(7);
        }
        try {
            Matcher tsMatcher = ourTsPattern.matcher(versionId);
            if (tsMatcher.find()) {
                long fromTsPattern = Long.parseLong(tsMatcher.group(1));
                return new Date(fromTsPattern);
            }
            return new Date(versionId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void runWithModalProgressIfNeeded(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String title2, @NotNull VcsRunnable task2) throws VcsException {
        if (title2 == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(8);
        }
        if (task2 == null) {
            DefaultPatchBaseVersionProvider.$$$reportNull$$$0(9);
        }
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)task2, (String)title2, (boolean)true, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBeforeRename";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/DefaultPatchBaseVersionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseVersionContent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseVersionAsRevision";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "parseVersionAsDate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithModalProgressIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

