/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.vcsUtil.RollbackUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class RollbackDialogAction
extends AnAction
implements DumbAware {
    public RollbackDialogAction() {
        ActionUtil.copyFrom((AnAction)this, (String)"ChangesView.Revert");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RollbackDialogAction.$$$reportNull$$$0(0);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes == null) {
            return;
        }
        RollbackChangesDialog.rollbackChanges(project, Arrays.asList(changes));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RollbackDialogAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RollbackDialogAction.$$$reportNull$$$0(2);
        }
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean enabled = changes != null && project != null;
        e.getPresentation().setEnabled(enabled);
        if (enabled) {
            String operationName = RollbackUtil.getRollbackOperationName(project);
            e.getPresentation().setText(operationName + "...");
            e.getPresentation().setDescription(VcsBundle.message((String)"action.message.use.selected.changes.description", (Object[])new Object[]{operationName}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/RollbackDialogAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/RollbackDialogAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

