/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.vcs.console.VcsConsoleTabService;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsNotifier {
    @Deprecated
    public static final NotificationGroup NOTIFICATION_GROUP_ID = (NotificationGroup)Cancellation.forceNonCancellableSectionInClassInitializer(() -> VcsNotifier.toolWindowNotification());
    @Deprecated
    public static final NotificationGroup IMPORTANT_ERROR_NOTIFICATION = (NotificationGroup)Cancellation.forceNonCancellableSectionInClassInitializer(() -> VcsNotifier.importantNotification());
    @Deprecated
    public static final NotificationGroup STANDARD_NOTIFICATION = (NotificationGroup)Cancellation.forceNonCancellableSectionInClassInitializer(() -> VcsNotifier.standardNotification());
    @Deprecated
    public static final NotificationGroup SILENT_NOTIFICATION = (NotificationGroup)Cancellation.forceNonCancellableSectionInClassInitializer(() -> VcsNotifier.silentNotification());
    @NotNull
    protected final Project myProject;

    @NotNull
    public static NotificationGroup toolWindowNotification() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Vcs Messages");
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(0);
        }
        return notificationGroup;
    }

    @NotNull
    public static NotificationGroup standardNotification() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Vcs Notifications");
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(1);
        }
        return notificationGroup;
    }

    @NotNull
    public static NotificationGroup importantNotification() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Vcs Important Messages");
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(2);
        }
        return notificationGroup;
    }

    @NotNull
    public static NotificationGroup silentNotification() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Vcs Silent Notifications");
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(3);
        }
        return notificationGroup;
    }

    public static VcsNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            VcsNotifier.$$$reportNull$$$0(4);
        }
        return (VcsNotifier)project.getService(VcsNotifier.class);
    }

    public VcsNotifier(@NotNull Project project) {
        if (project == null) {
            VcsNotifier.$$$reportNull$$$0(5);
        }
        this.myProject = project;
    }

    @NotNull
    public Notification notify(@NotNull Notification notification) {
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(6);
        }
        if (this.myProject.isDisposed()) {
            Logger.getInstance(VcsNotifier.class).warn("Project is already disposed: " + notification);
        }
        notification.notify(this.myProject);
        Notification notification2 = notification;
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(7);
        }
        return notification2;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(8);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(9);
        }
        Notification notification = this.notifyError(null, title2, message, (NotificationListener)null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(10);
        }
        return notification;
    }

    @NotNull
    public Notification notifyError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(11);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(12);
        }
        Notification notification = this.notifyError(displayId, title2, message, (NotificationListener)null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(13);
        }
        return notification;
    }

    public Notification notifyError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, boolean showDetailsAction) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(14);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(15);
        }
        Notification notification = VcsNotifier.createNotification(VcsNotifier.importantNotification(), displayId, title2, message, NotificationType.ERROR, null);
        if (showDetailsAction) {
            VcsNotifier.addShowDetailsAction(this.myProject, notification);
        }
        return this.notify(notification);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(16);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(17);
        }
        return this.notify(VcsNotifier.importantNotification(), null, title2, message, NotificationType.ERROR, listener2);
    }

    @NotNull
    public Notification notifyError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(18);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(19);
        }
        return this.notify(VcsNotifier.importantNotification(), displayId, title2, message, NotificationType.ERROR, listener2);
    }

    @NotNull
    public Notification notifyError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(20);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(21);
        }
        return this.notify(VcsNotifier.importantNotification(), displayId, title2, message, NotificationType.ERROR, actions);
    }

    @NotNull
    public Notification notifyError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable Collection<? extends Exception> errors) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(22);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(23);
        }
        Notification notification = this.notifyError(displayId, title2, VcsNotifier.buildNotificationMessage(message, errors));
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(24);
        }
        return notification;
    }

    @NotNull
    public Notification notifyWeakError(@NonNls @Nullable String displayId, @NlsContexts.NotificationContent @NotNull String message) {
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(25);
        }
        return this.notify(VcsNotifier.toolWindowNotification(), displayId, "", message, NotificationType.ERROR, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyWeakError(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(26);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(27);
        }
        return this.notify(VcsNotifier.toolWindowNotification(), displayId, title2, message, NotificationType.ERROR, new NotificationAction[0]);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationContent @NotNull String message) {
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(28);
        }
        return this.notify(VcsNotifier.toolWindowNotification(), null, "", message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(29);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(30);
        }
        return this.notify(VcsNotifier.toolWindowNotification(), null, title2, message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifySuccess(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(31);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(32);
        }
        return this.notify(VcsNotifier.toolWindowNotification(), displayId, title2, message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(33);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(34);
        }
        return this.notify(VcsNotifier.toolWindowNotification(), null, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifySuccess(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(35);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(36);
        }
        return this.notify(VcsNotifier.toolWindowNotification(), displayId, title2, message, NotificationType.INFORMATION, listener2);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Notification notifyImportantInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(37);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(38);
        }
        return this.notify(VcsNotifier.importantNotification(), null, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyImportantInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(39);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(40);
        }
        return this.notify(VcsNotifier.importantNotification(), displayId, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyImportantInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(41);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(42);
        }
        return this.notify(VcsNotifier.importantNotification(), displayId, title2, message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Notification notifyInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(43);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(44);
        }
        Notification notification = this.notifyInfo(null, title2, message, null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(45);
        }
        return notification;
    }

    @NotNull
    public Notification notifyInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(46);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(47);
        }
        Notification notification = this.notifyInfo(displayId, title2, message, null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(48);
        }
        return notification;
    }

    @NotNull
    public Notification notifyInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(49);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(50);
        }
        return this.notify(VcsNotifier.toolWindowNotification(), displayId, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyMinorWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(51);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(52);
        }
        Notification notification = this.notifyMinorWarning(displayId, title2, message, (NotificationListener)null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(53);
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationContent @NotNull String message) {
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(54);
        }
        return this.notify(VcsNotifier.standardNotification(), displayId, "", message, NotificationType.WARNING, (NotificationListener)null);
    }

    @NotNull
    public Notification notifyMinorWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(55);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(56);
        }
        return this.notify(VcsNotifier.standardNotification(), displayId, title2, message, NotificationType.WARNING, actions);
    }

    @NotNull
    public Notification notifyMinorWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(57);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(58);
        }
        return this.notify(VcsNotifier.standardNotification(), displayId, title2, message, NotificationType.WARNING, listener2);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Notification notifyWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(59);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(60);
        }
        return this.notify(VcsNotifier.toolWindowNotification(), null, title2, message, NotificationType.WARNING, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(61);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(62);
        }
        Notification notification = this.notifyWarning(displayId, title2, message, new NotificationAction[0]);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(63);
        }
        return notification;
    }

    @NotNull
    public Notification notifyWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(64);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(65);
        }
        return this.notify(VcsNotifier.toolWindowNotification(), displayId, title2, message, NotificationType.WARNING, actions);
    }

    @NotNull
    public Notification notifyImportantWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(66);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(67);
        }
        return this.notify(VcsNotifier.importantNotification(), displayId, title2, message, NotificationType.WARNING, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyImportantWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable Collection<? extends Exception> errors) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(68);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(69);
        }
        Notification notification = this.notifyImportantWarning(displayId, title2, VcsNotifier.buildNotificationMessage(message, errors));
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(70);
        }
        return notification;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Notification notifyImportantWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(71);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(72);
        }
        return this.notify(VcsNotifier.importantNotification(), null, title2, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyImportantWarning(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(73);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(74);
        }
        return this.notify(VcsNotifier.importantNotification(), displayId, title2, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyMinorInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(75);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(76);
        }
        Notification notification = this.notifyMinorInfo(displayId, false, title2, message, new NotificationAction[0]);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(77);
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorInfo(@NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(78);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(79);
        }
        return this.notify(VcsNotifier.standardNotification(), displayId, title2, message, NotificationType.INFORMATION, actions);
    }

    @NotNull
    public Notification notifyMinorInfo(@NonNls @Nullable String displayId, boolean sticky, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(80);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(81);
        }
        return this.notify(sticky ? VcsNotifier.importantNotification() : VcsNotifier.standardNotification(), displayId, title2, message, NotificationType.INFORMATION, actions);
    }

    @NotNull
    public Notification logInfo(@Nullable @NonNls String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(82);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(83);
        }
        return this.notify(VcsNotifier.silentNotification(), displayId, title2, message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    public void showNotificationAndHideExisting(@NotNull Notification notificationToShow) {
        String displayId;
        if (notificationToShow == null) {
            VcsNotifier.$$$reportNull$$$0(84);
        }
        if ((displayId = notificationToShow.getDisplayId()) != null) {
            this.hideAllNotificationsById(displayId);
        }
        notificationToShow.notify(this.myProject);
    }

    public void hideAllNotificationsById(@NotNull String displayId) {
        if (displayId == null) {
            VcsNotifier.$$$reportNull$$$0(85);
        }
        NotificationsManager notificationsManager = NotificationsManager.getNotificationsManager();
        for (Notification notification : notificationsManager.getNotificationsOfType(Notification.class, this.myProject)) {
            if (!displayId.equals(notification.getDisplayId())) continue;
            notification.expire();
        }
    }

    @NotNull
    private static Notification createNotification(@NotNull NotificationGroup notificationGroup, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(86);
        }
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(87);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(88);
        }
        if (type == null) {
            VcsNotifier.$$$reportNull$$$0(89);
        }
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            message = title2;
            title2 = "";
        }
        Notification notification = notificationGroup.createNotification(title2, message, type);
        if (displayId != null && !displayId.isEmpty()) {
            notification.setDisplayId(displayId);
        }
        if (listener2 != null) {
            notification.setListener(listener2);
        }
        Notification notification2 = notification;
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(90);
        }
        return notification2;
    }

    @NotNull
    private Notification notify(@NotNull NotificationGroup notificationGroup, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(91);
        }
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(92);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(93);
        }
        if (type == null) {
            VcsNotifier.$$$reportNull$$$0(94);
        }
        Notification notification = VcsNotifier.createNotification(notificationGroup, displayId, title2, message, type, listener2);
        Notification notification2 = this.notify(notification);
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(95);
        }
        return notification2;
    }

    @NotNull
    private Notification notify(@NotNull NotificationGroup notificationGroup, @NonNls @Nullable String displayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, NotificationAction ... actions) {
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(96);
        }
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(97);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(98);
        }
        if (type == null) {
            VcsNotifier.$$$reportNull$$$0(99);
        }
        Notification notification = VcsNotifier.createNotification(notificationGroup, displayId, title2, message, type, null);
        for (NotificationAction action : actions) {
            notification.addAction((AnAction)action);
        }
        Notification notification2 = this.notify(notification);
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(100);
        }
        return notification2;
    }

    public static void addShowDetailsAction(@NotNull Project project, @NotNull Notification notification) {
        if (project == null) {
            VcsNotifier.$$$reportNull$$$0(101);
        }
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(102);
        }
        if (!VcsConsoleTabService.getInstance(project).isConsoleEmpty()) {
            notification.addAction((AnAction)NotificationAction.createSimple((String)VcsBundle.message((String)"notification.showDetailsInConsole", (Object[])new Object[0]), () -> VcsConsoleTabService.getInstance(project).showConsoleTabAndScrollToTheEnd()));
        }
    }

    @Nls
    @NotNull
    private static String buildNotificationMessage(@Nls String message, @Nullable Collection<? extends Exception> errors) {
        String string = message.replace("\n", "<br/>") + VcsNotifier.stringifyErrors(errors);
        if (string == null) {
            VcsNotifier.$$$reportNull$$$0(103);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String stringifyErrors(@Nullable Collection<? extends Exception> errors) {
        if (errors == null || errors.isEmpty()) {
            return "";
        }
        @Nls StringBuilder content = new StringBuilder();
        for (Exception exception : errors) {
            if (exception instanceof VcsException) {
                VcsException vcsException = (VcsException)((Object)exception);
                for (String message : vcsException.getMessages()) {
                    content.append(message.replace("\n", "<br/>")).append("<br/>");
                }
                continue;
            }
            content.append(exception.getMessage().replace("\n", "<br/>")).append("<br/>");
        }
        String string = content.toString();
        if (string == null) {
            VcsNotifier.$$$reportNull$$$0(104);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 65, 66, 67, 68, 69, 71, 72, 73, 74, 75, 76, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 91, 92, 93, 94, 96, 97, 98, 99, 101, 102 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsNotifier";
                break;
            }
            case 4: 
            case 5: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 46: 
            case 49: 
            case 51: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 80: 
            case 82: 
            case 87: 
            case 92: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 81: 
            case 83: 
            case 88: 
            case 93: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationToShow";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayId";
                break;
            }
            case 86: 
            case 91: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationGroup";
                break;
            }
            case 89: 
            case 94: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toolWindowNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "standardNotification";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "importantNotification";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "silentNotification";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsNotifier";
                break;
            }
            case 7: 
            case 95: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "notify";
                break;
            }
            case 10: 
            case 13: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyError";
                break;
            }
            case 45: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyInfo";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyMinorWarning";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyWarning";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyImportantWarning";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyMinorInfo";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNotificationMessage";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyErrors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "notifyError";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "notifyWeakError";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccess";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "notifyImportantInfo";
                break;
            }
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "notifyInfo";
                break;
            }
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "notifyMinorWarning";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "notifyWarning";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "notifyImportantWarning";
                break;
            }
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "notifyMinorInfo";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationAndHideExisting";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "hideAllNotificationsById";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "addShowDetailsAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 8, 9, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 65, 66, 67, 68, 69, 71, 72, 73, 74, 75, 76, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 91, 92, 93, 94, 96, 97, 98, 99, 101, 102 -> new IllegalArgumentException(string);
        };
    }
}

