/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.project.ProjectKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BaseRevisionTextPatchEP
implements PatchEP {
    public static final Key<Boolean> ourProvideStoredBaseRevisionTextKey = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourProvideStoredBaseRevisionTextKey");
    public static final Key<Map<FilePath, ContentRevision>> ourBaseRevisions = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourBaseRevisionPaths");
    private static final Key<Map<String, String>> ourStoredTexts = Key.create((String)"com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP.ourStoredTexts");
    private static final Logger LOG = Logger.getInstance(BaseRevisionTextPatchEP.class);

    @NotNull
    public String getName() {
        return "com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP";
    }

    public CharSequence provideContent(@NotNull Project project, @NotNull String path2, @Nullable CommitContext commitContext) {
        String content;
        Map map;
        if (project == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(1);
        }
        if (commitContext == null) {
            return null;
        }
        Map baseRevisions = (Map)commitContext.getUserData(ourBaseRevisions);
        if (baseRevisions != null) {
            Path file = BaseRevisionTextPatchEP.resolvePatchPath(project, path2);
            FilePath filePath = VcsContextFactory.getInstance().createFilePath(file, Files.isDirectory(file, new LinkOption[0]));
            ContentRevision baseRevision = (ContentRevision)baseRevisions.get(filePath);
            if (baseRevision != null) {
                try {
                    return baseRevision.getContent();
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        if (Boolean.TRUE.equals(commitContext.getUserData(ourProvideStoredBaseRevisionTextKey)) && (map = (Map)commitContext.getUserData(ourStoredTexts)) != null && (content = (String)map.get(BaseRevisionTextPatchEP.getStoredTextKey(project, path2))) != null) {
            return content;
        }
        return null;
    }

    public void consumeContentBeforePatchApplied(@NotNull Project project, @NotNull String path2, @NotNull CharSequence content, @Nullable CommitContext commitContext) {
        if (project == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(3);
        }
        if (content == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(4);
        }
        if (commitContext == null) {
            return;
        }
        HashMap<String, String> map = (HashMap<String, String>)commitContext.getUserData(ourStoredTexts);
        if (map == null) {
            map = new HashMap<String, String>();
            commitContext.putUserData(ourStoredTexts, map);
        }
        map.put(BaseRevisionTextPatchEP.getStoredTextKey(project, path2), content.toString());
    }

    @Nullable
    public static String getBaseContent(@NotNull Project project, @NotNull String path2, @Nullable CommitContext commitContext) {
        if (project == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(5);
        }
        if (path2 == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(6);
        }
        if (commitContext == null) {
            return null;
        }
        Map map = (Map)commitContext.getUserData(ourStoredTexts);
        if (map != null) {
            String content = (String)map.get(BaseRevisionTextPatchEP.getStoredTextKey(project, path2));
            if (content == null) {
                return null;
            }
            return StringUtil.convertLineSeparators((String)content);
        }
        return null;
    }

    @NotNull
    private static String getStoredTextKey(@NotNull Project project, @NotNull String path2) {
        if (project == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(7);
        }
        if (path2 == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(8);
        }
        String string = BaseRevisionTextPatchEP.resolvePatchPath(project, path2).toString();
        if (string == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static Path resolvePatchPath(@NotNull Project project, @NotNull String path2) {
        if (project == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(10);
        }
        if (path2 == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(11);
        }
        Path path3 = ProjectKt.getStateStore((Project)project).getProjectBasePath().resolve(path2);
        if (path3 == null) {
            BaseRevisionTextPatchEP.$$$reportNull$$$0(12);
        }
        return path3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/BaseRevisionTextPatchEP";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredTextKey";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePatchPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "provideContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "consumeContentBeforePatchApplied";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBaseContent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStoredTextKey";
                break;
            }
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolvePatchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 12 -> new IllegalStateException(string);
        };
    }
}

