/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallChecker;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;
import org.jetbrains.kotlin.wasm.util.JsCodeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmJsCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;)V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "wasm.frontend"})
public final class WasmJsCallChecker
implements CallChecker {
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public WasmJsCallChecker(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkNotNullParameter(constantExpressionEvaluator, "constantExpressionEvaluator");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (context2.isAnnotationContext() || !JsCallChecker.Companion.isJsCall(resolvedCall2)) {
            return;
        }
        DeclarationDescriptor containingDeclaration = context2.getScope().getOwnerDescriptor();
        if (!(containingDeclaration instanceof FunctionDescriptor) && !(containingDeclaration instanceof PropertyDescriptor) || !DescriptorUtilKt.isTopLevelInPackage(containingDeclaration)) {
            context2.getTrace().report(ErrorsWasm.JSCODE_WRONG_CONTEXT.on(reportOn));
        } else {
            DeclarationDescriptor declarationDescriptor = containingDeclaration;
            if (declarationDescriptor instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)containingDeclaration;
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                if (!JsCodeUtilsKt.hasValidJsCodeBody(functionDescriptor, bindingContext)) {
                    context2.getTrace().report(ErrorsWasm.JSCODE_WRONG_CONTEXT.on(reportOn));
                } else {
                    if (((FunctionDescriptor)containingDeclaration).isSuspend()) {
                        context2.getTrace().report(ErrorsWasm.JSCODE_UNSUPPORTED_FUNCTION_KIND.on(reportOn, "suspend function"));
                    }
                    if (((FunctionDescriptor)containingDeclaration).isInline()) {
                        context2.getTrace().report(ErrorsWasm.JSCODE_UNSUPPORTED_FUNCTION_KIND.on(reportOn, "inline function"));
                    }
                    if (((FunctionDescriptor)containingDeclaration).getExtensionReceiverParameter() != null) {
                        context2.getTrace().report(ErrorsWasm.JSCODE_UNSUPPORTED_FUNCTION_KIND.on(reportOn, "function with extension receiver"));
                    }
                    for (ValueParameterDescriptor parameter2 : ((FunctionDescriptor)containingDeclaration).getValueParameters()) {
                        String string2 = parameter2.getName().getIdentifierOrNullIfSpecial();
                        if (string2 != null ? IdentifierPolicyKt.isValidES5Identifier(string2) : false) continue;
                        BindingTrace bindingTrace = context2.getTrace();
                        Intrinsics.checkNotNull(parameter2);
                        PsiElement psiElement = SourceLocationUtilsKt.findPsi(parameter2);
                        if (psiElement == null) {
                            psiElement = reportOn;
                        }
                        bindingTrace.report(ErrorsWasm.JSCODE_INVALID_PARAMETER_NAME.on(psiElement));
                    }
                }
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)containingDeclaration;
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                if (!JsCodeUtilsKt.hasValidJsCodeBody(propertyDescriptor, bindingContext)) {
                    context2.getTrace().report(ErrorsWasm.JSCODE_WRONG_CONTEXT.on(reportOn));
                }
            }
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
        KtElement expression2 = ktElement;
        if (!(expression2 instanceof KtCallExpression)) {
            return;
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression2).getValueArgumentList();
        List<KtValueArgument> arguments2 = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        List<KtValueArgument> list2 = arguments2;
        if (list2 == null || (list2 = CollectionsKt.firstOrNull(list2)) == null || (list2 = ((KtValueArgument)((Object)list2)).getArgumentExpression()) == null) {
            return;
        }
        List<KtValueArgument> argument2 = list2;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context2.getTrace(), "WasmJsCallChecker");
        Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace, "create(...)");
        TemporaryBindingTrace trace = temporaryBindingTrace;
        CompileTimeConstant<?> evaluationResult = this.constantExpressionEvaluator.evaluateExpression((KtExpression)((Object)argument2), trace, TypeUtils.NO_EXPECTED_TYPE);
        String code = JsCallChecker.Companion.extractStringValue(evaluationResult);
        if (code == null) {
            context2.getTrace().report(ErrorsJs.JSCODE_ARGUMENT_SHOULD_BE_CONSTANT.on((KtExpression)((PsiElement)((Object)argument2))));
            return;
        }
        trace.commit();
    }
}

