/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.overrides;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\n\u0010\b\u001a\u00020\u0005*\u00020\t\u00a8\u0006\n"}, d2={"findMemberWithMaxVisibility", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "members", "", "isVisibleForOverride", "", "overriding", "fromSuper", "isEffectivelyPrivate", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrVisibilityUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrVisibilityUtil.kt\norg/jetbrains/kotlin/ir/overrides/IrVisibilityUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1726#2,3:64\n*S KotlinDebug\n*F\n+ 1 IrVisibilityUtil.kt\norg/jetbrains/kotlin/ir/overrides/IrVisibilityUtilKt\n*L\n54#1:64,3\n*E\n"})
public final class IrVisibilityUtilKt {
    public static final boolean isVisibleForOverride(@NotNull IrOverridableMember overriding, @NotNull IrOverridableMember fromSuper) {
        Intrinsics.checkNotNullParameter(overriding, "overriding");
        Intrinsics.checkNotNullParameter(fromSuper, "fromSuper");
        return !DescriptorVisibilities.isPrivate(((IrDeclarationWithVisibility)fromSuper).getVisibility());
    }

    @NotNull
    public static final IrOverridableMember findMemberWithMaxVisibility(@NotNull Collection<? extends IrOverridableMember> members) {
        boolean bl;
        Intrinsics.checkNotNullParameter(members, "members");
        boolean bl2 = bl = !members.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        IrOverridableMember member2 = null;
        for (IrOverridableMember irOverridableMember : members) {
            if (member2 == null) {
                member2 = irOverridableMember;
                continue;
            }
            Integer result2 = DescriptorVisibilities.compare(member2.getVisibility(), irOverridableMember.getVisibility());
            if (result2 == null || result2 >= 0) continue;
            member2 = irOverridableMember;
        }
        IrOverridableMember irOverridableMember = member2;
        if (irOverridableMember == null) {
            throw new IllegalStateException("Could not find a visible member".toString());
        }
        return irOverridableMember;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyPrivate(@NotNull IrDeclarationWithVisibility $this$isEffectivelyPrivate) {
        Intrinsics.checkNotNullParameter($this$isEffectivelyPrivate, "<this>");
        if (!IrVisibilityUtilKt.isEffectivelyPrivate$isNonPrivate($this$isEffectivelyPrivate.getVisibility())) {
            boolean bl;
            List list2;
            IrOverridableDeclaration irOverridableDeclaration;
            if (!Intrinsics.areEqual($this$isEffectivelyPrivate.getVisibility(), DescriptorVisibilities.INVISIBLE_FAKE)) return true;
            IrOverridableDeclaration irOverridableDeclaration2 = irOverridableDeclaration = $this$isEffectivelyPrivate instanceof IrOverridableDeclaration ? (IrOverridableDeclaration)$this$isEffectivelyPrivate : null;
            if (irOverridableDeclaration != null && (list2 = irOverridableDeclaration.getOverriddenSymbols()) != null) {
                boolean bl2;
                void $this$all$iv;
                Iterable iterable = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator2 = $this$all$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return true;
                    Object element$iv = iterator2.next();
                    IrSymbol it = (IrSymbol)element$iv;
                    boolean bl3 = false;
                    IrSymbolOwner irSymbolOwner = it.getOwner();
                    IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
                    if (irDeclarationWithVisibility != null) {
                        if (IrVisibilityUtilKt.isEffectivelyPrivate(irDeclarationWithVisibility)) {
                            bl2 = true;
                            continue;
                        }
                        bl2 = false;
                        continue;
                    }
                    bl2 = false;
                } while (bl2);
                bl = false;
            } else {
                bl = false;
            }
            boolean overridesOnlyPrivateDeclarations = bl;
            if (overridesOnlyPrivateDeclarations) return true;
            IrClass irClass2 = IrUtilsKt.getParentClassOrNull($this$isEffectivelyPrivate);
            if (irClass2 == null) return false;
            boolean bl4 = IrVisibilityUtilKt.isEffectivelyPrivate(irClass2);
            if (!bl4) return false;
            return true;
        }
        IrClass irClass3 = IrUtilsKt.getParentClassOrNull($this$isEffectivelyPrivate);
        if (irClass3 == null) return false;
        boolean bl = IrVisibilityUtilKt.isEffectivelyPrivate(irClass3);
        return bl;
    }

    private static final boolean isEffectivelyPrivate$isNonPrivate(DescriptorVisibility $this$isEffectivelyPrivate_u24isNonPrivate) {
        return Intrinsics.areEqual($this$isEffectivelyPrivate_u24isNonPrivate, DescriptorVisibilities.PUBLIC) || Intrinsics.areEqual($this$isEffectivelyPrivate_u24isNonPrivate, DescriptorVisibilities.PROTECTED) || Intrinsics.areEqual($this$isEffectivelyPrivate_u24isNonPrivate, DescriptorVisibilities.INTERNAL);
    }
}

