/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.preprocessor;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessor;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessorData;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u000e*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u0015\u001a\u00020\u0011*\u00020\u000eH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterConstGetterPreprocessor;", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessor;", "()V", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessorData;", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "hasConstantValue", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "lowerConstRead", "field", "shouldDropConstReceiver", "ir.interpreter"})
public final class IrInterpreterConstGetterPreprocessor
implements IrInterpreterPreprocessor {
    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull IrInterpreterPreprocessorData data2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (Intrinsics.areEqual(declaration.getOrigin(), IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE)) {
            return declaration;
        }
        return IrInterpreterPreprocessor.DefaultImpls.visitFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        Object Owner = expression2.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction = Owner instanceof IrSimpleFunction ? (IrSimpleFunction)Owner : null;
        if (irSimpleFunction == null) {
            return IrInterpreterPreprocessor.DefaultImpls.visitCall(this, expression2, data2);
        }
        IrSimpleFunction function2 = irSimpleFunction;
        Object object = function2.getCorrespondingPropertySymbol();
        if (object == null || (object = (IrProperty)object.getOwner()) == null || (object = ((IrProperty)object).getBackingField()) == null) {
            return IrInterpreterPreprocessor.DefaultImpls.visitCall(this, expression2, data2);
        }
        Object field2 = object;
        IrExpression irExpression = this.lowerConstRead(expression2, (IrField)field2, data2);
        return irExpression != null ? (IrElement)irExpression : IrInterpreterPreprocessor.DefaultImpls.visitCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrInterpreterPreprocessorData data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        IrExpression irExpression = this.lowerConstRead(expression2, (IrField)expression2.getSymbol().getOwner(), data2);
        if (irExpression == null) {
            irExpression = IrInterpreterPreprocessor.DefaultImpls.visitGetField(this, expression2, data2);
        }
        return irExpression;
    }

    private final IrExpression lowerConstRead(IrExpression $this$lowerConstRead, IrField field2, IrInterpreterPreprocessorData data2) {
        Object object;
        IrExpression irExpression;
        IrExpression[] irExpressionArray = $this$lowerConstRead;
        if (irExpressionArray instanceof IrCall) {
            irExpression = ((IrCall)$this$lowerConstRead).getDispatchReceiver();
        } else if (irExpressionArray instanceof IrGetField) {
            irExpression = ((IrGetField)$this$lowerConstRead).getReceiver();
        } else {
            return null;
        }
        IrExpression receiver = irExpression;
        if (receiver == null || !this.hasConstantValue(field2)) {
            return null;
        }
        $this$lowerConstRead.transformChildren(this, data2);
        IrGetObjectValueImpl getObject = new IrGetObjectValueImpl(-1, -1, receiver.getType(), IrTypesKt.getClassOrFail(receiver.getType()));
        IrExpression[] irExpressionArray2 = $this$lowerConstRead;
        if (irExpressionArray2 instanceof IrCall) {
            ((IrCall)$this$lowerConstRead).setDispatchReceiver(getObject);
        } else if (irExpressionArray2 instanceof IrGetField) {
            ((IrGetField)$this$lowerConstRead).setReceiver(getObject);
        }
        if (this.shouldDropConstReceiver(receiver)) {
            object = $this$lowerConstRead;
        } else {
            irExpressionArray2 = new IrExpression[]{receiver, $this$lowerConstRead};
            object = new IrCompositeImpl($this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset(), $this$lowerConstRead.getType(), null, CollectionsKt.listOf(irExpressionArray2));
        }
        return object;
    }

    private final boolean shouldDropConstReceiver(IrExpression $this$shouldDropConstReceiver) {
        return $this$shouldDropConstReceiver instanceof IrGetValue || $this$shouldDropConstReceiver instanceof IrGetObjectValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasConstantValue(@NotNull IrField $this$hasConstantValue) {
        Intrinsics.checkNotNullParameter($this$hasConstantValue, "<this>");
        if ($this$hasConstantValue.isFinal() && $this$hasConstantValue.isStatic() && Intrinsics.areEqual($this$hasConstantValue.getOrigin(), IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && $this$hasConstantValue.getInitializer() != null) {
            return true;
        }
        boolean bl = false;
        boolean implicitConst = bl;
        if (implicitConst) return true;
        IrPropertySymbol irPropertySymbol = $this$hasConstantValue.getCorrespondingPropertySymbol();
        Object object = irPropertySymbol;
        if (irPropertySymbol == null) return false;
        IrProperty irProperty2 = (IrProperty)object.getOwner();
        object = irProperty2;
        if (irProperty2 == null) return false;
        if (!((IrProperty)object).isConst()) return false;
        return true;
    }

    @Override
    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBlock(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitClass(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitElement(this, element, data2);
    }

    @Override
    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull IrInterpreterPreprocessorData data2) {
        return IrInterpreterPreprocessor.DefaultImpls.visitWhileLoop(this, loop2, data2);
    }
}

