/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.expression.FirJsDynamicCallCheckerKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J%\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0082\bR\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\bR\u0018\u0010\t\u001a\u00020\u0006*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0018\u0010\f\u001a\u00020\u0006*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsDynamicCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "isArrayAccessWithMultipleIndices", "", "Lorg/jetbrains/kotlin/fir/expressions/FirCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirCall;)Z", "isInOperator", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Z", "isRangeOperator", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkIdentifier", "namedReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "checkSpreadOperator", "forAllSpreadArgumentsOf", "callback", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsDynamicCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsDynamicCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsDynamicCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,124:1\n100#1,13:125\n100#1,13:139\n46#2:138\n*S KotlinDebug\n*F\n+ 1 FirJsDynamicCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/expression/FirJsDynamicCallChecker\n*L\n60#1:125,13\n92#1:139,13\n74#1:138\n*E\n"})
public final class FirJsDynamicCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirJsDynamicCallChecker INSTANCE = new FirJsDynamicCallChecker();

    private FirJsDynamicCallChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression2.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference callee = firResolvedNamedReference;
        if (!(callee.getResolvedSymbol().getOrigin() instanceof FirDeclarationOrigin.DynamicScope)) {
            this.checkSpreadOperator(expression2, context2, reporter);
            return;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(callee, false, 1, null);
        if (firCallableSymbol == null) {
            throw new IllegalStateException("Resolved call callee without a callable symbol".toString());
        }
        FirCallableSymbol symbol2 = firCallableSymbol;
        if (expression2 instanceof FirCall && this.isArrayAccessWithMultipleIndices((FirCall)((Object)expression2))) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"indexed access with more than one index", (DiagnosticContext)context2, null, 16, null);
        } else if (expression2 instanceof FirFunctionCall && this.isInOperator((FirFunctionCall)expression2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"`in` operation", (DiagnosticContext)context2, null, 16, null);
        } else if (expression2 instanceof FirFunctionCall && this.isRangeOperator((FirFunctionCall)expression2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)('`' + (String)FirJsDynamicCallCheckerKt.access$getNameToOperator$p().get(symbol2.getName()) + "` operation"), (DiagnosticContext)context2, null, 16, null);
        } else if (expression2 instanceof FirComponentCall) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"`destructuring declaration", (DiagnosticContext)context2, null, 16, null);
        } else {
            this.checkIdentifier(callee, reporter, context2);
        }
        FirJsDynamicCallChecker this_$iv = this;
        boolean $i$f$forAllSpreadArgumentsOf = false;
        FirCall firCall = expression2 instanceof FirCall ? (FirCall)((Object)expression2) : null;
        if (firCall != null) {
            FirCall call$iv = firCall;
            for (FirExpression argument$iv : call$iv.getArgumentList().getArguments()) {
                if (!(argument$iv instanceof FirVarargArgumentsExpression)) continue;
                for (FirExpression it$iv : ((FirVarargArgumentsExpression)argument$iv).getArguments()) {
                    if (!(it$iv instanceof FirSpreadArgumentExpression)) continue;
                    FirExpression it = it$iv;
                    boolean bl = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getSPREAD_OPERATOR_IN_DYNAMIC_CALL(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
    }

    private final boolean isArrayAccessWithMultipleIndices(FirCall $this$isArrayAccessWithMultipleIndices) {
        FirReference firReference = FirExpressionUtilKt.getCalleeReference($this$isArrayAccessWithMultipleIndices);
        FirNamedReference firNamedReference = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
        if (firNamedReference == null) {
            return false;
        }
        FirNamedReference callee = firNamedReference;
        KtSourceElement ktSourceElement = callee.getSource();
        if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE)) {
            return false;
        }
        FirCall $this$arguments$iv = $this$isArrayAccessWithMultipleIndices;
        boolean $i$f$getArguments = false;
        FirExpression firExpression2 = CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        Object object = firExpression2 instanceof FirVarargArgumentsExpression ? (FirVarargArgumentsExpression)firExpression2 : null;
        if (object == null || (object = ((FirVarargArgumentsExpression)object).getArguments()) == null) {
            return false;
        }
        Object arguments2 = object;
        return Intrinsics.areEqual(callee.getName(), OperatorNameConventions.GET) && arguments2.size() >= 2 || Intrinsics.areEqual(callee.getName(), OperatorNameConventions.SET) && arguments2.size() >= 3;
    }

    private final boolean isInOperator(FirFunctionCall $this$isInOperator) {
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$isInOperator.getCalleeReference());
        return Intrinsics.areEqual(firResolvedNamedReference != null ? firResolvedNamedReference.getName() : null, OperatorNameConventions.CONTAINS) && $this$isInOperator.getOrigin() == FirFunctionCallOrigin.Operator;
    }

    private final boolean isRangeOperator(FirFunctionCall $this$isRangeOperator) {
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$isRangeOperator.getCalleeReference());
        Name name2 = firResolvedNamedReference != null ? firResolvedNamedReference.getName() : null;
        return (Intrinsics.areEqual(name2, OperatorNameConventions.RANGE_TO) || Intrinsics.areEqual(name2, OperatorNameConventions.RANGE_UNTIL)) && $this$isRangeOperator.getOrigin() == FirFunctionCallOrigin.Operator;
    }

    private final void checkSpreadOperator(FirQualifiedAccessExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirJsDynamicCallChecker this_$iv = this;
        boolean $i$f$forAllSpreadArgumentsOf = false;
        FirCall firCall = expression2 instanceof FirCall ? (FirCall)((Object)expression2) : null;
        if (firCall != null) {
            FirCall call$iv = firCall;
            for (FirExpression argument$iv : call$iv.getArgumentList().getArguments()) {
                if (!(argument$iv instanceof FirVarargArgumentsExpression)) continue;
                for (FirExpression it$iv : ((FirVarargArgumentsExpression)argument$iv).getArguments()) {
                    if (!(it$iv instanceof FirSpreadArgumentExpression)) continue;
                    FirExpression it = it$iv;
                    boolean bl = false;
                    if (!(FirTypeUtilsKt.getConeType(it.getTypeRef()) instanceof ConeDynamicType)) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getWRONG_OPERATION_WITH_DYNAMIC(), (Object)"spread operator", (DiagnosticContext)context2, null, 16, null);
                }
            }
        }
    }

    private final void checkIdentifier(FirResolvedNamedReference namedReference, DiagnosticReporter reporter, CheckerContext context2) {
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping)) {
            return;
        }
        String string2 = namedReference.getName().getIdentifierOrNullIfSpecial();
        if (string2 == null) {
            return;
        }
        String name2 = string2;
        if (!Intrinsics.areEqual(FirJsHelpersKt.sanitizeName(name2), name2)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)namedReference.getSource(), FirJsErrors.INSTANCE.getNAME_CONTAINS_ILLEGAL_CHARS(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

