/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.DeclarationBuckets;
import org.jetbrains.kotlin.fir.analysis.checkers.FirRedeclarationPresenter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirOuterClassTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImplKt;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.util.ListMultimap;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a$\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000fH\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002\u001a\f\u0010\u001e\u001a\u00020\u0005*\u00020\u001aH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0005*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u001f"}, d2={"DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION", "Lorg/jetbrains/kotlin/fir/declarations/impl/FirResolvedDeclarationStatusImpl;", "getDEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION", "()Lorg/jetbrains/kotlin/fir/declarations/impl/FirResolvedDeclarationStatusImpl;", "hasMainFunctionStatus", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getHasMainFunctionStatus", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Z", "isTopLevel", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "checkForLocalRedeclarations", "", "elements", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "groupTopLevelByName", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/DeclarationBuckets;", "declarations", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isExpectAndActual", "declaration1", "declaration2", "isCollectable", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirConflictsHelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,386:1\n1747#2,3:387\n1747#2,3:390\n1747#2,3:393\n800#2,11:417\n1620#2,3:428\n372#3,7:396\n372#3,7:403\n372#3,7:410\n372#3,7:431\n*S KotlinDebug\n*F\n+ 1 FirConflictsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirConflictsHelpersKt\n*L\n55#1:387,3\n56#1:390,3\n58#1:393,3\n115#1:417,11\n116#1:428,3\n99#1:396,7\n102#1:403,7\n111#1:410,7\n120#1:431,7\n*E\n"})
public final class FirConflictsHelpersKt {
    @NotNull
    private static final FirResolvedDeclarationStatusImpl DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION = FirResolvedDeclarationStatusImpl.Companion.getDEFAULT_STATUS_FOR_STATUSLESS_DECLARATIONS();

    @NotNull
    public static final FirResolvedDeclarationStatusImpl getDEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION() {
        return DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION;
    }

    private static final boolean getHasMainFunctionStatus(FirSimpleFunction $this$hasMainFunctionStatus) {
        Object object = FirDeclarationStatusImplKt.getModifiersRepresentation($this$hasMainFunctionStatus.getStatus());
        return Intrinsics.areEqual(object, FirDeclarationStatusImplKt.getModifiersRepresentation(DEFAULT_STATUS_FOR_NORMAL_MAIN_FUNCTION)) ? true : Intrinsics.areEqual(object, FirDeclarationStatusImplKt.getModifiersRepresentation(FirResolvedDeclarationStatusImpl.Companion.getDEFAULT_STATUS_FOR_SUSPEND_MAIN_FUNCTION()));
    }

    private static final boolean isTopLevel(CallableId $this$isTopLevel) {
        return $this$isTopLevel.getClassName() == null;
    }

    private static final boolean isCollectable(FirDeclaration $this$isCollectable) {
        boolean bl;
        FirDeclaration firDeclaration;
        if ($this$isCollectable instanceof FirCallableDeclaration) {
            boolean bl2;
            FirElement it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block24: {
                boolean bl3;
                block23: {
                    $this$any$iv = ((FirCallableDeclaration)$this$isCollectable).getContextReceivers();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (FirContextReceiver)element$iv;
                            boolean bl4 = false;
                            if (!ConeTypeUtilsKt.hasError(FirTypeUtilsKt.getConeType(((FirContextReceiver)it).getTypeRef()))) continue;
                            bl3 = true;
                            break block23;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return false;
                }
                $this$any$iv = ((FirCallableDeclaration)$this$isCollectable).getTypeParameters();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (FirTypeParameterRef)element$iv;
                        boolean bl5 = false;
                        if (!ConeTypeUtilsKt.hasError(FirNestedClassifierScopeKt.toConeType((FirTypeParameterRef)it))) continue;
                        bl2 = true;
                        break block24;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return false;
            }
            Object object = ((FirCallableDeclaration)$this$isCollectable).getReceiverParameter();
            boolean bl6 = object != null && (object = ((FirReceiverParameter)object).getTypeRef()) != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? ConeTypeUtilsKt.hasError((ConeKotlinType)object) : false;
            if (bl6) {
                return false;
            }
            if ($this$isCollectable instanceof FirFunction) {
                boolean bl7;
                block25: {
                    $this$any$iv = ((FirFunction)$this$isCollectable).getValueParameters();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl7 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (FirValueParameter)element$iv;
                            boolean bl8 = false;
                            if (!ConeTypeUtilsKt.hasError(FirTypeUtilsKt.getConeType(((FirValueParameter)it).getReturnTypeRef()))) continue;
                            bl7 = true;
                            break block25;
                        }
                        bl7 = false;
                    }
                }
                if (bl7) {
                    return false;
                }
            }
        }
        if ((firDeclaration = $this$isCollectable) instanceof FirSimpleFunction) {
            KtSourceElement ktSourceElement = $this$isCollectable.getSource();
            bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && !Intrinsics.areEqual(((FirSimpleFunction)$this$isCollectable).getName(), SpecialNames.NO_NAME_PROVIDED);
        } else if (firDeclaration instanceof FirRegularClass) {
            bl = !Intrinsics.areEqual(((FirRegularClass)$this$isCollectable).getName(), SpecialNames.NO_NAME_PROVIDED);
        } else if (firDeclaration instanceof FirProperty) {
            KtSourceElement ktSourceElement = $this$isCollectable.getSource();
            bl = !((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.EnumGeneratedDeclaration);
        } else if (firDeclaration instanceof FirField) {
            KtSourceElement ktSourceElement = $this$isCollectable.getSource();
            bl = !Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.ClassDelegationField.INSTANCE);
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean isExpectAndActual(FirDeclaration declaration1, FirDeclaration declaration2) {
        if (!(declaration1 instanceof FirMemberDeclaration)) {
            return false;
        }
        if (!(declaration2 instanceof FirMemberDeclaration)) {
            return false;
        }
        return ((FirMemberDeclaration)declaration1).getStatus().isExpect() && ((FirMemberDeclaration)declaration2).getStatus().isActual() || ((FirMemberDeclaration)declaration1).getStatus().isActual() && ((FirMemberDeclaration)declaration2).getStatus().isExpect();
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<Name, DeclarationBuckets> groupTopLevelByName(List<? extends FirDeclaration> declarations2) {
        Map groups = new LinkedHashMap();
        for (FirDeclaration firDeclaration : declarations2) {
            Object object;
            Map $this$mapTo$iv;
            Object representation;
            DeclarationBuckets group;
            Object value$iv;
            Object $this$getOrPut$iv;
            boolean $i$f$getOrPut;
            Name key$iv;
            if (!FirConflictsHelpersKt.isCollectable(firDeclaration)) continue;
            FirDeclaration firDeclaration2 = firDeclaration;
            if (firDeclaration2 instanceof FirSimpleFunction) {
                Object object2;
                Map map = groups;
                key$iv = ((FirSimpleFunction)firDeclaration).getName();
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    DeclarationBuckets answer$iv = new DeclarationBuckets();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Collection)((DeclarationBuckets)object2).getSimpleFunctions()).add(TuplesKt.to(firDeclaration, FirRedeclarationPresenter.INSTANCE.represent((FirSimpleFunction)firDeclaration)));
                continue;
            }
            if (firDeclaration2 instanceof FirProperty) {
                Object object3;
                $this$getOrPut$iv = groups;
                key$iv = ((FirProperty)firDeclaration).getName();
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    DeclarationBuckets answer$iv = new DeclarationBuckets();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                group = (DeclarationBuckets)object3;
                representation = FirRedeclarationPresenter.INSTANCE.represent((FirVariable)firDeclaration);
                if (((FirProperty)firDeclaration).getReceiverParameter() != null) {
                    ((Collection)group.getExtensionProperties()).add(TuplesKt.to(firDeclaration, representation));
                    continue;
                }
                ((Collection)group.getProperties()).add(TuplesKt.to(firDeclaration, representation));
                continue;
            }
            if (firDeclaration2 instanceof FirRegularClass) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Object object4;
                representation = groups;
                key$iv = ((FirRegularClass)firDeclaration).getName();
                boolean $i$f$getOrPut32 = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    DeclarationBuckets answer$iv = new DeclarationBuckets();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object4 = answer$iv;
                } else {
                    object4 = value$iv;
                }
                group = (DeclarationBuckets)object4;
                ((Collection)group.getClassLikes()).add(TuplesKt.to(firDeclaration, FirRedeclarationPresenter.INSTANCE.represent((FirRegularClass)firDeclaration)));
                if (((FirRegularClass)firDeclaration).getClassKind() == ClassKind.OBJECT) continue;
                $this$getOrPut$iv = ((FirRegularClass)firDeclaration).getDeclarations();
                boolean $i$f$filterIsInstance = false;
                void $i$f$getOrPut32 = $this$filterIsInstance$iv;
                Object destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof FirConstructor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                Collection destination$iv = group.getConstructors();
                boolean $i$f$mapTo = false;
                destination$iv$iv = $this$mapTo$iv.iterator();
                while (destination$iv$iv.hasNext()) {
                    void it;
                    Object item$iv = destination$iv$iv.next();
                    FirConstructor firConstructor = (FirConstructor)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to(it, FirRedeclarationPresenter.INSTANCE.represent((FirConstructor)it, (FirRegularClass)firDeclaration)));
                }
                continue;
            }
            if (!(firDeclaration2 instanceof FirTypeAlias)) continue;
            $this$mapTo$iv = groups;
            key$iv = ((FirTypeAlias)firDeclaration).getName();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                DeclarationBuckets answer$iv = new DeclarationBuckets();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)((DeclarationBuckets)object).getClassLikes()).add(TuplesKt.to(firDeclaration, FirRedeclarationPresenter.INSTANCE.represent((FirTypeAlias)firDeclaration)));
        }
        return groups;
    }

    public static final void checkForLocalRedeclarations(@NotNull List<? extends FirElement> elements, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (elements.size() <= 1) {
            return;
        }
        ListMultimap<Name, FirBasedSymbol> multimap = new ListMultimap<Name, FirBasedSymbol>();
        for (FirElement firElement : elements) {
            Name name2 = null;
            FirBasedSymbol symbol2 = null;
            FirElement firElement2 = firElement;
            if (firElement2 instanceof FirVariable) {
                symbol2 = ((FirVariable)firElement).getSymbol();
                name2 = ((FirVariable)firElement).getName();
            } else {
                if (firElement2 instanceof FirOuterClassTypeParameterRef) continue;
                if (firElement2 instanceof FirTypeParameterRef) {
                    symbol2 = ((FirTypeParameterRef)firElement).getSymbol();
                    name2 = ((FirTypeParameterSymbol)symbol2).getName();
                } else {
                    symbol2 = null;
                    name2 = null;
                }
            }
            Name name3 = name2;
            boolean bl = name3 != null ? !name3.isSpecial() : false;
            if (!bl) continue;
            FirBasedSymbol firBasedSymbol = symbol2;
            Intrinsics.checkNotNull(firBasedSymbol);
            multimap.put(name2, firBasedSymbol);
        }
        for (Name name4 : multimap.getKeys()) {
            List conflictingElements = (List)multimap.get(name4);
            if (conflictingElements.size() <= 1) continue;
            for (FirBasedSymbol conflictingElement : conflictingElements) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)conflictingElement.getSource(), FirErrors.INSTANCE.getREDECLARATION(), (Object)conflictingElements, (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    public static final /* synthetic */ boolean access$isCollectable(FirDeclaration $receiver) {
        return FirConflictsHelpersKt.isCollectable($receiver);
    }

    public static final /* synthetic */ Map access$groupTopLevelByName(List declarations2) {
        return FirConflictsHelpersKt.groupTopLevelByName(declarations2);
    }

    public static final /* synthetic */ boolean access$isTopLevel(CallableId $receiver) {
        return FirConflictsHelpersKt.isTopLevel($receiver);
    }

    public static final /* synthetic */ boolean access$getHasMainFunctionStatus(FirSimpleFunction $receiver) {
        return FirConflictsHelpersKt.getHasMainFunctionStatus($receiver);
    }

    public static final /* synthetic */ boolean access$isExpectAndActual(FirDeclaration declaration1, FirDeclaration declaration2) {
        return FirConflictsHelpersKt.isExpectAndActual(declaration1, declaration2);
    }
}

