/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanConstant;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BooleanComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntegerZeroComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NonIEEE754FloatComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.PrimitiveToObjectComparison;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMappingKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\nR\u0018\u0010\u000b\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Equals;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "operator", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)V", "getOperator", "()Lcom/intellij/psi/tree/IElementType;", "isClassValue", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Z", "isEnumValue", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "referenceEquals", "left", "right", "leftType", "Lorg/jetbrains/org/objectweb/asm/Type;", "BooleanNullCheck", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nEquals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Equals.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/Equals\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
public final class Equals
extends IntrinsicMethod {
    @NotNull
    private final IElementType operator;

    public Equals(@NotNull IElementType operator) {
        Intrinsics.checkNotNullParameter(operator, "operator");
        this.operator = operator;
    }

    @NotNull
    public final IElementType getOperator() {
        return this.operator;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data2) {
        PromisedValue promisedValue;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(codegen2, "codegen");
        Intrinsics.checkNotNullParameter(data2, "data");
        List<IrExpression> list2 = JvmIrUtilsKt.receiverAndArgs(expression2);
        IrExpression a = list2.get(0);
        IrExpression b = list2.get(1);
        if (IrUtilsKt.isNullConst(a) || IrUtilsKt.isNullConst(b)) {
            PromisedValue promisedValue2;
            IrExpression irValue = IrUtilsKt.isNullConst(a) ? b : a;
            PromisedValue value2 = (PromisedValue)irValue.accept(codegen2, data2);
            if (!AsmUtil.isPrimitive(value2.getType())) {
                Object object = IrTypesKt.getClassOrNull(irValue.getType());
                if (!(object != null && (object = (IrClass)object.getOwner()) != null ? IrDeclarationsKt.isSingleFieldValueClass((IrClass)object) : false) || IrTypeUtilsKt.isNullable(irValue.getType())) {
                    promisedValue2 = new BooleanNullCheck(value2);
                    return promisedValue2;
                }
            }
            value2.discard();
            promisedValue2 = new BooleanConstant(codegen2, false);
            return promisedValue2;
        }
        Type leftType = IrTypeMappingKt.mapTypeAsDeclaration(codegen2.getTypeMapper(), a.getType());
        if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.EQEQEQ.INSTANCE)) return this.referenceEquals(a, b, leftType, codegen2, data2);
        if (Intrinsics.areEqual(expression2.getOrigin(), IrStatementOrigin.EXCLEQEQ.INSTANCE)) {
            return this.referenceEquals(a, b, leftType, codegen2, data2);
        }
        Type rightType = IrTypeMappingKt.mapTypeAsDeclaration(codegen2.getTypeMapper(), b.getType());
        if (AsmUtil.isIntOrLongPrimitive(leftType) && !AsmUtil.isPrimitive(rightType) || AsmUtil.isIntOrLongPrimitive(rightType) && AsmUtil.isBoxedPrimitiveType(leftType)) {
            MaterialValue aValue = PromisedValueKt.materializedAt$default((PromisedValue)a.accept(codegen2, data2), leftType, a.getType(), false, 4, null);
            MaterialValue bValue = PromisedValueKt.materializedAt$default((PromisedValue)b.accept(codegen2, data2), rightType, b.getType(), false, 4, null);
            return new PrimitiveToObjectComparison(this.operator, AsmUtil.isIntOrLongPrimitive(leftType), aValue, bValue);
        }
        if (AsmUtil.isPrimitive(leftType) && Intrinsics.areEqual(leftType, rightType)) {
            if (!Intrinsics.areEqual(leftType, Type.FLOAT_TYPE)) {
                if (!Intrinsics.areEqual(leftType, Type.DOUBLE_TYPE)) return this.referenceEquals(a, b, leftType, codegen2, data2);
            }
            MaterialValue aValue = PromisedValueKt.materializedAt$default((PromisedValue)a.accept(codegen2, data2), leftType, a.getType(), false, 4, null);
            MaterialValue bValue = PromisedValueKt.materializedAt$default((PromisedValue)b.accept(codegen2, data2), rightType, b.getType(), false, 4, null);
            return new NonIEEE754FloatComparison(this.operator, aValue, bValue);
        }
        if (this.isEnumValue(a) || this.isEnumValue(b)) {
            promisedValue = this.referenceEquals(a, b, leftType, codegen2, data2);
            return promisedValue;
        }
        if (this.isClassValue(a) && this.isClassValue(b)) {
            MaterialValue leftValue = codegen2.generateClassLiteralReference(a, false, true, data2);
            MaterialValue rightValue = codegen2.generateClassLiteralReference(b, false, true, data2);
            promisedValue = new BooleanComparison(this.operator, leftValue, rightValue);
            return promisedValue;
        }
        PromisedValue promisedValue3 = (PromisedValue)a.accept(codegen2, data2);
        Type type2 = AsmTypes.OBJECT_TYPE;
        Intrinsics.checkNotNullExpressionValue(type2, "OBJECT_TYPE");
        PromisedValueKt.materializeAt(promisedValue3, type2, codegen2.getContext().getIrBuiltIns().getAnyNType());
        PromisedValue promisedValue4 = (PromisedValue)b.accept(codegen2, data2);
        Type type3 = AsmTypes.OBJECT_TYPE;
        Intrinsics.checkNotNullExpressionValue(type3, "OBJECT_TYPE");
        PromisedValueKt.materializeAt(promisedValue4, type3, codegen2.getContext().getIrBuiltIns().getAnyNType());
        DescriptorAsmUtil.genAreEqualCall(codegen2.getMv());
        Type type4 = Type.BOOLEAN_TYPE;
        Intrinsics.checkNotNullExpressionValue(type4, "BOOLEAN_TYPE");
        promisedValue = new MaterialValue(codegen2, type4, codegen2.getContext().getIrBuiltIns().getBooleanType());
        return promisedValue;
    }

    private final PromisedValue referenceEquals(IrExpression left, IrExpression right, Type leftType, ExpressionCodegen codegen2, BlockInfo data2) {
        PromisedValue promisedValue;
        Type operandType;
        Type type2 = operandType = !AsmUtil.isPrimitive(leftType) ? AsmTypes.OBJECT_TYPE : leftType;
        if (Intrinsics.areEqual(operandType, Type.INT_TYPE) && (IrUtilsKt.isIntegerConst(left, 0) || IrUtilsKt.isIntegerConst(right, 0))) {
            IrExpression nonZero = IrUtilsKt.isIntegerConst(left, 0) ? right : left;
            PromisedValue promisedValue2 = (PromisedValue)nonZero.accept(codegen2, data2);
            Intrinsics.checkNotNull(operandType);
            promisedValue = new IntegerZeroComparison(PromisedValueKt.materializedAt$default(promisedValue2, operandType, nonZero.getType(), false, 4, null));
        } else {
            PromisedValue promisedValue3 = (PromisedValue)left.accept(codegen2, data2);
            Intrinsics.checkNotNull(operandType);
            MaterialValue leftValue = PromisedValueKt.materializedAt$default(promisedValue3, operandType, left.getType(), false, 4, null);
            MaterialValue rightValue = PromisedValueKt.materializedAt$default((PromisedValue)right.accept(codegen2, data2), operandType, right.getType(), false, 4, null);
            promisedValue = new BooleanComparison(this.operator, leftValue, rightValue);
        }
        return promisedValue;
    }

    private final boolean isEnumValue(IrExpression $this$isEnumValue) {
        boolean bl;
        Object object = IrTypesKt.getClassOrNull($this$isEnumValue.getType());
        if (object != null && (object = (IrClass)object.getOwner()) != null) {
            Object $this$_get_isEnumValue__u24lambda_u240 = object;
            boolean bl2 = false;
            bl = IrUtilsKt.isEnumClass((IrClass)$this$_get_isEnumValue__u24lambda_u240) || IrUtilsKt.isEnumEntry((IrClass)$this$_get_isEnumValue__u24lambda_u240);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isClassValue(IrExpression $this$isClassValue) {
        return $this$isClassValue instanceof IrGetClass || $this$isClassValue instanceof IrClassReference;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Equals$BooleanNullCheck;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "value", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "(Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;)V", "getValue", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "discard", "", "jumpIfFalse", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "backend.jvm.codegen"})
    @SourceDebugExtension(value={"SMAP\nEquals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Equals.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/Equals$BooleanNullCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
    private static final class BooleanNullCheck
    extends BooleanValue {
        @NotNull
        private final PromisedValue value;

        public BooleanNullCheck(@NotNull PromisedValue value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            super(value2.getCodegen());
            this.value = value2;
        }

        @NotNull
        public final PromisedValue getValue() {
            return this.value;
        }

        @Override
        public void jumpIfFalse(@NotNull Label target) {
            Unit unit2;
            Intrinsics.checkNotNullParameter(target, "target");
            PromisedValueKt.materialize(this.value);
            Unit it = unit2 = Unit.INSTANCE;
            boolean bl = false;
            this.getMv().ifnonnull(target);
        }

        @Override
        public void jumpIfTrue(@NotNull Label target) {
            Unit unit2;
            Intrinsics.checkNotNullParameter(target, "target");
            PromisedValueKt.materialize(this.value);
            Unit it = unit2 = Unit.INSTANCE;
            boolean bl = false;
            this.getMv().ifnull(target);
        }

        @Override
        public void discard() {
            this.value.discard();
        }
    }
}

