/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.ChangeProcessor;
import com.intellij.history.core.ChangeProcessorBase;
import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.codeStyle.NameUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a<\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nH\u0007\u001a(\u0010\f\u001a\u00020\r*\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0000\u001aV\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\r2\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\r0\u001bH\u0007\u001a\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0011*\u0004\u0018\u00010\u0004H\u0000\u00a8\u0006\u001d"}, d2={"collectChanges", "", "Lcom/intellij/history/core/LocalHistoryFacade;", "startPath", "", "processor", "Lcom/intellij/history/core/ChangeProcessor;", "projectId", "patternString", "consumer", "Lkotlin/Function1;", "Lcom/intellij/history/core/changes/ChangeSet;", "matches", "", "Lcom/intellij/history/core/changes/Change;", "path", "pattern", "Ljava/util/regex/Pattern;", "processContents", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "root", "Lcom/intellij/history/core/tree/RootEntry;", "changeSets", "", "", "before", "Lkotlin/Function2;", "toPattern", "intellij.platform.lvcs.impl"})
public final class LocalHistoryFacadeKt {
    @ApiStatus.Experimental
    public static final void collectChanges(@NotNull LocalHistoryFacade $this$collectChanges, @Nullable String projectId, @NotNull String startPath, @Nullable String patternString, @NotNull Function1<? super ChangeSet, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)$this$collectChanges, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        LocalHistoryFacadeKt.collectChanges($this$collectChanges, startPath, new ChangeProcessorBase(projectId, patternString, consumer));
    }

    @ApiStatus.Internal
    public static final void collectChanges(@NotNull LocalHistoryFacade $this$collectChanges, @NotNull String startPath, @NotNull ChangeProcessor processor2) {
        Intrinsics.checkNotNullParameter((Object)$this$collectChanges, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
        String path = startPath;
        boolean pathExists = true;
        for (ChangeSet changeSet : $this$collectChanges.getChanges$intellij_platform_lvcs_impl()) {
            PutLabelChange singleLabel;
            List<Change> changeSetChanges = changeSet.getChanges();
            Intrinsics.checkNotNull(changeSetChanges);
            Iterator iterator = CollectionsKt.singleOrNull(changeSetChanges);
            PutLabelChange putLabelChange = singleLabel = iterator instanceof PutLabelChange ? (PutLabelChange)((Object)iterator) : null;
            if (singleLabel != null) {
                if (!pathExists) continue;
                processor2.process(changeSet, singleLabel, path);
                continue;
            }
            for (Change change : CollectionsKt.reversed((Iterable)changeSetChanges)) {
                if (change instanceof PutLabelChange) continue;
                if (!pathExists) {
                    if (change instanceof StructuralChange) {
                        Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(path), (String)"revertPath(...)");
                    }
                    if (!(change instanceof DeleteChange) || !((DeleteChange)change).isDeletionOf(path)) continue;
                    processor2.process(changeSet, change, path);
                    pathExists = true;
                    continue;
                }
                Intrinsics.checkNotNull((Object)change);
                processor2.process(changeSet, change, path);
                if (change instanceof StructuralChange) {
                    Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(path), (String)"revertPath(...)");
                }
                if (!(change instanceof CreateEntryChange) || !change.isCreationalFor(path)) continue;
                pathExists = false;
            }
        }
    }

    @Nullable
    public static final Pattern toPattern(@Nullable String $this$toPattern) {
        if ($this$toPattern == null) {
            return null;
        }
        return Pattern.compile(NameUtil.buildRegexp((String)$this$toPattern, (int)0, (boolean)true, (boolean)true), 2);
    }

    public static final boolean matches(@NotNull Change $this$matches, @Nullable String projectId, @NotNull String path, @Nullable Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!$this$matches.affectsPath(path) && !$this$matches.affectsProject(projectId)) {
            return false;
        }
        return pattern == null || $this$matches.affectsMatching(pattern);
    }

    @ApiStatus.Internal
    public static final void processContents(@NotNull LocalHistoryFacade $this$processContents, @NotNull IdeaGateway gateway, @NotNull RootEntry root, @NotNull String startPath, @NotNull Set<Long> changeSets, boolean before, @NotNull Function2<? super Long, ? super String, Boolean> processor2) {
        Intrinsics.checkNotNullParameter((Object)$this$processContents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        Intrinsics.checkNotNullParameter(changeSets, (String)"changeSets");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Function2 processContents2 = (Function2)new Function2<Long, String, Boolean>(changeSets, root, processor2, gateway){
            final /* synthetic */ Set<Long> $changeSets;
            final /* synthetic */ RootEntry $root;
            final /* synthetic */ Function2<Long, String, Boolean> $processor;
            final /* synthetic */ IdeaGateway $gateway;
            {
                this.$changeSets = $changeSets;
                this.$root = $root;
                this.$processor = $processor;
                this.$gateway = $gateway;
                super(2);
            }

            @NotNull
            public final Boolean invoke(long changeSetId, @NotNull String path) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                if (!this.$changeSets.contains(changeSetId)) {
                    return true;
                }
                Entry entry = this.$root.findEntry(path);
                return (Boolean)this.$processor.invoke((Object)changeSetId, (object = entry) != null && (object = ((Entry)object).getContent()) != null ? ((Content)object).getString(entry, this.$gateway) : null);
            }
        };
        String path = startPath;
        for (ChangeSet changeSet : $this$processContents.getChanges$intellij_platform_lvcs_impl()) {
            ProgressManager.checkCanceled();
            if (Thread.currentThread().isInterrupted()) {
                throw new ProcessCanceledException();
            }
            if (!before && !((Boolean)processContents2.invoke((Object)changeSet.getId(), (Object)path)).booleanValue()) break;
            List<Change> list = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChanges(...)");
            for (Change change : CollectionsKt.reversed((Iterable)list)) {
                if (!(change instanceof StructuralChange) || !change.affectsPath(path)) continue;
                ((StructuralChange)change).revertOn(root, false);
                Intrinsics.checkNotNullExpressionValue((Object)((StructuralChange)change).revertPath(path), (String)"revertPath(...)");
            }
            if (!before || ((Boolean)processContents2.invoke((Object)changeSet.getId(), (Object)path)).booleanValue()) continue;
            break;
        }
    }
}

