/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreatorBase;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderImpl;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SkipAllInstructionCreator;

public final class PackIntoArchiveInstructionCreator
extends ArtifactCompilerInstructionCreatorBase {
    private final DestinationInfo myJarDestination;
    private final JarInfo myJarInfo;
    private final String myPathInJar;

    public PackIntoArchiveInstructionCreator(ArtifactInstructionsBuilderImpl builder, JarInfo jarInfo, String pathInJar, DestinationInfo jarDestination) {
        super(builder);
        this.myJarInfo = jarInfo;
        this.myPathInJar = pathInJar;
        this.myJarDestination = jarDestination;
    }

    @Override
    @Nullable
    protected DestinationInfo createDirectoryDestination() {
        return new JarDestinationInfo(this.myPathInJar, this.myJarInfo, this.myJarDestination);
    }

    @Override
    protected JarDestinationInfo createFileDestination(@NotNull String pathInJar) {
        if (pathInJar == null) {
            PackIntoArchiveInstructionCreator.$$$reportNull$$$0(0);
        }
        return new JarDestinationInfo(this.childPathInJar(pathInJar), this.myJarInfo, this.myJarDestination);
    }

    @Override
    protected void onAdded(ArtifactRootDescriptor descriptor) {
        this.myJarInfo.addContent(StringUtil.trimStart((String)((JarDestinationInfo)descriptor.getDestinationInfo()).getPathInJar(), (String)"/"), descriptor);
    }

    private String childPathInJar(String fileName) {
        return this.myPathInJar.length() == 0 ? fileName : this.myPathInJar + "/" + fileName;
    }

    @Override
    public PackIntoArchiveInstructionCreator subFolder(@NotNull String directoryName) {
        if (directoryName == null) {
            PackIntoArchiveInstructionCreator.$$$reportNull$$$0(1);
        }
        return new PackIntoArchiveInstructionCreator(this.myInstructionsBuilder, this.myJarInfo, this.childPathInJar(directoryName), this.myJarDestination);
    }

    @Override
    public ArtifactCompilerInstructionCreator archive(@NotNull String archiveFileName) {
        String outputPath;
        JarDestinationInfo destination;
        JarInfo jarInfo;
        if (archiveFileName == null) {
            PackIntoArchiveInstructionCreator.$$$reportNull$$$0(2);
        }
        if (!this.myInstructionsBuilder.registerJarFile(jarInfo = new JarInfo(destination = this.createFileDestination(archiveFileName)), outputPath = this.myJarDestination.getOutputPath() + "/" + archiveFileName)) {
            return new SkipAllInstructionCreator(this.myInstructionsBuilder);
        }
        this.myJarInfo.addJar(destination.getPathInJar(), jarInfo);
        return new PackIntoArchiveInstructionCreator(this.myInstructionsBuilder, jarInfo, "", destination);
    }

    @Override
    @Nullable
    public File getTargetDirectory() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveFileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/artifacts/instructions/PackIntoArchiveInstructionCreator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileDestination";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "subFolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "archive";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

