/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/AbstractHighlightingPassBase;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Document;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "applyInformationInBackground", "", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "doApplyInformationToEditor", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runAnnotatorWithContext", "element", "Lcom/intellij/psi/PsiElement;", "Companion", "kotlin.highlighting.minimal"})
public abstract class AbstractHighlightingPassBase
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFile file;
    private static volatile boolean IGNORE_IN_TESTS;

    public AbstractHighlightingPassBase(@NotNull PsiFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(file.getProject(), document);
        this.file = file;
    }

    @NotNull
    protected final PsiFile getFile() {
        return this.file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        HighlightInfoHolder holder = new HighlightInfoHolder(this.file, new HighlightInfoFilter[0]);
        this.runAnnotatorWithContext((PsiElement)this.file, holder);
        this.applyInformationInBackground(holder);
    }

    protected void runAnnotatorWithContext(@NotNull PsiElement element2, @NotNull HighlightInfoHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    public void doApplyInformationToEditor() {
    }

    private final void applyInformationInBackground(HighlightInfoHolder holder) {
        if (IGNORE_IN_TESTS) {
            boolean bl = ApplicationManager.getApplication().isUnitTestMode();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return;
        }
        List result = new ArrayList(holder.size());
        int n = holder.size();
        for (int i = 0; i < n; ++i) {
            HighlightInfo highlightInfo = holder.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfo, (String)"get(...)");
            result.add(highlightInfo);
        }
        BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)this.file, (Document)this.myDocument, (int)0, (int)this.file.getTextLength(), (Collection)result, (int)this.getId());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bH\u0007\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/AbstractHighlightingPassBase$Companion;", "", "()V", "IGNORE_IN_TESTS", "", "ignoreThesePassesInTests", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin.highlighting.minimal"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TestOnly
        public final <T> T ignoreThesePassesInTests(@NotNull Function0<? extends T> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            boolean bl = ApplicationManager.getApplication().isUnitTestMode();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            IGNORE_IN_TESTS = true;
            try {
                Object object = action.invoke();
                return (T)object;
            }
            finally {
                IGNORE_IN_TESTS = false;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

