/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinIndentationAdjuster;
import org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinLangLineIndentProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinLineIndentProvider;", "Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinLangLineIndentProvider;", "()V", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "indentionSettings", "Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinIndentationAdjuster;", "Companion", "kotlin.formatter.minimal"})
public final class KotlinLineIndentProvider
extends KotlinLangLineIndentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean useFormatter;

    @Override
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return useFormatter ? null : super.getLineIndent(project, editor, language, offset);
    }

    @Override
    @NotNull
    public KotlinIndentationAdjuster indentionSettings(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return new KotlinIndentationAdjuster(editor){
            private final CodeStyleSettings settings;
            {
                this.settings = CodeStyle.getSettings((Editor)$editor);
            }

            public final CodeStyleSettings getSettings() {
                return this.settings;
            }

            @NotNull
            public final KotlinCommonCodeStyleSettings getCommonSettings() {
                CodeStyleSettings codeStyleSettings = this.settings;
                Intrinsics.checkNotNull((Object)codeStyleSettings);
                return CodeStyleUtilsKt.getKotlinCommonSettings(codeStyleSettings);
            }

            @NotNull
            public final KotlinCodeStyleSettings getCustomSettings() {
                CodeStyleSettings codeStyleSettings = this.settings;
                Intrinsics.checkNotNull((Object)codeStyleSettings);
                return CodeStyleUtilsKt.getKotlinCustomSettings(codeStyleSettings);
            }

            public boolean getAlignWhenMultilineFunctionParentheses() {
                return this.getCommonSettings().ALIGN_MULTILINE_METHOD_BRACKETS;
            }

            public boolean getAlignWhenMultilineBinaryExpression() {
                return this.getCommonSettings().ALIGN_MULTILINE_BINARY_OPERATION;
            }

            public boolean getContinuationIndentInElvis() {
                return this.getCustomSettings().CONTINUATION_INDENT_IN_ELVIS;
            }

            public boolean getContinuationIndentForExpressionBodies() {
                return this.getCustomSettings().CONTINUATION_INDENT_FOR_EXPRESSION_BODIES;
            }

            public boolean getAlignMultilineParameters() {
                return this.getCommonSettings().ALIGN_MULTILINE_PARAMETERS;
            }

            public boolean getAlignMultilineParametersInCalls() {
                return this.getCommonSettings().ALIGN_MULTILINE_PARAMETERS_IN_CALLS;
            }

            public boolean getContinuationIndentInArgumentLists() {
                return this.getCustomSettings().CONTINUATION_INDENT_IN_ARGUMENT_LISTS;
            }

            public boolean getContinuationIndentInParameterLists() {
                return this.getCustomSettings().CONTINUATION_INDENT_IN_PARAMETER_LISTS;
            }

            public boolean getContinuationIndentInIfCondition() {
                return this.getCustomSettings().CONTINUATION_INDENT_IN_IF_CONDITIONS;
            }

            public boolean getContinuationIndentForChainedCalls() {
                return this.getCustomSettings().CONTINUATION_INDENT_FOR_CHAINED_CALLS;
            }

            public boolean getIndentBeforeArrowOnNewLine() {
                return this.getCustomSettings().INDENT_BEFORE_ARROW_ON_NEW_LINE;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinLineIndentProvider$Companion;", "", "()V", "<set-?>", "", "useFormatter", "getUseFormatter", "()Z", "setUseFormatter", "(Z)V", "kotlin.formatter.minimal"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getUseFormatter() {
            return useFormatter;
        }

        @TestOnly
        public final void setUseFormatter(boolean bl) {
            useFormatter = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

