/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt.error;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.ListLayout;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorDescription;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/error/TerminalPromptErrorUtil;", "", "()V", "createErrorComponent", "Ljavax/swing/JComponent;", "description", "Lorg/jetbrains/plugins/terminal/block/prompt/error/TerminalPromptErrorDescription;", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "intellij.terminal"})
public final class TerminalPromptErrorUtil {
    @NotNull
    public static final TerminalPromptErrorUtil INSTANCE = new TerminalPromptErrorUtil();

    private TerminalPromptErrorUtil() {
    }

    @NotNull
    public final JComponent createErrorComponent(@NotNull TerminalPromptErrorDescription description2, @NotNull EditorColorsScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        JPanel panel = new JPanel((LayoutManager)ListLayout.Companion.horizontal$default((ListLayout.Companion)ListLayout.Companion, (int)0, null, null, (int)7, null));
        panel.setBorder((Border)JBUI.Borders.emptyTop((int)4));
        panel.setOpaque(false);
        JBLabel errorLabel = new JBLabel(description2.getErrorText());
        errorLabel.setCopyable(true);
        errorLabel.setIcon(description2.getIcon());
        errorLabel.setIconTextGap(JBUI.scale((int)6));
        TextAttributes textAttributes = colorScheme.getAttributes(ConsoleViewContentType.ERROR_OUTPUT_KEY);
        errorLabel.setForeground(textAttributes != null ? textAttributes.getForegroundColor() : null);
        panel.add((Component)errorLabel);
        String linkText = description2.getLinkText();
        if (linkText != null) {
            ActionLink linkLabel2 = new ActionLink(linkText, (Function1)new Function1<ActionEvent, Unit>(description2){
                final /* synthetic */ TerminalPromptErrorDescription $description;
                {
                    this.$description = $description;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$description.onLinkClick();
                }
            });
            TextAttributes textAttributes2 = colorScheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR);
            linkLabel2.setForeground(textAttributes2 != null ? textAttributes2.getForegroundColor() : null);
            linkLabel2.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            panel.add((Component)linkLabel2);
        }
        return panel;
    }
}

