/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.LookupPositionStrategy;
import com.intellij.codeInsight.lookup.LookupPresentation;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.TerminalUiSettingsManager;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.documentation.TerminalDocumentationManager;
import org.jetbrains.plugins.terminal.block.history.CommandHistoryPresenter;
import org.jetbrains.plugins.terminal.block.history.CommandSearchPresenter;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptController;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalLookupManagerListener;", "Lcom/intellij/codeInsight/lookup/LookupManagerListener;", "()V", "activeLookupChanged", "", "oldLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "newLookup", "TerminalCompletionLookupListener", "intellij.terminal"})
public final class TerminalLookupManagerListener
implements LookupManagerListener {
    public void activeLookupChanged(@Nullable Lookup oldLookup, @Nullable Lookup newLookup) {
        Lookup lookup = newLookup;
        if (!(lookup != null && (lookup = lookup.getEditor()) != null ? TerminalDataContextUtils.INSTANCE.isPromptEditor((Editor)lookup) : false)) {
            return;
        }
        LookupImpl lookupImpl = newLookup instanceof LookupImpl ? (LookupImpl)newLookup : null;
        if (lookupImpl == null) {
            return;
        }
        LookupImpl lookup2 = lookupImpl;
        lookup2.setPresentation(new LookupPresentation.Builder(null, 1, null).withPositionStrategy(LookupPositionStrategy.ONLY_ABOVE).withMostRelevantOnTop(false).withMaxVisibleItemsCount((ReadWriteProperty)new ReadWriteProperty<LookupPresentation, Integer>(){

            @NotNull
            public Integer getValue(@NotNull LookupPresentation thisRef, @NotNull KProperty<?> property) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                return TerminalUiSettingsManager.Companion.getInstance().getMaxVisibleCompletionItemsCount();
            }

            public void setValue(@NotNull LookupPresentation thisRef, @NotNull KProperty<?> property, int value) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                TerminalUiSettingsManager.Companion.getInstance().setMaxVisibleCompletionItemsCount(Math.max(5, value));
            }
        }).build());
        lookup2.addLookupListener((LookupListener)new TerminalCompletionLookupListener());
        Project project = lookup2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TerminalDocumentationManager.Companion.getInstance(project).autoShowDocumentationOnItemChange((LookupEx)lookup2, (Disposable)lookup2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalLookupManagerListener$TerminalCompletionLookupListener;", "Lcom/intellij/codeInsight/lookup/LookupListener;", "()V", "executeCommand", "", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "itemSelected", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "intellij.terminal"})
    private static final class TerminalCompletionLookupListener
    implements LookupListener {
        public void itemSelected(@NotNull LookupEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Lookup lookup = event.getLookup();
            LookupElement chosenItem = event.getItem();
            if (lookup == null || CommandHistoryPresenter.Companion.isTerminalCommandHistory(lookup) || CommandSearchPresenter.Companion.isTerminalCommandSearch(lookup) || event.getCompletionChar() != '\n' || chosenItem == null) {
                return;
            }
            String string = lookup.itemPattern(chosenItem);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPattern(...)");
            String typedString = string;
            if (Intrinsics.areEqual((Object)typedString, (Object)chosenItem.getLookupString()) || Intrinsics.areEqual((Object)(typedString + "/"), (Object)chosenItem.getLookupString())) {
                this.executeCommand(lookup);
            }
        }

        private final void executeCommand(Lookup lookup) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)lookup.getEditor().getComponent());
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            DataContext dataContext2 = dataContext;
            TerminalPromptController terminalPromptController = TerminalDataContextUtils.INSTANCE.getPromptController$intellij_terminal(dataContext2);
            if (terminalPromptController == null) {
                return;
            }
            TerminalPromptController promptController = terminalPromptController;
            ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(promptController){
                final /* synthetic */ TerminalPromptController $promptController;
                {
                    this.$promptController = $promptController;
                    super(0);
                }

                public final void invoke() {
                    this.$promptController.handleEnterPressed();
                }
            }), (int)1, null);
        }
    }
}

