/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.output.EmptyTextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TerminalTextHighlighterKt;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TextWithAttributes;
import org.jetbrains.plugins.terminal.block.output.TextWithHighlightings;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderer;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderingInfo;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptState;
import org.jetbrains.plugins.terminal.block.prompt.TerminalSessionInfo;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/BuiltInPromptRenderer;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderer;", "sessionInfo", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalSessionInfo;", "isSingleLine", "", "(Lorg/jetbrains/plugins/terminal/block/prompt/TerminalSessionInfo;Z)V", "calculateDirectoryText", "", "Lcom/intellij/openapi/util/NlsSafe;", "directory", "calculateRenderingInfo", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "state", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptState;", "getPromptComponents", "", "Lorg/jetbrains/plugins/terminal/block/output/TextWithAttributes;", "plainAttributes", "Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "colorIndex", "", "intellij.terminal"})
public final class BuiltInPromptRenderer
implements TerminalPromptRenderer {
    @NotNull
    private final TerminalSessionInfo sessionInfo;
    private final boolean isSingleLine;

    public BuiltInPromptRenderer(@NotNull TerminalSessionInfo sessionInfo, boolean isSingleLine) {
        Intrinsics.checkNotNullParameter((Object)sessionInfo, (String)"sessionInfo");
        this.sessionInfo = sessionInfo;
        this.isSingleLine = isSingleLine;
    }

    @Override
    @NotNull
    public TerminalPromptRenderingInfo calculateRenderingInfo(@NotNull TerminalPromptState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        TextWithHighlightings content = TerminalTextHighlighterKt.toTextWithHighlightings(this.getPromptComponents(state));
        return new TerminalPromptRenderingInfo(content.getText(), content.getHighlightings(), null, null, 12, null);
    }

    private final List<TextWithAttributes> getPromptComponents(TerminalPromptState state) {
        CharSequence venvName;
        List result2 = new ArrayList();
        TextAttributesProvider greenAttributes = this.plainAttributes(2);
        TextAttributesProvider yellowAttributes = this.plainAttributes(3);
        EmptyTextAttributesProvider defaultAttributes = EmptyTextAttributesProvider.INSTANCE;
        CharSequence charSequence = state.getVirtualEnv();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String string = PathUtil.getFileName((String)state.getVirtualEnv());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            venvName = string;
            BuiltInPromptRenderer.getPromptComponents$addComponent(result2, "(" + (String)venvName + ")", greenAttributes);
        }
        if (!((venvName = (CharSequence)state.getCondaEnv()) == null || StringsKt.isBlank((CharSequence)venvName))) {
            BuiltInPromptRenderer.getPromptComponents$addComponent(result2, "(" + state.getCondaEnv() + ")", greenAttributes);
        }
        if (!((Collection)result2).isEmpty()) {
            BuiltInPromptRenderer.getPromptComponents$addComponent(result2, " ", defaultAttributes);
        }
        BuiltInPromptRenderer.getPromptComponents$addComponent(result2, this.calculateDirectoryText(state.getCurrentDirectory()), defaultAttributes);
        venvName = state.getGitBranch();
        if (!(venvName == null || StringsKt.isBlank((CharSequence)venvName))) {
            BuiltInPromptRenderer.getPromptComponents$addComponent(result2, " ", defaultAttributes);
            BuiltInPromptRenderer.getPromptComponents$addComponent(result2, "git:", yellowAttributes);
            BuiltInPromptRenderer.getPromptComponents$addComponent(result2, "[" + state.getGitBranch() + "]", greenAttributes);
        }
        String promptInputSeparator = this.isSingleLine ? " " : "\n";
        BuiltInPromptRenderer.getPromptComponents$addComponent(result2, promptInputSeparator, defaultAttributes);
        return result2;
    }

    private final String calculateDirectoryText(String directory) {
        String string;
        if (!Intrinsics.areEqual((Object)directory, (Object)SystemProperties.getUserHome())) {
            String string2 = FileUtil.getLocationRelativeToUserHome((String)directory, (boolean)false);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = "~";
        }
        return string;
    }

    private final TextAttributesProvider plainAttributes(int colorIndex) {
        return TerminalUiUtils.INSTANCE.plainAttributesProvider(colorIndex, this.sessionInfo.getColorPalette());
    }

    private static final void getPromptComponents$addComponent(List<TextWithAttributes> result2, String text, TextAttributesProvider attributesProvider) {
        result2.add(new TextWithAttributes(text, attributesProvider));
    }
}

