/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.SimpleTerminalController;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.ui.TerminalUi;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001#B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020\tR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/terminal/block/SimpleTerminalView;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "withVerticalScroll", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Z)V", "charSize", "Ljava/awt/geom/Dimension2D;", "getCharSize", "()Ljava/awt/geom/Dimension2D;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "controller", "Lorg/jetbrains/plugins/terminal/block/SimpleTerminalController;", "getController", "()Lorg/jetbrains/plugins/terminal/block/SimpleTerminalController;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "preferredFocusableComponent", "getPreferredFocusableComponent", "terminalWidth", "", "getTerminalWidth", "()I", "createEditor", "dispose", "", "isFocused", "SimpleTerminalPanel", "intellij.terminal"})
public final class SimpleTerminalView
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    private final boolean withVerticalScroll;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final SimpleTerminalController controller;
    @NotNull
    private final JComponent component;

    public SimpleTerminalView(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull BlockTerminalSession session2, boolean withVerticalScroll) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.project = project;
        this.settings = settings;
        this.withVerticalScroll = withVerticalScroll;
        this.editor = this.createEditor();
        this.controller = new SimpleTerminalController(this.settings, session2, (EditorEx)this.editor);
        this.component = new SimpleTerminalPanel((Editor)this.editor);
        this.editor.addFocusListener(new FocusChangeListener(){

            public void focusGained(@NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.getController().setFocused(true);
            }

            public void focusLost(@NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.getController().setFocused(false);
            }
        });
    }

    public /* synthetic */ SimpleTerminalView(Project project, JBTerminalSystemSettingsProviderBase jBTerminalSystemSettingsProviderBase, BlockTerminalSession blockTerminalSession, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(project, jBTerminalSystemSettingsProviderBase, blockTerminalSession, bl);
    }

    @NotNull
    public final SimpleTerminalController getController() {
        return this.controller;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        return (JComponent)editorComponentImpl;
    }

    public final int getTerminalWidth() {
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int scrollBarWidth = this.editor.getScrollPane().getVerticalScrollBar().getWidth();
        return visibleArea.width - scrollBarWidth;
    }

    @NotNull
    public final Dimension2D getCharSize() {
        return TerminalUiUtilsKt.getCharSize((Editor)this.editor);
    }

    private final EditorImpl createEditor() {
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        EditorImpl editor = TerminalUiUtils.INSTANCE.createOutputEditor((Document)document, this.project, this.settings);
        TerminalUi.INSTANCE.useTerminalDefaultBackground((EditorEx)editor, this);
        editor.getSettings().setLineMarkerAreaShown(false);
        editor.getScrollPane().setVerticalScrollBarPolicy(this.withVerticalScroll ? 20 : 21);
        return editor;
    }

    public final boolean isFocused() {
        return this.editor.getContentComponent().hasFocus();
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor((Editor)this.editor);
        Disposer.dispose((Disposable)this.controller);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/block/SimpleTerminalView$SimpleTerminalPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/plugins/terminal/block/SimpleTerminalView;Lcom/intellij/openapi/editor/Editor;)V", "getData", "", "dataId", "", "intellij.terminal"})
    private final class SimpleTerminalPanel
    extends JPanel
    implements DataProvider {
        public SimpleTerminalPanel(Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.setBackground((Color)TerminalUi.INSTANCE.defaultBackground(editor));
            this.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
            this.setLayout(new BorderLayout());
            this.add((Component)editor.getComponent(), "Center");
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            return CommonDataKeys.EDITOR.is(dataId) ? SimpleTerminalView.this.editor : null;
        }
    }
}

