/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.kotlin.correctness;

import com.intellij.ml.inline.completion.features.correctness.CorrectnessError;
import com.intellij.ml.inline.completion.features.correctness.OnRangeElementsEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.Severity;
import com.intellij.ml.inline.completion.features.correctness.SpecialRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/inline/completion/kotlin/correctness/KotlinGradleVersionFilteringChecker;", "Lcom/intellij/ml/inline/completion/features/correctness/OnRangeElementsEnrichmentTool;", "()V", "runForElement", "", "Lcom/intellij/ml/inline/completion/features/correctness/SpecialRange;", "originalFile", "Lcom/intellij/psi/PsiFile;", "suggestionOffset", "", "suggestion", "", "element", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.ml.inline.completion.kotlin"})
public final class KotlinGradleVersionFilteringChecker
extends OnRangeElementsEnrichmentTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex VERSION_REGEX = new Regex("\\d\\.\\d");

    @Override
    @NotNull
    public List<SpecialRange> runForElement(@NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = originalFile.getVirtualFile();
        if (!(object != null && (object = object.getName()) != null ? StringsKt.endsWith$default((String)object, (String)".gradle.kts", (boolean)false, (int)2, null) : false) || !(element instanceof KtStringTemplateExpression)) {
            return CollectionsKt.emptyList();
        }
        String string = ((KtStringTemplateExpression)element).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (VERSION_REGEX.containsMatchIn((CharSequence)string)) {
            TextRange textRange = ((KtStringTemplateExpression)element).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            TextRange textRange2 = this.getLocationInSuggestion(textRange, suggestionOffset, suggestion);
            if (textRange2 == null) {
                return CollectionsKt.emptyList();
            }
            TextRange errorLocation = textRange2;
            return CollectionsKt.listOf((Object)new CorrectnessError(errorLocation, Severity.CRITICAL, "DEPENDENCY_VERSION_USED_IN_STRING"));
        }
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ml/inline/completion/kotlin/correctness/KotlinGradleVersionFilteringChecker$Companion;", "", "()V", "VERSION_REGEX", "Lkotlin/text/Regex;", "intellij.ml.inline.completion.kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

