/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api.httpclient;

import com.intellij.collaboration.api.HttpApiHelperKt;
import com.intellij.collaboration.api.HttpStatusErrorException;
import com.intellij.collaboration.api.httpclient.InflatedStreamReadingBodyHandler;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J<\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u00170\u001bJE\u0010\u001e\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H\u00170!\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/collaboration/api/httpclient/HttpClientUtil;", "", "()V", "ACCEPT_ENCODING_HEADER", "", "CONTENT_ENCODING_GZIP", "CONTENT_ENCODING_HEADER", "CONTENT_TYPE_HEADER", "CONTENT_TYPE_JSON", "USER_AGENT_HEADER", "checkStatusCodeWithLogging", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "requestName", "statusCode", "", "bodyStream", "Ljava/io/InputStream;", "getUserAgentValue", "agentName", "inflateAndReadWithErrorHandlingAndLogging", "Ljava/net/http/HttpResponse$BodyHandler;", "T", "request", "Ljava/net/http/HttpRequest;", "mapToResult", "Lkotlin/Function2;", "Ljava/io/Reader;", "Ljava/net/http/HttpResponse$ResponseInfo;", "readSuccessResponseWithLogging", "responseInfo", "reader", "Lkotlin/Function1;", "(Lcom/intellij/openapi/diagnostic/Logger;Ljava/net/http/HttpRequest;Ljava/net/http/HttpResponse$ResponseInfo;Ljava/io/InputStream;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "responseReaderWithLogging", "stream", "intellij.platform.collaborationTools"})
public final class HttpClientUtil {
    @NotNull
    public static final HttpClientUtil INSTANCE = new HttpClientUtil();
    @NotNull
    public static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    @NotNull
    public static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    @NotNull
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    @NotNull
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    @NotNull
    public static final String CONTENT_TYPE_JSON = "application/json";
    @NotNull
    public static final String USER_AGENT_HEADER = "User-Agent";

    private HttpClientUtil() {
    }

    public final void checkStatusCodeWithLogging(@NotNull Logger logger, @NotNull String requestName, int statusCode, @NotNull InputStream bodyStream) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)requestName, (String)"requestName");
        Intrinsics.checkNotNullParameter((Object)bodyStream, (String)"bodyStream");
        logger.debug(requestName + " : Status code " + statusCode);
        if (statusCode >= 400) {
            InputStream inputStream = bodyStream;
            Charset charset = Charsets.UTF_8;
            String errorBody = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
            if (logger.isTraceEnabled()) {
                logger.trace(requestName + " : Response body: " + errorBody);
            }
            throw new HttpStatusErrorException(requestName, statusCode, errorBody);
        }
    }

    private final Reader responseReaderWithLogging(Logger logger, String requestName, InputStream stream) {
        if (logger.isTraceEnabled()) {
            InputStream inputStream = stream;
            Charset charset = Charsets.UTF_8;
            String body = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
            logger.trace(requestName + " : Response body: " + body);
            return new StringReader(body);
        }
        InputStream inputStream = stream;
        Charset charset = Charsets.UTF_8;
        return new InputStreamReader(inputStream, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T readSuccessResponseWithLogging(@NotNull Logger logger, @NotNull HttpRequest request, @NotNull HttpResponse.ResponseInfo responseInfo, @NotNull InputStream bodyStream, @NotNull Function1<? super Reader, ? extends T> reader) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"responseInfo");
        Intrinsics.checkNotNullParameter((Object)bodyStream, (String)"bodyStream");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        this.checkStatusCodeWithLogging(logger, HttpApiHelperKt.logName(request), responseInfo.statusCode(), bodyStream);
        Closeable closeable = this.responseReaderWithLogging(logger, HttpApiHelperKt.logName(request), bodyStream);
        Throwable throwable = null;
        try {
            Reader it = (Reader)closeable;
            boolean bl = false;
            Object result = reader.invoke((Object)it);
            try {
                Writer writer = Writer.nullWriter();
                Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"nullWriter(...)");
                TextStreamsKt.copyTo$default((Reader)it, (Writer)writer, (int)0, (int)2, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = result;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    @NotNull
    public final <T> HttpResponse.BodyHandler<T> inflateAndReadWithErrorHandlingAndLogging(@NotNull Logger logger, @NotNull HttpRequest request, @NotNull Function2<? super Reader, ? super HttpResponse.ResponseInfo, ? extends T> mapToResult) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(mapToResult, (String)"mapToResult");
        return new InflatedStreamReadingBodyHandler((Function2)new Function2<HttpResponse.ResponseInfo, InputStream, T>(logger, request, mapToResult){
            final /* synthetic */ Logger $logger;
            final /* synthetic */ HttpRequest $request;
            final /* synthetic */ Function2<Reader, HttpResponse.ResponseInfo, T> $mapToResult;
            {
                this.$logger = $logger;
                this.$request = $request;
                this.$mapToResult = $mapToResult;
                super(2);
            }

            public final T invoke(@NotNull HttpResponse.ResponseInfo responseInfo, @NotNull InputStream bodyStream) {
                Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"responseInfo");
                Intrinsics.checkNotNullParameter((Object)bodyStream, (String)"bodyStream");
                return HttpClientUtil.INSTANCE.readSuccessResponseWithLogging(this.$logger, this.$request, responseInfo, bodyStream, (Function1)new Function1<Reader, T>(this.$mapToResult, responseInfo){
                    final /* synthetic */ Function2<Reader, HttpResponse.ResponseInfo, T> $mapToResult;
                    final /* synthetic */ HttpResponse.ResponseInfo $responseInfo;
                    {
                        this.$mapToResult = $mapToResult;
                        this.$responseInfo = $responseInfo;
                        super(1);
                    }

                    public final T invoke(@NotNull Reader reader) {
                        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                        return (T)this.$mapToResult.invoke((Object)reader, (Object)this.$responseInfo);
                    }
                });
            }
        });
    }

    @NotNull
    public final String getUserAgentValue(@NotNull String agentName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        String string2 = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFullProductName(...)");
        String ideName = StringsKt.replace$default((String)string2, (char)' ', (char)'-', (boolean)false, (int)4, null);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            string = "test";
        } else {
            String string3 = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asStringWithoutProductCode(...)");
        }
        String ideBuild = string;
        String java = "JRE " + SystemInfo.JAVA_RUNTIME_VERSION;
        String os = SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION;
        String arch = SystemInfo.OS_ARCH;
        return agentName + " " + ideName + "/" + ideBuild + " (" + java + "; " + os + "; " + arch + ")";
    }
}

