/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.statistic;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GcMetric;
import org.jetbrains.kotlin.build.report.metrics.JpsBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.JpsBuildTime;
import org.jetbrains.kotlin.build.report.statistics.StatTag;
import org.jetbrains.kotlin.jps.statistic.JpsBuilderMetricReporter;
import org.jetbrains.kotlin.jps.statistic.JpsCompileStatisticsData;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 32\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002:\u00013B7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0001J\u0019\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0001J\u0019\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u000eH\u0096\u0001J\u001d\u0010\u001e\u001a\u00020\u00162\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040 H\u0096\u0001J\u0011\u0010!\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0004H\u0096\u0001J\u0019\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u000eH\u0096\u0001J\u0019\u0010%\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u000eH\u0096\u0001J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*H\u0016J\u0019\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0001J\u0011\u0010-\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0003H\u0096\u0001J\u0010\u0010.\u001a\u00020/2\u0006\u0010)\u001a\u00020*H\u0016J\u0015\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040 H\u0096\u0001J\u0019\u00101\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0001J\u0011\u00102\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0003H\u0096\u0001R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporterImpl;", "Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/JpsBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/JpsBuildPerformanceMetric;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "reporter", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;", "label", "", "kotlinVersion", "(Lorg/jetbrains/jps/ModuleChunk;Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;Ljava/lang/String;Ljava/lang/String;)V", "finishTime", "", "moduleString", "kotlin.jvm.PlatformType", "startTime", "tags", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/build/report/statistics/StatTag;", "addAttribute", "", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "addGcMetric", "metric", "value", "Lorg/jetbrains/kotlin/build/report/metrics/GcMetric;", "addMetric", "addMetrics", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addTimeMetric", "addTimeMetricMs", "time", "durationMs", "addTimeMetricNs", "durationNs", "buildFinish", "moduleChunk", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "endGcMetric", "name", "endMeasure", "flush", "Lorg/jetbrains/kotlin/jps/statistic/JpsCompileStatisticsData;", "getMetrics", "startGcMetric", "startMeasure", "Companion", "jps-plugin"})
public final class JpsBuilderMetricReporterImpl
implements JpsBuilderMetricReporter,
BuildMetricsReporter<JpsBuildTime, JpsBuildPerformanceMetric> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final BuildMetricsReporterImpl<JpsBuildTime, JpsBuildPerformanceMetric> reporter;
    @Nullable
    private final String label;
    @NotNull
    private final String kotlinVersion;
    private final long startTime;
    private long finishTime;
    @NotNull
    private final HashSet<StatTag> tags;
    private final String moduleString;
    @Nullable
    private static final String hostName;
    private static final UUID uuid;

    public JpsBuilderMetricReporterImpl(@NotNull ModuleChunk chunk, @NotNull BuildMetricsReporterImpl<JpsBuildTime, JpsBuildPerformanceMetric> reporter, @Nullable String label, @NotNull String kotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)kotlinVersion, (String)"kotlinVersion");
        this.reporter = reporter;
        this.label = label;
        this.kotlinVersion = kotlinVersion;
        this.startTime = System.currentTimeMillis();
        this.tags = new HashSet();
        this.moduleString = chunk.getName();
    }

    public /* synthetic */ JpsBuilderMetricReporterImpl(ModuleChunk moduleChunk, BuildMetricsReporterImpl buildMetricsReporterImpl, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = "kotlin_version";
        }
        this(moduleChunk, buildMetricsReporterImpl, string2, string3);
    }

    @Override
    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        this.reporter.addAttribute(attribute);
    }

    @Override
    public void addGcMetric(@NotNull String metric, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.reporter.addGcMetric(metric, value2);
    }

    @Override
    public void addMetric(@NotNull JpsBuildPerformanceMetric metric, long value2) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.reporter.addMetric((JpsBuildPerformanceMetric)((BuildPerformanceMetric)metric), value2);
    }

    @Override
    public void addMetrics(@NotNull BuildMetrics<JpsBuildTime, JpsBuildPerformanceMetric> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.reporter.addMetrics(metrics);
    }

    @Override
    public void addTimeMetric(@NotNull JpsBuildPerformanceMetric metric) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.reporter.addTimeMetric((JpsBuildPerformanceMetric)((BuildPerformanceMetric)metric));
    }

    @Override
    public void addTimeMetricMs(@NotNull JpsBuildTime time, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.addTimeMetricMs((JpsBuildTime)((BuildTime)time), durationMs);
    }

    @Override
    public void addTimeMetricNs(@NotNull JpsBuildTime time, long durationNs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.addTimeMetricNs((JpsBuildTime)((BuildTime)time), durationNs);
    }

    @Override
    public void endGcMetric(@NotNull String name2, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.reporter.endGcMetric(name2, value2);
    }

    @Override
    public void endMeasure(@NotNull JpsBuildTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.endMeasure((JpsBuildTime)((BuildTime)time));
    }

    @Override
    @NotNull
    public BuildMetrics<JpsBuildTime, JpsBuildPerformanceMetric> getMetrics() {
        return this.reporter.getMetrics();
    }

    @Override
    public void startGcMetric(@NotNull String name2, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.reporter.startGcMetric(name2, value2);
    }

    @Override
    public void startMeasure(@NotNull JpsBuildTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.reporter.startMeasure((JpsBuildTime)((BuildTime)time));
    }

    @Override
    public void buildFinish(@NotNull ModuleChunk moduleChunk, @NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)moduleChunk, (String)"moduleChunk");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.finishTime = System.currentTimeMillis();
    }

    @Override
    @NotNull
    public JpsCompileStatisticsData flush(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BuildMetrics<JpsBuildTime, JpsBuildPerformanceMetric> buildMetrics = this.reporter.getMetrics();
        String string2 = context.getProjectDescriptor().getProject().getName();
        String string3 = this.label;
        String string4 = this.moduleString;
        long l = this.startTime;
        long l2 = this.finishTime - this.startTime;
        HashSet<StatTag> hashSet = this.tags;
        String string5 = uuid.toString();
        List list = CollectionsKt.emptyList();
        String string6 = this.kotlinVersion;
        String string7 = hostName;
        long l3 = this.finishTime;
        Map<JpsBuildTime, Long> map = buildMetrics.getBuildTimes().asMapMs();
        Map<JpsBuildPerformanceMetric, Long> map2 = buildMetrics.getBuildPerformanceMetrics().asMap();
        List list2 = CollectionsKt.emptyList();
        Set set = SetsKt.emptySet();
        List list3 = CollectionsKt.emptyList();
        List list4 = CollectionsKt.emptyList();
        Map<String, Long> map3 = buildMetrics.getGcMetrics().asGcTimeMap();
        Map<String, Long> map4 = buildMetrics.getGcMetrics().asGcCountMap();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"moduleString");
        Set set2 = hashSet;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString()");
        return new JpsCompileStatisticsData(string2, string3, string4, "Unknown", l, l2, set2, list, string5, string6, null, string7, l3, list2, set, map, map2, map3, map4, "JPS_DATA", true, list3, null, list4);
    }

    static {
        String string2;
        Companion = new Companion(null);
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception _) {
            string2 = null;
        }
        hostName = string2;
        uuid = UUID.randomUUID();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/jps/statistic/JpsBuilderMetricReporterImpl$Companion;", "", "()V", "hostName", "", "uuid", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "jps-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

