/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.ImagesBundle;
import org.intellij.images.editor.impl.jcef.JCefImageViewer;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.ui.ImageComponentDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0019\u001aB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u000f2\u000b\u0010\u0015\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0016J\u0006\u0010\u0017\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewerUI;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable;", "myContentComponent", "Ljava/awt/Component;", "myViewer", "Lorg/intellij/images/editor/impl/jcef/JCefImageViewer;", "(Ljava/awt/Component;Lorg/intellij/images/editor/impl/jcef/JCefImageViewer;)V", "MOUSE_WHEEL_LISTENER", "Ljava/awt/event/MouseWheelListener;", "myInfoLabel", "Ljavax/swing/JLabel;", "myViewPort", "dispose", "", "getData", "", "dataId", "", "setInfo", "info", "Lorg/jetbrains/annotations/Nls;", "showError", "showImage", "Companion", "ViewPort", "intellij.platform.images"})
public final class JCefImageViewerUI
extends JPanel
implements DataProvider,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Component myContentComponent;
    @NotNull
    private final JCefImageViewer myViewer;
    @NotNull
    private final JLabel myInfoLabel;
    @NotNull
    private final JPanel myViewPort;
    @NotNull
    private final MouseWheelListener MOUSE_WHEEL_LISTENER;
    @NotNull
    private static final String IMAGE_PANEL = "image";
    @NotNull
    private static final String ERROR_PANEL = "error";

    public JCefImageViewerUI(@NotNull Component myContentComponent, @NotNull JCefImageViewer myViewer) {
        Intrinsics.checkNotNullParameter((Object)myContentComponent, (String)"myContentComponent");
        Intrinsics.checkNotNullParameter((Object)myViewer, (String)"myViewer");
        this.myContentComponent = myContentComponent;
        this.myViewer = myViewer;
        this.MOUSE_WHEEL_LISTENER = arg_0 -> JCefImageViewerUI.MOUSE_WHEEL_LISTENER$lambda$0(this, arg_0);
        this.setLayout(new BorderLayout());
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("Images.EditorToolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Images.Editor", actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)this);
        this.setBackground((Color)JBColor.lazy(JCefImageViewerUI::_init_$lambda$1));
        JComponent jComponent = actionToolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent toolbarPanel = jComponent;
        toolbarPanel.setBackground((Color)JBColor.lazy(() -> JCefImageViewerUI._init_$lambda$2(this)));
        JPanel topPanel = (JPanel)new NonOpaquePanel((LayoutManager)new BorderLayout());
        topPanel.add((Component)toolbarPanel, "West");
        this.myInfoLabel = new JLabel(null, 4);
        this.myInfoLabel.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        topPanel.add((Component)this.myInfoLabel, "East");
        this.add((Component)topPanel, "North");
        this.myViewPort = new ViewPort();
        this.myViewPort.setLayout(new CardLayout());
        this.myViewer.getPreferredFocusedComponent().addMouseWheelListener(this.MOUSE_WHEEL_LISTENER);
        this.myViewPort.add(this.myContentComponent, IMAGE_PANEL);
        this.myContentComponent.setBackground((Color)JBColor.lazy(() -> JCefImageViewerUI._init_$lambda$3(this)));
        JLabel errorLabel = new JLabel(ImagesBundle.message("error.broken.image.file.format", new Object[0]), Messages.getErrorIcon(), 0);
        JPanel errorPanel = new JPanel(new BorderLayout());
        errorPanel.add((Component)errorLabel, "Center");
        this.myViewPort.add(this.myContentComponent, IMAGE_PANEL);
        this.myViewPort.add((Component)errorPanel, ERROR_PANEL);
        this.add((Component)this.myViewPort, "Center");
        if (!JCefImageViewer.Companion.isDebugMode()) {
            PopupHandler.installPopupMenu((JComponent)this.myViewer.getPreferredFocusedComponent(), (String)"Images.EditorPopupMenu", (String)"Images.Editor");
        }
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return ImageComponentDecorator.DATA_KEY.is(dataId) ? this.myViewer : null;
    }

    public void dispose() {
        this.myViewer.getPreferredFocusedComponent().removeMouseWheelListener(this.MOUSE_WHEEL_LISTENER);
    }

    public final void setInfo(@NotNull String info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.myInfoLabel.setText(info);
    }

    public final void showError() {
        LayoutManager layoutManager = this.myViewPort.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
        ((CardLayout)layoutManager).show(this.myViewPort, ERROR_PANEL);
    }

    public final void showImage() {
        LayoutManager layoutManager = this.myViewPort.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
        ((CardLayout)layoutManager).show(this.myViewPort, IMAGE_PANEL);
    }

    private static final void MOUSE_WHEEL_LISTENER$lambda$0(JCefImageViewerUI this$0, MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ZoomOptions zoomOptions = OptionsManager.getInstance().getOptions().getEditorOptions().getZoomOptions();
        if (zoomOptions.isWheelZooming() && e.isControlDown()) {
            int rotation = e.getWheelRotation();
            if (rotation < 0) {
                this$0.myViewer.setZoom(this$0.myViewer.getZoom() * 1.2, new Point(e.getX(), e.getY()));
            } else if (rotation > 0) {
                this$0.myViewer.setZoom(this$0.myViewer.getZoom() / 1.2, new Point(e.getX(), e.getY()));
            }
            e.consume();
        }
    }

    private static final Color _init_$lambda$1() {
        return (Color)ObjectUtils.notNull((Object)EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.PREVIEW_BACKGROUND), (Object)EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
    }

    private static final Color _init_$lambda$2(JCefImageViewerUI this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Color color = this$0.getBackground();
        if (color == null) {
            Color color2 = UIUtil.getPanelBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
        }
        return color;
    }

    private static final Color _init_$lambda$3(JCefImageViewerUI this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Color color = this$0.getBackground();
        if (color == null) {
            Color color2 = UIUtil.getPanelBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getPanelBackground(...)");
        }
        return color;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewerUI$Companion;", "", "()V", "ERROR_PANEL", "", "Lorg/jetbrains/annotations/NonNls;", "IMAGE_PANEL", "intellij.platform.images"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/images/editor/impl/jcef/JCefImageViewerUI$ViewPort;", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/components/ZoomableViewport;", "(Lorg/intellij/images/editor/impl/jcef/JCefImageViewerUI;)V", "myMagnificationPoint", "Ljava/awt/Point;", "myOriginalZoom", "", "convertToContentCoordinates", "point", "getMagnificator", "Lcom/intellij/ui/components/Magnificator;", "magnificationFinished", "", "magnification", "magnificationStarted", "at", "magnify", "intellij.platform.images"})
    private final class ViewPort
    extends JPanel
    implements ZoomableViewport {
        @Nullable
        private Point myMagnificationPoint;
        private double myOriginalZoom;

        public ViewPort() {
            super(new BorderLayout());
            this.myOriginalZoom = 1.0;
        }

        private final Point convertToContentCoordinates(Point point) {
            Point point2 = SwingUtilities.convertPoint(this, point, JCefImageViewerUI.this.myContentComponent);
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"convertPoint(...)");
            return point2;
        }

        @NotNull
        public Magnificator getMagnificator() {
            return (arg_0, arg_1) -> ViewPort.getMagnificator$lambda$0(JCefImageViewerUI.this, arg_0, arg_1);
        }

        public void magnificationStarted(@NotNull Point at) {
            Intrinsics.checkNotNullParameter((Object)at, (String)"at");
            this.myMagnificationPoint = at;
            this.myOriginalZoom = JCefImageViewerUI.this.myViewer.getZoom();
        }

        public void magnificationFinished(double magnification) {
            this.myMagnificationPoint = null;
            this.myOriginalZoom = 1.0;
        }

        public void magnify(double magnification) {
            Point p = this.myMagnificationPoint;
            if (Double.compare(magnification, 0.0) != 0 && p != null) {
                Magnificator magnificator = this.getMagnificator();
                Point inContentPoint = this.convertToContentCoordinates(p);
                double scale = magnification < 0.0 ? (double)1.0f / (1.0 - magnification) : 1.0 + magnification;
                magnificator.magnify(this.myOriginalZoom * scale, inContentPoint);
            }
        }

        private static final Point getMagnificator$lambda$0(JCefImageViewerUI this$0, double scale, Point at) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            JCefImageViewer jCefImageViewer = this$0.myViewer;
            Intrinsics.checkNotNull((Object)at);
            jCefImageViewer.setZoom(scale, at);
            return at;
        }
    }
}

