/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.floating;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.FloatingToolbar;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/MarkdownFloatingToolbar;", "Lcom/intellij/openapi/actionSystem/impl/FloatingToolbar;", "editor", "Lcom/intellij/openapi/editor/Editor;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/editor/Editor;Lkotlinx/coroutines/CoroutineScope;)V", "elementsToIgnore", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "createActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "hasIgnoredParent", "", "element", "Lcom/intellij/psi/PsiElement;", "isEnabled", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownFloatingToolbar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownFloatingToolbar.kt\norg/intellij/plugins/markdown/ui/floating/MarkdownFloatingToolbar\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,42:1\n1247#2,2:43\n*S KotlinDebug\n*F\n+ 1 MarkdownFloatingToolbar.kt\norg/intellij/plugins/markdown/ui/floating/MarkdownFloatingToolbar\n*L\n31#1:43,2\n*E\n"})
public final class MarkdownFloatingToolbar
extends FloatingToolbar {
    @NotNull
    private final List<IElementType> elementsToIgnore;

    public MarkdownFloatingToolbar(@NotNull Editor editor2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(editor2, coroutineScope);
        Object[] objectArray = new IElementType[]{MarkdownElementTypes.CODE_FENCE, MarkdownElementTypes.CODE_BLOCK, MarkdownElementTypes.CODE_SPAN, MarkdownElementTypes.HTML_BLOCK, MarkdownElementTypes.LINK_DESTINATION};
        this.elementsToIgnore = CollectionsKt.listOf((Object[])objectArray);
    }

    protected boolean hasIgnoredParent(@NotNull PsiElement element2) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            if (!(element2.getContainingFile() instanceof MarkdownFile)) {
                return true;
            }
            Sequence $this$any$iv = PsiTreeUtilKt.parents((PsiElement)element2, (boolean)true);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!this.elementsToIgnore.contains(PsiTreeUtilKt.getElementType((PsiElement)it))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public boolean isEnabled() {
        return !AdvancedSettings.Companion.getBoolean("markdown.hide.floating.toolbar");
    }

    @Nullable
    protected ActionGroup createActionGroup() {
        AnAction anAction = CustomActionsSchema.Companion.getInstance().getCorrectedAction("Markdown.Toolbar.Floating");
        return anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
    }
}

