/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.headers;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.rename.api.RenameTarget;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderContent;
import org.intellij.plugins.markdown.model.psi.MarkdownSymbolPresentationUtilsKt;
import org.intellij.plugins.markdown.model.psi.headers.MarkdownHeaderSymbol;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 42\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00014B/\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u000b\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\u000e\u0010#\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u00c6\u0003J\u000e\u0010$\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u00c6\u0003J\b\u0010%\u001a\u00020&H\u0016J;\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\r\b\u0002\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\r\b\u0002\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u00c6\u0001J\u0010\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000)H\u0016J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\b\u00102\u001a\u00020&H\u0016J\t\u00103\u001a\u00020\nH\u00d6\u0001R\u0019\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0019\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00065"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderSymbol;", "Lorg/intellij/plugins/markdown/model/psi/headers/MarkdownHeaderSymbol;", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "Lcom/intellij/find/usages/api/SearchTarget;", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "anchorText", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;Ljava/lang/String;)V", "getAnchorText", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/psi/PsiFile;", "maximalSearchScope", "Lcom/intellij/psi/search/SearchScope;", "getMaximalSearchScope", "()Lcom/intellij/psi/search/SearchScope;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "searchText", "getSearchText", "targetName", "getTargetName", "getText", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getUsageHandler", "()Lcom/intellij/find/usages/api/UsageHandler;", "component1", "component2", "component3", "component4", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "copy", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "hashCode", "", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "presentation", "toString", "Companion", "intellij.markdown.model"})
@ApiStatus.Internal
public final class HeaderSymbol
implements MarkdownHeaderSymbol,
NavigationTarget,
SearchTarget,
RenameTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFile file;
    @NotNull
    private final TextRange range;
    @NotNull
    private final String text;
    @NotNull
    private final String anchorText;

    public HeaderSymbol(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String text2, @NotNull String anchorText) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)anchorText, (String)"anchorText");
        this.file = file;
        this.range = range;
        this.text = text2;
        this.anchorText = anchorText;
    }

    @Override
    @NotNull
    public PsiFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public TextRange getRange() {
        return this.range;
    }

    @Override
    @NotNull
    public String getText() {
        return this.text;
    }

    @Override
    @NotNull
    public String getAnchorText() {
        return this.anchorText;
    }

    @NotNull
    public Pointer<? extends HeaderSymbol> createPointer() {
        return Companion.createPointer(this.getFile(), this.getRange(), this.getText(), this.getAnchorText());
    }

    @NotNull
    public TargetPresentation computePresentation() {
        return this.presentation();
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        return NavigationRequest.Companion.sourceNavigationRequest(this.getFile(), this.getRange());
    }

    @NotNull
    public String getTargetName() {
        return this.getText();
    }

    @Override
    @NotNull
    public String getSearchText() {
        return this.getAnchorText();
    }

    @NotNull
    public SearchScope getMaximalSearchScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getFile().getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return (SearchScope)globalSearchScope;
    }

    @NotNull
    public UsageHandler getUsageHandler() {
        UsageHandler usageHandler = UsageHandler.createEmptyUsageHandler((String)this.getAnchorText());
        Intrinsics.checkNotNullExpressionValue((Object)usageHandler, (String)"createEmptyUsageHandler(...)");
        return usageHandler;
    }

    @NotNull
    public TargetPresentation presentation() {
        TargetPresentationBuilder targetPresentationBuilder = TargetPresentation.Companion.builder(this.getText()).icon(MarkdownIcons.EditorActions.Header_level_up);
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentationBuilder, (String)"icon(...)");
        TargetPresentationBuilder builder = targetPresentationBuilder;
        TargetPresentation targetPresentation = MarkdownSymbolPresentationUtilsKt.withLocationIn(builder, this.getFile()).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public final PsiFile component1() {
        return this.file;
    }

    @NotNull
    public final TextRange component2() {
        return this.range;
    }

    @NotNull
    public final String component3() {
        return this.text;
    }

    @NotNull
    public final String component4() {
        return this.anchorText;
    }

    @NotNull
    public final HeaderSymbol copy(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String text2, @NotNull String anchorText) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)anchorText, (String)"anchorText");
        return new HeaderSymbol(file, range, text2, anchorText);
    }

    public static /* synthetic */ HeaderSymbol copy$default(HeaderSymbol headerSymbol, PsiFile psiFile, TextRange textRange, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            psiFile = headerSymbol.file;
        }
        if ((n & 2) != 0) {
            textRange = headerSymbol.range;
        }
        if ((n & 4) != 0) {
            string = headerSymbol.text;
        }
        if ((n & 8) != 0) {
            string2 = headerSymbol.anchorText;
        }
        return headerSymbol.copy(psiFile, textRange, string, string2);
    }

    @NotNull
    public String toString() {
        return "HeaderSymbol(file=" + this.file + ", range=" + this.range + ", text=" + this.text + ", anchorText=" + this.anchorText + ")";
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + this.range.hashCode();
        result2 = result2 * 31 + this.text.hashCode();
        result2 = result2 * 31 + this.anchorText.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HeaderSymbol)) {
            return false;
        }
        HeaderSymbol headerSymbol = (HeaderSymbol)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)headerSymbol.file)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.range, (Object)headerSymbol.range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)headerSymbol.text)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.anchorText, (Object)headerSymbol.anchorText);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderSymbol$Companion;", "", "()V", "createPointer", "Lcom/intellij/model/Pointer;", "Lorg/intellij/plugins/markdown/model/psi/headers/HeaderSymbol;", "file", "Lcom/intellij/psi/PsiFile;", "absoluteRange", "Lcom/intellij/openapi/util/TextRange;", "text", "", "anchorText", "header", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "intellij.markdown.model"})
    @SourceDebugExtension(value={"SMAP\nHeaderSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderSymbol.kt\norg/intellij/plugins/markdown/model/psi/headers/HeaderSymbol$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,77:1\n436#2:78\n*S KotlinDebug\n*F\n+ 1 HeaderSymbol.kt\norg/intellij/plugins/markdown/model/psi/headers/HeaderSymbol$Companion\n*L\n61#1:78\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Pointer<HeaderSymbol> createPointer(@NotNull MarkdownHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            PsiElement $this$childrenOfType$iv = (PsiElement)header;
            boolean $i$f$childrenOfType = false;
            List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, MarkdownHeaderContent.class);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
            MarkdownHeaderContent markdownHeaderContent = (MarkdownHeaderContent)CollectionsKt.firstOrNull((List)list2);
            if (markdownHeaderContent == null) {
                return null;
            }
            MarkdownHeaderContent headerContent = markdownHeaderContent;
            String string = header.getAnchorText();
            if (string == null) {
                return null;
            }
            String anchorText = string;
            TextRange rangeInContentHolder = headerContent.getNonWhitespaceRange();
            TextRange textRange = rangeInContentHolder.shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)headerContent)));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
            TextRange absoluteRange = textRange;
            String string2 = rangeInContentHolder.substring(headerContent.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String text2 = string2;
            PsiFile psiFile = header.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiFile file = psiFile;
            return this.createPointer(file, absoluteRange, text2, anchorText);
        }

        @NotNull
        public final Pointer<HeaderSymbol> createPointer(@NotNull PsiFile file, @NotNull TextRange absoluteRange, @NotNull String text2, @NotNull String anchorText) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)absoluteRange, (String)"absoluteRange");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)anchorText, (String)"anchorText");
            Pointer pointer = Pointer.fileRangePointer((PsiFile)file, (TextRange)absoluteRange, (arg_0, arg_1) -> Companion.createPointer$lambda$0((Function2)new Function2<PsiFile, TextRange, HeaderSymbol>(text2, anchorText){
                final /* synthetic */ String $text;
                final /* synthetic */ String $anchorText;
                {
                    this.$text = $text;
                    this.$anchorText = $anchorText;
                    super(2);
                }

                @Nullable
                public final HeaderSymbol invoke(@NotNull PsiFile restoredFile, @NotNull TextRange restoredRange) {
                    Intrinsics.checkNotNullParameter((Object)restoredFile, (String)"restoredFile");
                    Intrinsics.checkNotNullParameter((Object)restoredRange, (String)"restoredRange");
                    return new HeaderSymbol(restoredFile, restoredRange, this.$text, this.$anchorText);
                }
            }, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"fileRangePointer(...)");
            return pointer;
        }

        private static final HeaderSymbol createPointer$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (HeaderSymbol)$tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

