/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references.paths;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/lang/references/paths/MarkdownLinkDestinationWithSpacesInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkReference", "", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDestination;", "ReplaceSpacesInsideLinkFix", "intellij.markdown"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMarkdownLinkDestinationWithSpacesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownLinkDestinationWithSpacesInspection.kt\norg/intellij/plugins/markdown/lang/references/paths/MarkdownLinkDestinationWithSpacesInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n766#2:72\n857#2,2:73\n1549#2:75\n1620#2,3:76\n819#2:79\n847#2,2:80\n*S KotlinDebug\n*F\n+ 1 MarkdownLinkDestinationWithSpacesInspection.kt\norg/intellij/plugins/markdown/lang/references/paths/MarkdownLinkDestinationWithSpacesInspection\n*L\n31#1:72\n31#1:73,2\n36#1:75\n36#1:76,3\n36#1:79\n36#1:80,2\n*E\n"})
public final class MarkdownLinkDestinationWithSpacesInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MarkdownElementVisitor(this, holder){
            final /* synthetic */ MarkdownLinkDestinationWithSpacesInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitLinkDestination(@NotNull MarkdownLinkDestination linkDestination) {
                Intrinsics.checkNotNullParameter((Object)linkDestination, (String)"linkDestination");
                MarkdownLinkDestinationWithSpacesInspection.access$checkReference(this.this$0, linkDestination, this.$holder);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReference(MarkdownLinkDestination element2, ProblemsHolder holder) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        TextRange it;
        void $this$mapTo$iv$iv;
        PsiElement $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ArraysKt.filterNotNull((Object[])element2.getReferences());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiReference it2 = (PsiReference)element$iv$iv;
            boolean bl = false;
            if (!(it2 instanceof FileReferenceOwner)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List references = (List)destination$iv$iv;
        if (references.isEmpty()) {
            return;
        }
        $this$filterTo$iv$iv = ((PsiReference)CollectionsKt.first((List)references)).getElement();
        MarkdownLinkDestination markdownLinkDestination = $this$filterTo$iv$iv instanceof MarkdownLinkDestination ? (MarkdownLinkDestination)$this$filterTo$iv$iv : null;
        if (markdownLinkDestination == null) {
            return;
        }
        MarkdownLinkDestination element3 = markdownLinkDestination;
        String text2 = element3.getText();
        Iterable $this$map$iv = references;
        boolean $i$f$map = false;
        LocalQuickFix[] localQuickFixArray = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiReference psiReference = (PsiReference)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getRangeInElement());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (TextRange)element$iv$iv;
            boolean bl = false;
            if (it.isEmpty() || it.getEndOffset() > text2.length()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List ranges2 = (List)destination$iv$iv2;
        Intrinsics.checkNotNull((Object)text2);
        if (!StringsKt.contains$default((CharSequence)text2, (char)' ', (boolean)false, (int)2, null) || CollectionsKt.none((Iterable)ranges2)) {
            return;
        }
        TextRange range = new TextRange(((TextRange)CollectionsKt.first((List)ranges2)).getStartOffset(), ((TextRange)CollectionsKt.last((List)ranges2)).getEndOffset());
        String string = text2.substring(range.getStartOffset(), range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String replacement = StringsKt.replace$default((String)string, (String)" ", (String)"%20", (boolean)false, (int)4, null);
        localQuickFixArray = new LocalQuickFix[]{new ReplaceSpacesInsideLinkFix(element3, range, replacement)};
        holder.registerProblem((PsiElement)element3, MarkdownBundle.message("markdown.link.destination.with.spaces.inspection.description", new Object[0]), ProblemHighlightType.WARNING, range, localQuickFixArray);
    }

    public static final /* synthetic */ void access$checkReference(MarkdownLinkDestinationWithSpacesInspection $this, MarkdownLinkDestination element2, ProblemsHolder holder) {
        $this.checkReference(element2, holder);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/lang/references/paths/MarkdownLinkDestinationWithSpacesInspection$ReplaceSpacesInsideLinkFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "link", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDestination;", "range", "Lcom/intellij/openapi/util/TextRange;", "replacement", "", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkDestination;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.markdown"})
    private static final class ReplaceSpacesInsideLinkFix
    extends LocalQuickFixOnPsiElement {
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final TextRange range;
        @NotNull
        private final String replacement;

        public ReplaceSpacesInsideLinkFix(@NotNull MarkdownLinkDestination link, @NotNull TextRange range, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            super((PsiElement)link);
            this.range = range;
            this.replacement = replacement;
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.replacement};
            String string = MarkdownBundle.message("markdown.link.destination.with.spaces.quick.fix.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (!(startElement instanceof MarkdownLinkDestination)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            String string = this.range.replace(((MarkdownLinkDestination)startElement).getText(), this.replacement);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
            String content2 = string;
            MarkdownLinkDestination markdownLinkDestination = MarkdownPsiElementFactory.createLinkDestination(project, content2);
            Intrinsics.checkNotNullExpressionValue((Object)markdownLinkDestination, (String)"createLinkDestination(...)");
            MarkdownLinkDestination element2 = markdownLinkDestination;
            startElement.replace((PsiElement)element2);
        }
    }
}

