/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor.paste;

import com.intellij.lang.Language;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FileDropEvent;
import com.intellij.openapi.editor.FileDropHandler;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.fileTypes.impl.SvgFileType;
import org.intellij.plugins.markdown.editor.EditorUtilKt;
import org.intellij.plugins.markdown.images.MarkdownImagesBundle;
import org.intellij.plugins.markdown.images.editor.ImageUtils;
import org.intellij.plugins.markdown.images.editor.paste.MarkdownFileDropHandler;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ,\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0082@\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/images/editor/paste/MarkdownFileDropHandler;", "Lcom/intellij/openapi/editor/FileDropHandler;", "()V", "canHandle", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "handleDrop", "e", "Lcom/intellij/openapi/editor/FileDropEvent;", "(Lcom/intellij/openapi/editor/FileDropEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "files", "", "Ljava/io/File;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Manager", "intellij.markdown.images"})
public final class MarkdownFileDropHandler
implements FileDropHandler {
    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object handleDrop(@NotNull FileDropEvent var1_1, @NotNull Continuation<? super Boolean> var2_2) {
        if (!(var2_2 instanceof handleDrop.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MarkdownFileDropHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handleDrop(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (e.getEditor() == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = e;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)((Function0)new Function0<Boolean>(this, e){
                    final /* synthetic */ MarkdownFileDropHandler this$0;
                    final /* synthetic */ FileDropEvent $e;
                    {
                        this.this$0 = $receiver;
                        this.$e = $e;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        Project project = this.$e.getProject();
                        Editor editor2 = this.$e.getEditor();
                        Intrinsics.checkNotNull((Object)editor2);
                        return MarkdownFileDropHandler.access$canHandle(this.this$0, project, editor2);
                    }
                }), (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                e = (FileDropEvent)$continuation.L$1;
                this = (MarkdownFileDropHandler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                v1 = e.getProject();
                v2 = e.getFiles();
                v3 = e.getEditor();
                Intrinsics.checkNotNull((Object)v3);
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v4 = this.handleDrop(v1, v2, v3, (Continuation<? super Boolean>)$continuation);
                if (v4 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl42
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl42:
                // 2 sources

                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canHandle(Project project, Editor editor2) {
        if (editor2.isDisposed()) {
            return false;
        }
        if (!editor2.getDocument().isWritable()) {
            return false;
        }
        if (!((MarkdownCodeInsightSettings.State)MarkdownCodeInsightSettings.Companion.getInstance().getState()).getEnableFileDrop()) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        if (file == null) return false;
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (!MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) return false;
        return true;
    }

    private final Object handleDrop(Project project, Collection<? extends File> files, Editor editor2, Continuation<? super Boolean> $completion) {
        return CoroutinesKt.writeAction((Function0)((Function0)new Function0<Boolean>(editor2, project, files){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection<File> $files;
            {
                this.$editor = $editor;
                this.$project = $project;
                this.$files = $files;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                PsiFile file;
                block6: {
                    block5: {
                        if (this.$editor.isDisposed()) {
                            return false;
                        }
                        file = PsiDocumentManager.getInstance((Project)this.$project).getPsiFile(this.$editor.getDocument());
                        if (file == null) break block5;
                        Language language = file.getLanguage();
                        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                        if (MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) break block6;
                    }
                    return false;
                }
                Iterable iterable = this.$files;
                Manager manager = Manager.INSTANCE;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toPath());
                }
                String content2 = manager.buildTextContent((Sequence<? extends Path>)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv)), file);
                Document document = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                Manager.INSTANCE.handleReadOnlyModificationException(this.$project, document2, (Function0<Unit>)((Function0)new Function0<Unit>(this.$project, this.$editor, document2, content2){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ String $content;
                    {
                        this.$project = $project;
                        this.$editor = $editor;
                        this.$document = $document;
                        this.$content = $content;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void name$iv;
                        void project$iv;
                        Project project = this.$project;
                        String string = Manager.INSTANCE.getCommandName();
                        Editor editor2 = this.$editor;
                        Document document = this.$document;
                        String string2 = this.$content;
                        Object groupId$iv = null;
                        boolean $i$f$executeCommand = false;
                        CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(editor2, document, string2){
                            final /* synthetic */ Editor $editor$inlined;
                            final /* synthetic */ Document $document$inlined;
                            final /* synthetic */ String $content$inlined;
                            {
                                this.$editor$inlined = editor2;
                                this.$document$inlined = document;
                                this.$content$inlined = string;
                            }

                            public final void run() {
                                boolean bl = false;
                                CaretModel caretModel = this.$editor$inlined.getCaretModel();
                                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
                                EditorUtilKt.runForEachCaret(caretModel, true, (Function1<? super Caret, Unit>)((Function1)new Function1<Caret, Unit>(this.$document$inlined, this.$content$inlined){
                                    final /* synthetic */ Document $document;
                                    final /* synthetic */ String $content;
                                    {
                                        this.$document = $document;
                                        this.$content = $content;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Caret caret) {
                                        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                                        this.$document.insertString(caret.getOffset(), (CharSequence)this.$content);
                                        caret.moveToOffset(this.$content.length());
                                    }
                                }));
                            }
                        }, (String)name$iv, groupId$iv);
                    }
                }));
                return true;
            }
        }), $completion);
    }

    public static final /* synthetic */ boolean access$canHandle(MarkdownFileDropHandler $this, Project project, Editor editor2) {
        return $this.canHandle(project, editor2);
    }

    public static final /* synthetic */ Object access$handleDrop(MarkdownFileDropHandler $this, Project project, Collection files, Editor editor2, Continuation $completion) {
        return $this.handleDrop(project, files, editor2, (Continuation<? super Boolean>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/images/editor/paste/MarkdownFileDropHandler$Manager;", "", "()V", "commandName", "", "Lorg/jetbrains/annotations/Nls;", "getCommandName", "()Ljava/lang/String;", "buildTextContent", "files", "Lkotlin/sequences/Sequence;", "Ljava/nio/file/Path;", "file", "Lcom/intellij/psi/PsiFile;", "createFileLink", "createImageLink", "createUri", "url", "handleReadOnlyModificationException", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "block", "Lkotlin/Function0;", "obtainDirectoryPath", "obtainRelativePath", "path", "currentDirectory", "intellij.markdown.images"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        @NotNull
        public final String getCommandName() {
            return MarkdownImagesBundle.INSTANCE.message("markdown.image.file.drop.handler.drop.command.name", new Object[0]);
        }

        @NotNull
        public final String buildTextContent(@NotNull Sequence<? extends Path> files, @NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            FileType fileType2 = ImageFileTypeManager.getInstance().getImageFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getImageFileType(...)");
            FileType imageFileType = fileType2;
            FileTypeRegistry registry = FileTypeRegistry.getInstance();
            Path currentDirectory = this.obtainDirectoryPath(file);
            Sequence relativePaths2 = SequencesKt.map(files, (Function1)((Function1)new Function1<Path, Path>(currentDirectory){
                final /* synthetic */ Path $currentDirectory;
                {
                    this.$currentDirectory = $currentDirectory;
                    super(1);
                }

                @NotNull
                public final Path invoke(@NotNull Path it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Manager.access$obtainRelativePath(Manager.INSTANCE, it, this.$currentDirectory);
                }
            }));
            return SequencesKt.joinToString$default((Sequence)relativePaths2, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Path, CharSequence>(registry, imageFileType){
                final /* synthetic */ FileTypeRegistry $registry;
                final /* synthetic */ FileType $imageFileType;
                {
                    this.$registry = $registry;
                    this.$imageFileType = $imageFileType;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Path path) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    FileType fileType2 = this.$registry.getFileTypeByExtension(PathsKt.getExtension((Path)path));
                    return (Intrinsics.areEqual((Object)fileType2, (Object)this.$imageFileType) ? true : Intrinsics.areEqual((Object)fileType2, (Object)SvgFileType.INSTANCE)) ? (CharSequence)Manager.access$createImageLink(Manager.INSTANCE, path) : (CharSequence)Manager.access$createFileLink(Manager.INSTANCE, path);
                }
            }), (int)30, null);
        }

        private final Path obtainDirectoryPath(PsiFile file) {
            PsiDirectory psiDirectory = file.getContainingDirectory();
            if (psiDirectory == null || (psiDirectory = psiDirectory.getVirtualFile()) == null) {
                return null;
            }
            PsiDirectory directory = psiDirectory;
            return directory.getFileSystem().getNioPath((VirtualFile)directory);
        }

        private final Path obtainRelativePath(Path path, Path currentDirectory) {
            if (currentDirectory == null) {
                return path;
            }
            return PathsKt.relativeTo((Path)path, (Path)currentDirectory);
        }

        private final String createUri(String url) {
            List list2 = FileUtil.splitPath((String)url);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"splitPath(...)");
            return CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"/", null, null, (int)0, null, (Function1)createUri.1.INSTANCE, (int)30, null);
        }

        private final String createImageLink(Path file) {
            String string = PathsKt.getName((Path)file);
            String string2 = FileUtil.toSystemIndependentName((String)((Object)file).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            return ImageUtils.createMarkdownImageText$default(string, this.createUri(string2), null, 4, null);
        }

        private final String createFileLink(Path file) {
            String string = FileUtil.toSystemIndependentName((String)((Object)file).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
            String independentPath = this.createUri(string);
            return "[" + PathsKt.getName((Path)file) + "](" + independentPath + ")";
        }

        public final void handleReadOnlyModificationException(@NotNull Project project, @NotNull Document document, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            try {
                block.invoke();
            }
            catch (ReadOnlyModificationException exception) {
                Messages.showErrorDialog((Project)project, (String)exception.getLocalizedMessage(), (String)RefactoringBundle.message((String)"error.title"));
            }
            catch (ReadOnlyFragmentModificationException exception) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(exception);
            }
        }

        public static final /* synthetic */ Path access$obtainRelativePath(Manager $this, Path path, Path currentDirectory) {
            return $this.obtainRelativePath(path, currentDirectory);
        }

        public static final /* synthetic */ String access$createImageLink(Manager $this, Path file) {
            return $this.createImageLink(file);
        }

        public static final /* synthetic */ String access$createFileLink(Manager $this, Path file) {
            return $this.createFileLink(file);
        }
    }
}

