/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.auto.reload;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@ApiStatus.Internal
public class MavenRenameModuleWatcher
implements ModuleListener {
    public void modulesRenamed(@NotNull Project project2, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
        if (project2 == null) {
            MavenRenameModuleWatcher.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            MavenRenameModuleWatcher.$$$reportNull$$$0(1);
        }
        if (oldNameProvider == null) {
            MavenRenameModuleWatcher.$$$reportNull$$$0(2);
        }
        for (Module module2 : modules) {
            new MavenRenameModuleHandler(project2, module2, (String)oldNameProvider.fun((Object)module2)).handleModuleRename();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "modules";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "oldNameProvider";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/project/auto/reload/MavenRenameModuleWatcher";
        objectArray[2] = "modulesRenamed";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MavenRenameModuleHandler {
        private final Project myProject;
        private final Module myModule;
        private final String myOldName;
        private final String myNewName;
        private String myGroupId;
        private final MavenProjectsManager myProjectsManager;

        private MavenRenameModuleHandler(@NotNull Project project2, @NotNull Module module2, @NotNull String oldName) {
            if (project2 == null) {
                MavenRenameModuleHandler.$$$reportNull$$$0(0);
            }
            if (module2 == null) {
                MavenRenameModuleHandler.$$$reportNull$$$0(1);
            }
            if (oldName == null) {
                MavenRenameModuleHandler.$$$reportNull$$$0(2);
            }
            this.myProject = project2;
            this.myModule = module2;
            this.myOldName = oldName;
            String[] myNewNameHierarchy = module2.getName().split("\\.");
            this.myNewName = myNewNameHierarchy[myNewNameHierarchy.length - 1];
            this.myProjectsManager = MavenProjectsManager.getInstance(project2);
        }

        private void replaceArtifactId(@Nullable XmlTag parentTag) {
            if (null == parentTag) {
                return;
            }
            XmlTag artifactIdTag = parentTag.findFirstSubTag("artifactId");
            if (null == artifactIdTag) {
                return;
            }
            XmlTag groupIdTag = parentTag.findFirstSubTag("groupId");
            if (null == groupIdTag) {
                return;
            }
            if (this.myGroupId.equals(groupIdTag.getValue().getText()) && this.myOldName.equals(artifactIdTag.getValue().getText())) {
                artifactIdTag.getValue().setText(this.myNewName);
            }
        }

        private void replaceModuleArtifactId(MavenDomProjectModel mavenModel) {
            XmlTag artifactIdTag = mavenModel.getArtifactId().getXmlTag();
            if (null != artifactIdTag && this.myOldName.equals(artifactIdTag.getValue().getText())) {
                artifactIdTag.getValue().setText(this.myNewName);
            }
        }

        private void replaceArtifactIdReferences(@NotNull MavenDomDependencies dependencies) {
            if (dependencies == null) {
                MavenRenameModuleHandler.$$$reportNull$$$0(3);
            }
            for (MavenDomDependency dependency : dependencies.getDependencies()) {
                this.replaceArtifactId(dependency.getXmlTag());
                for (MavenDomExclusion exclusion : dependency.getExclusions().getExclusions()) {
                    this.replaceArtifactId(exclusion.getXmlTag());
                }
            }
        }

        private void replaceArtifactIdReferences(MavenDomProjectModel mavenModel) {
            if (null != mavenModel.getXmlTag()) {
                this.replaceArtifactId(mavenModel.getXmlTag().findFirstSubTag("parent"));
            }
            this.replaceArtifactIdReferences(mavenModel.getDependencies());
            this.replaceArtifactIdReferences(mavenModel.getDependencyManagement().getDependencies());
        }

        private void processModule(Module module2, Consumer<MavenDomProjectModel> artifactIdReplacer) {
            if (!this.myProjectsManager.isMavenizedModule(module2)) {
                return;
            }
            MavenProject mavenProject2 = this.myProjectsManager.findProject(module2);
            if (null == mavenProject2) {
                return;
            }
            MavenDomProjectModel mavenModel = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject2.getFile());
            if (null == mavenModel) {
                return;
            }
            XmlFile psiFile = DomUtil.getFile((DomElement)mavenModel);
            WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])new PsiFile[]{psiFile}).run(() -> {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                Document document = documentManager.getDocument((PsiFile)psiFile);
                if (document != null) {
                    documentManager.commitDocument(document);
                }
                artifactIdReplacer.accept(mavenModel);
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            });
        }

        public void handleModuleRename() {
            Module[] modules;
            if (!this.myProjectsManager.isMavenizedModule(this.myModule)) {
                return;
            }
            MavenProject mavenProject2 = this.myProjectsManager.findProject(this.myModule);
            if (null == mavenProject2) {
                return;
            }
            this.myGroupId = mavenProject2.getMavenId().getGroupId();
            for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (module2 == this.myModule) {
                    this.processModule(module2, this::replaceModuleArtifactId);
                    continue;
                }
                this.processModule(module2, this::replaceArtifactIdReferences);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/project/auto/reload/MavenRenameModuleWatcher$MavenRenameModuleHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceArtifactIdReferences";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

