/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.auto.reload;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.auto.reload.MavenGeneralSettingsWatcher;
import org.jetbrains.idea.maven.project.auto.reload.MavenProfileWatcher;
import org.jetbrains.idea.maven.project.auto.reload.MavenProjectAware;
import org.jetbrains.idea.maven.project.auto.reload.MavenRenameModuleWatcher;
import org.jetbrains.idea.maven.utils.MavenUtil;

@ApiStatus.Internal
public final class MavenProjectManagerWatcher {
    private final Project myProject;
    @NotNull
    private MavenProjectsTree myProjectTree;
    private final MavenProjectAware myProjectAware;
    private final MavenProfileWatcher myProfileWatcher;
    private final MavenRenameModuleWatcher myRenameModuleWatcher;
    private final MavenGeneralSettingsWatcher myGeneralSettingsWatcher;
    private final Disposable myDisposable;

    public MavenProjectManagerWatcher(Project project2, @NotNull MavenProjectsTree projectTree) {
        if (projectTree == null) {
            MavenProjectManagerWatcher.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myProjectTree = projectTree;
        ExecutorService backgroundExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"MavenProjectsManagerWatcher.backgroundExecutor", (int)1);
        MavenProjectsManager projectManager = MavenProjectsManager.getInstance(this.myProject);
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.myProject);
        ExternalSystemProjectId projectId = new ExternalSystemProjectId(MavenUtil.SYSTEM_ID, this.myProject.getName());
        this.myProjectAware = new MavenProjectAware(project2, projectId, projectManager);
        this.myProfileWatcher = new MavenProfileWatcher(projectId, projectTracker, projectManager);
        this.myRenameModuleWatcher = new MavenRenameModuleWatcher();
        this.myGeneralSettingsWatcher = new MavenGeneralSettingsWatcher(projectManager, backgroundExecutor);
        this.myDisposable = Disposer.newDisposable((Disposable)projectManager, (String)MavenProjectManagerWatcher.class.toString());
    }

    public synchronized void start() {
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect(this.myDisposable);
        busConnection.subscribe(ModuleListener.TOPIC, (Object)this.myRenameModuleWatcher);
        this.myGeneralSettingsWatcher.subscribeOnSettingsChanges(this.myDisposable);
        this.myGeneralSettingsWatcher.subscribeOnSettingsFileChanges(this.myDisposable);
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.myProject);
        projectTracker.register((ExternalSystemProjectAware)this.myProjectAware, (Disposable)projectsManager);
        projectTracker.activate(this.myProjectAware.getProjectId());
        this.myProfileWatcher.subscribeOnProfileChanges(this.myDisposable);
    }

    @TestOnly
    public synchronized void enableAutoImportInTests() {
        AutoImportProjectTracker.Companion.enableAutoReloadInTests(this.myDisposable);
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @NotNull
    public MavenProjectsTree getProjectTree() {
        MavenProjectsTree mavenProjectsTree = this.myProjectTree;
        if (mavenProjectsTree == null) {
            MavenProjectManagerWatcher.$$$reportNull$$$0(1);
        }
        return mavenProjectsTree;
    }

    public void setProjectTree(@NotNull MavenProjectsTree projectTree) {
        if (projectTree == null) {
            MavenProjectManagerWatcher.$$$reportNull$$$0(2);
        }
        this.myProjectTree = projectTree;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/auto/reload/MavenProjectManagerWatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/auto/reload/MavenProjectManagerWatcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProjectTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

