/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class ToggleProfileAction
extends MavenAction {
    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleProfileAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        if (!this.isAvailable(e)) {
            return;
        }
        MavenProfileKind targetState = ToggleProfileAction.getTargetState(e);
        if (targetState == null) {
            return;
        }
        String text2 = MavenProjectBundle.message(switch (targetState) {
            default -> throw new IncompatibleClassChangeError();
            case MavenProfileKind.NONE -> "maven.profile.deactivate";
            case MavenProfileKind.EXPLICIT -> "maven.profile.activate";
            case MavenProfileKind.IMPLICIT -> "maven.profile.default";
        }, new Object[0]);
        e.getPresentation().setText(text2);
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleProfileAction.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(e)) {
            return false;
        }
        return ToggleProfileAction.getTargetState(e) != null;
    }

    @Nullable
    private static MavenProfileKind getTargetState(AnActionEvent e) {
        Map selectedProfiles = (Map)e.getData(MavenDataKeys.MAVEN_PROFILES);
        if (selectedProfiles == null || selectedProfiles.isEmpty()) {
            return null;
        }
        MavenProjectsManager projectsManager = MavenActionUtil.getProjectsManager(e.getDataContext());
        if (projectsManager == null) {
            return null;
        }
        return ToggleProfileAction.getTargetState(projectsManager, selectedProfiles);
    }

    @Nullable
    private static MavenProfileKind getTargetState(@NotNull MavenProjectsManager projectsManager, Map<String, MavenProfileKind> profiles2) {
        if (projectsManager == null) {
            ToggleProfileAction.$$$reportNull$$$0(2);
        }
        MavenExplicitProfiles explicitProfiles2 = projectsManager.getExplicitProfiles();
        MavenProfileKind targetState = null;
        for (Map.Entry<String, MavenProfileKind> profile : profiles2.entrySet()) {
            MavenProfileKind profileTargetState = ToggleProfileAction.getTargetState(profile, explicitProfiles2);
            if (targetState == null) {
                targetState = profileTargetState;
                continue;
            }
            if (targetState.equals((Object)profileTargetState)) continue;
            targetState = null;
            break;
        }
        return targetState;
    }

    private static MavenProfileKind getTargetState(Map.Entry<String, MavenProfileKind> profile, MavenExplicitProfiles explicitProfiles2) {
        MavenProfileKind targetState = explicitProfiles2.getDisabledProfiles().contains(profile.getKey()) ? MavenProfileKind.EXPLICIT : (explicitProfiles2.getEnabledProfiles().contains(profile.getKey()) ? MavenProfileKind.IMPLICIT : (MavenProfileKind.NONE.equals((Object)profile.getValue()) ? MavenProfileKind.EXPLICIT : MavenProfileKind.NONE));
        return targetState;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        MavenProjectsManager manager;
        if (e == null) {
            ToggleProfileAction.$$$reportNull$$$0(3);
        }
        if ((manager = MavenActionUtil.getProjectsManager(e.getDataContext())) == null) {
            return;
        }
        Map selectedProfiles = (Map)e.getData(MavenDataKeys.MAVEN_PROFILES);
        if (selectedProfiles == null) {
            return;
        }
        Set selectedProfileIds = selectedProfiles.keySet();
        MavenProfileKind targetState = ToggleProfileAction.getTargetState(manager, selectedProfiles);
        if (targetState == null) {
            return;
        }
        MavenExplicitProfiles newExplicitProfiles = manager.getExplicitProfiles().clone();
        switch (targetState) {
            case NONE: {
                newExplicitProfiles.getEnabledProfiles().removeAll(selectedProfileIds);
                newExplicitProfiles.getDisabledProfiles().addAll(selectedProfileIds);
                break;
            }
            case EXPLICIT: {
                newExplicitProfiles.getDisabledProfiles().removeAll(selectedProfileIds);
                newExplicitProfiles.getEnabledProfiles().addAll(selectedProfileIds);
                break;
            }
            case IMPLICIT: {
                newExplicitProfiles.getEnabledProfiles().removeAll(selectedProfileIds);
                newExplicitProfiles.getDisabledProfiles().removeAll(selectedProfileIds);
            }
        }
        manager.setExplicitProfiles(newExplicitProfiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsManager";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/actions/ToggleProfileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

