/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.progress.RawProgressReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectChangesBuilder;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenProjectTimestamp;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdateContext;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdater;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001<B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u001dJ$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\u0006\u0010\u001c\u001a\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!H\u0002J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\u0006\u0010\u001c\u001a\u00020\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u001fH\u0002J$\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\u0006\u0010&\u001a\u00020\u000fH\u0002J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0013H\u0002J\u0012\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u0016H\u0002J,\u0010,\u001a\u00020-2\u0006\u0010\u001c\u001a\u00020\u00142\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140\u001f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u001fH\u0002J\u001e\u0010/\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u000fH\u0082@\u00a2\u0006\u0002\u00101J\u001e\u00102\u001a\u00020-2\u0006\u0010\u001c\u001a\u00020\u00142\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00130\u001fH\u0002J\u0018\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u000fH\u0002J\u001e\u00106\u001a\u00020-2\u0006\u00105\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u000fH\u0082@\u00a2\u0006\u0002\u00107J\u001c\u00108\u001a\u00020-2\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u001fH\u0086@\u00a2\u0006\u0002\u0010;R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0019\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater;", "", "tree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "explicitProfiles", "Lorg/jetbrains/idea/maven/model/MavenExplicitProfiles;", "updateContext", "Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdateContext;", "reader", "Lorg/jetbrains/idea/maven/project/MavenProjectReader;", "generalSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "process", "Lcom/intellij/platform/util/progress/RawProgressReporter;", "updateModules", "", "(Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lorg/jetbrains/idea/maven/model/MavenExplicitProfiles;Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdateContext;Lorg/jetbrains/idea/maven/project/MavenProjectReader;Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;Lcom/intellij/platform/util/progress/RawProgressReporter;Z)V", "createdMavenProjects", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "globalSettingsFile", "Ljava/io/File;", "Lorg/jetbrains/annotations/Nullable;", "updated", "userSettingsFile", "calculateTimestamp", "Lorg/jetbrains/idea/maven/project/MavenProjectTimestamp;", "mavenProject", "(Lorg/jetbrains/idea/maven/project/MavenProject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectChildFilesToUpdate", "", "prevChildren", "", "collectModuleFilesToReconnect", "existingModuleFiles", "collectModuleFilesToUpdate", "moduleFilesToReconnect", "updateExistingModules", "findOrCreateProject", "f", "getFileTimestamp", "", "file", "handleRemovedModules", "", "prevModules", "readPomIfNeeded", "forceRead", "(Lorg/jetbrains/idea/maven/project/MavenProject;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reconnectModuleFiles", "modulesFilesToReconnect", "startUpdate", "mavenProjectFile", "update", "(Lcom/intellij/openapi/vfs/VirtualFile;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateProjects", "specs", "Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater$UpdateSpec;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "UpdateSpec", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenProjectsTreeUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectsTreeUpdater.kt\norg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n766#2:271\n857#2,2:272\n766#2:274\n857#2,2:275\n1549#2:277\n1620#2,3:278\n1549#2:281\n1620#2,3:282\n1549#2:285\n1620#2,3:286\n*S KotlinDebug\n*F\n+ 1 MavenProjectsTreeUpdater.kt\norg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater\n*L\n118#1:271\n118#1:272,2\n168#1:274\n168#1:275,2\n175#1:277\n175#1:278,3\n223#1:281\n223#1:282,3\n234#1:285\n234#1:286,3\n*E\n"})
public final class MavenProjectsTreeUpdater {
    @NotNull
    private final MavenProjectsTree tree;
    @NotNull
    private final MavenExplicitProfiles explicitProfiles;
    @NotNull
    private final MavenProjectsTreeUpdateContext updateContext;
    @NotNull
    private final MavenProjectReader reader;
    @NotNull
    private final MavenGeneralSettings generalSettings;
    @Nullable
    private final RawProgressReporter process;
    private final boolean updateModules;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, Boolean> updated;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, MavenProject> createdMavenProjects;
    @Nullable
    private final File userSettingsFile;
    @Nullable
    private final File globalSettingsFile;

    public MavenProjectsTreeUpdater(@NotNull MavenProjectsTree tree, @NotNull MavenExplicitProfiles explicitProfiles2, @NotNull MavenProjectsTreeUpdateContext updateContext, @NotNull MavenProjectReader reader, @NotNull MavenGeneralSettings generalSettings, @Nullable RawProgressReporter process2, boolean updateModules) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)explicitProfiles2, (String)"explicitProfiles");
        Intrinsics.checkNotNullParameter((Object)updateContext, (String)"updateContext");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)generalSettings, (String)"generalSettings");
        this.tree = tree;
        this.explicitProfiles = explicitProfiles2;
        this.updateContext = updateContext;
        this.reader = reader;
        this.generalSettings = generalSettings;
        this.process = process2;
        this.updateModules = updateModules;
        this.updated = new ConcurrentHashMap();
        this.createdMavenProjects = new ConcurrentHashMap();
        this.userSettingsFile = this.generalSettings.getEffectiveUserSettingsIoFile();
        this.globalSettingsFile = this.generalSettings.getEffectiveGlobalSettingsIoFile();
    }

    private final boolean startUpdate(VirtualFile mavenProjectFile, boolean forceRead) {
        block2: {
            String string = mavenProjectFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String projectPath = string;
            if (this.tree.isIgnored(projectPath)) {
                MavenLog.LOG.trace("Won't update ignored file " + mavenProjectFile);
                return false;
            }
            Ref previousUpdateRef = new Ref();
            this.updated.compute(mavenProjectFile, (arg_0, arg_1) -> MavenProjectsTreeUpdater.startUpdate$lambda$0((Function2)new Function2<VirtualFile, Boolean, Boolean>((Ref<Boolean>)previousUpdateRef, forceRead){
                final /* synthetic */ Ref<Boolean> $previousUpdateRef;
                final /* synthetic */ boolean $forceRead;
                {
                    this.$previousUpdateRef = $previousUpdateRef;
                    this.$forceRead = $forceRead;
                    super(2);
                }

                @Nullable
                public final Boolean invoke(@Nullable VirtualFile virtualFile, @Nullable Boolean value) {
                    this.$previousUpdateRef.set((Object)value);
                    return Intrinsics.areEqual((Object)true, (Object)value) || this.$forceRead;
                }
            }, arg_0, arg_1));
            Boolean previousUpdate = (Boolean)previousUpdateRef.get();
            if (previousUpdate != null && !forceRead || Intrinsics.areEqual((Object)true, (Object)previousUpdate)) {
                MavenLog.LOG.trace("Has already been updated (" + previousUpdate + "): " + mavenProjectFile + "; forceRead: " + forceRead);
                return false;
            }
            RawProgressReporter rawProgressReporter = this.process;
            if (rawProgressReporter == null) break block2;
            Object[] objectArray = new Object[]{projectPath};
            rawProgressReporter.text(MavenProjectBundle.message("maven.reading.pom", objectArray));
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final Object readPomIfNeeded(MavenProject var1_1, boolean var2_2, Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof readPomIfNeeded.1)) ** GOTO lbl-1000
        var14_4 = var3_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenProjectsTreeUpdater.access$readPomIfNeeded(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = mavenProject;
                $continuation.Z$0 = forceRead;
                $continuation.label = 1;
                v0 = this.calculateTimestamp(mavenProject, (Continuation<? super MavenProjectTimestamp>)$continuation);
                if (v0 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                forceRead = $continuation.Z$0;
                mavenProject = (MavenProject)$continuation.L$1;
                this = (MavenProjectsTreeUpdater)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                timeStampChanged = Intrinsics.areEqual((Object)(timestamp = (MavenProjectTimestamp)v0), (Object)this.tree.getTimeStamp$intellij_maven(mavenProject)) == false;
                v1 = readPom = forceRead != false || timeStampChanged != false ? 1 : 0;
                if (readPom == 0) ** GOTO lbl89
                oldProjectId = mavenProject.isNew() != false ? null : mavenProject.getMavenId();
                oldParentId = mavenProject.getParentId();
                v2 = mavenProject.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getFile(...)");
                $continuation.L$0 = this;
                $continuation.L$1 = mavenProject;
                $continuation.L$2 = timestamp;
                $continuation.L$3 = oldProjectId;
                $continuation.L$4 = oldParentId;
                $continuation.Z$0 = forceRead;
                $continuation.I$0 = readPom;
                $continuation.label = 2;
                v3 = this.reader.readProjectAsync(this.generalSettings, v2, this.explicitProfiles, this.tree.getProjectLocator(), (Continuation<? super MavenProjectReaderResult>)$continuation);
                if (v3 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl55
            }
            case 2: {
                readPom = $continuation.I$0;
                forceRead = $continuation.Z$0;
                oldParentId = (MavenId)$continuation.L$4;
                oldProjectId = (MavenId)$continuation.L$3;
                timestamp = (MavenProjectTimestamp)$continuation.L$2;
                mavenProject = (MavenProject)$continuation.L$1;
                this = (MavenProjectsTreeUpdater)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl55:
                // 2 sources

                readerResult = (MavenProjectReaderResult)v3;
                var11_13 = mavenProject.updateFromReaderResult(readerResult, this.generalSettings, true);
                Intrinsics.checkNotNullExpressionValue((Object)var11_13, (String)"updateFromReaderResult(...)");
                readChanges = var11_13;
                this.tree.putVirtualFileToProjectMapping(mavenProject, oldProjectId);
                if (!Comparing.equal((Object)oldParentId, (Object)mavenProject.getParentId())) ** GOTO lbl63
                this.tree.putTimestamp$intellij_maven(mavenProject, timestamp);
                ** GOTO lbl85
lbl63:
                // 1 sources

                $continuation.L$0 = this;
                $continuation.L$1 = mavenProject;
                $continuation.L$2 = readChanges;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.Z$0 = forceRead;
                $continuation.I$0 = readPom;
                $continuation.label = 3;
                v4 = this.calculateTimestamp(mavenProject, (Continuation<? super MavenProjectTimestamp>)$continuation);
                if (v4 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl83
            }
            case 3: {
                readPom = $continuation.I$0;
                forceRead = $continuation.Z$0;
                readChanges = (MavenProjectChanges)$continuation.L$2;
                mavenProject = (MavenProject)$continuation.L$1;
                this = (MavenProjectsTreeUpdater)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl83:
                // 2 sources

                newTimestamp = (MavenProjectTimestamp)v4;
                this.tree.putTimestamp$intellij_maven(mavenProject, newTimestamp);
lbl85:
                // 2 sources

                forcedChanges = forceRead != false ? MavenProjectChanges.ALL : MavenProjectChanges.NONE;
                Intrinsics.checkNotNull((Object)forcedChanges);
                changes = MavenProjectChangesBuilder.Companion.merged(forcedChanges, readChanges);
                this.updateContext.updated(mavenProject, changes);
lbl89:
                // 2 sources

                return Boxing.boxBoolean((boolean)(readPom != 0));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object calculateTimestamp(MavenProject mavenProject2, Continuation<? super MavenProjectTimestamp> $completion) {
        return CoroutinesKt.readAction((Function0)((Function0)new Function0<MavenProjectTimestamp>(this, mavenProject2){
            final /* synthetic */ MavenProjectsTreeUpdater this$0;
            final /* synthetic */ MavenProject $mavenProject;
            {
                this.this$0 = $receiver;
                this.$mavenProject = $mavenProject;
                super(0);
            }

            @NotNull
            public final MavenProjectTimestamp invoke() {
                MavenProject parent;
                long pomTimestamp = MavenProjectsTreeUpdater.access$getFileTimestamp(this.this$0, this.$mavenProject.getFile());
                MavenProject mavenProject2 = parent = MavenProjectsTreeUpdater.access$getTree$p(this.this$0).findParent(this.$mavenProject);
                long parentTimestamp = MavenProjectsTreeUpdater.access$getFileTimestamp(this.this$0, (VirtualFile)(mavenProject2 != null ? mavenProject2.getFile() : null));
                VirtualFile profilesXmlFile = this.$mavenProject.getProfilesXmlFile();
                long profilesTimestamp = MavenProjectsTreeUpdater.access$getFileTimestamp(this.this$0, profilesXmlFile);
                VirtualFile jvmConfigFile = MavenUtil.getConfigFile(this.$mavenProject, "/.mvn/jvm.config");
                long jvmConfigTimestamp = MavenProjectsTreeUpdater.access$getFileTimestamp(this.this$0, jvmConfigFile);
                VirtualFile mavenConfigFile = MavenUtil.getConfigFile(this.$mavenProject, "/.mvn/maven.config");
                long mavenConfigTimestamp = MavenProjectsTreeUpdater.access$getFileTimestamp(this.this$0, mavenConfigFile);
                long userSettingsTimestamp = MavenProjectsTreeUpdater.access$getFileTimestamp(this.this$0, MavenProjectsTreeUpdater.access$getUserSettingsFile$p(this.this$0));
                long globalSettingsTimestamp = MavenProjectsTreeUpdater.access$getFileTimestamp(this.this$0, MavenProjectsTreeUpdater.access$getGlobalSettingsFile$p(this.this$0));
                int profilesHashCode = MavenProjectsTreeUpdater.access$getExplicitProfiles$p(this.this$0).hashCode();
                return new MavenProjectTimestamp(pomTimestamp, parentTimestamp, profilesTimestamp, userSettingsTimestamp, globalSettingsTimestamp, profilesHashCode, jvmConfigTimestamp, mavenConfigTimestamp);
            }
        }), $completion);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRemovedModules(MavenProject mavenProject2, List<? extends MavenProject> prevModules, List<? extends VirtualFile> existingModuleFiles) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = prevModules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenProject it = (MavenProject)element$iv$iv;
            boolean bl = false;
            if (!(!existingModuleFiles.contains(it.getFile()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List removedModules = (List)destination$iv$iv;
        for (MavenProject module2 : removedModules) {
            VirtualFile moduleFile;
            Intrinsics.checkNotNullExpressionValue((Object)module2.getFile(), (String)"getFile(...)");
            if (this.tree.isManagedFile(moduleFile)) {
                if (!this.tree.reconnectRoot(module2)) continue;
                this.updateContext.updated(module2, MavenProjectChanges.NONE);
                continue;
            }
            this.tree.removeModule(mavenProject2, module2);
            this.tree.doDelete$intellij_maven(mavenProject2, module2, this.updateContext);
        }
    }

    private final void reconnectModuleFiles(MavenProject mavenProject2, List<? extends VirtualFile> modulesFilesToReconnect) {
        for (VirtualFile virtualFile : modulesFilesToReconnect) {
            MavenProject module2 = this.tree.findProject(virtualFile);
            if (module2 == null || !this.tree.reconnect(mavenProject2, module2)) continue;
            this.updateContext.updated(module2, MavenProjectChanges.NONE);
        }
    }

    private final List<VirtualFile> collectModuleFilesToReconnect(MavenProject mavenProject2, List<? extends VirtualFile> existingModuleFiles) {
        ArrayList<VirtualFile> modulesFilesToReconnect = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : existingModuleFiles) {
            boolean isNewModule;
            MavenProject foundModule = this.tree.findProject(virtualFile);
            boolean bl = isNewModule = foundModule == null;
            if (!isNewModule) {
                MavenProject mavenProject3 = foundModule;
                Intrinsics.checkNotNull((Object)mavenProject3);
                MavenProject currentAggregator = this.tree.findAggregator(mavenProject3);
                if (currentAggregator != null && currentAggregator != mavenProject2) {
                    MavenLog.LOG.info("Module " + virtualFile + " is already included into " + mavenProject2.getFile());
                    continue;
                }
            }
            modulesFilesToReconnect.add(virtualFile);
        }
        return modulesFilesToReconnect;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectModuleFilesToUpdate(List<? extends VirtualFile> moduleFilesToReconnect, boolean updateExistingModules) {
        void $this$filterTo$iv$iv;
        if (updateExistingModules) {
            return moduleFilesToReconnect;
        }
        Iterable $this$filter$iv = moduleFilesToReconnect;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(this.tree.findProject(it) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectChildFilesToUpdate(MavenProject mavenProject2, Collection<? extends MavenProject> prevChildren) {
        void $this$mapTo$iv$iv;
        HashSet<? extends MavenProject> children = new HashSet<MavenProject>(prevChildren);
        Collection<MavenProject> collection = this.updateContext.getDeletedProjects();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getDeletedProjects(...)");
        children.removeAll(CollectionsKt.toSet((Iterable)collection));
        children.addAll(this.tree.findInheritors(mavenProject2));
        Iterable $this$map$iv = children;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MavenProject mavenProject3 = (MavenProject)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    private final MavenProject findOrCreateProject(VirtualFile f) {
        MavenProject mavenProject2 = this.tree.findProject(f);
        if (mavenProject2 != null) {
            return mavenProject2;
        }
        MavenProject mavenProject3 = this.createdMavenProjects.compute(f, (arg_0, arg_1) -> MavenProjectsTreeUpdater.findOrCreateProject$lambda$4((Function2)new Function2<VirtualFile, MavenProject, MavenProject>(f){
            final /* synthetic */ VirtualFile $f;
            {
                this.$f = $f;
                super(2);
            }

            @Nullable
            public final MavenProject invoke(@Nullable VirtualFile file, @Nullable MavenProject value) {
                if (value != null) {
                    return value;
                }
                MavenLog.LOG.debug("Maven tree updater: created new maven project " + file);
                return new MavenProject(this.$f);
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)mavenProject3);
        MavenProject createdMavenProject2 = mavenProject3;
        return createdMavenProject2;
    }

    /*
     * Unable to fully structure code
     */
    private final Object update(VirtualFile var1_1, boolean var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof update.1)) ** GOTO lbl-1000
        var27_4 = var3_3;
        if ((var27_4.label & -2147483648) != 0) {
            var27_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                boolean Z$1;
                /* synthetic */ Object result;
                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MavenProjectsTreeUpdater.access$update(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var28_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.startUpdate(mavenProjectFile, forceRead != false)) {
                    return Unit.INSTANCE;
                }
                MavenLog.LOG.trace("Maven tree updater: start update " + mavenProjectFile + ", forceRead=" + (forceRead != false));
                mavenProject = this.findOrCreateProject(mavenProjectFile);
                prevModules = this.tree.getModules(mavenProject);
                prevChildren = this.tree.findInheritors(mavenProject);
                $continuation.L$0 = this;
                $continuation.L$1 = mavenProjectFile;
                $continuation.L$2 = mavenProject;
                $continuation.L$3 = prevModules;
                $continuation.L$4 = prevChildren;
                $continuation.Z$0 = forceRead;
                $continuation.label = 1;
                v0 = this.readPomIfNeeded(mavenProject, forceRead != false, (Continuation<? super Boolean>)$continuation);
                if (v0 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl38
            }
            case 1: {
                forceRead = $continuation.Z$0;
                prevChildren = (Collection<MavenProject>)$continuation.L$4;
                prevModules = (List<MavenProject>)$continuation.L$3;
                mavenProject = (MavenProject)$continuation.L$2;
                mavenProjectFile = (VirtualFile)$continuation.L$1;
                this = (MavenProjectsTreeUpdater)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                readPom = (Boolean)v0;
                v1 = mavenProject.getExistingModuleFiles();
                Intrinsics.checkNotNullExpressionValue(v1, (String)"getExistingModuleFiles(...)");
                existingModuleFiles = v1;
                this.handleRemovedModules(mavenProject, prevModules, existingModuleFiles);
                modulesFilesToReconnect = this.collectModuleFilesToReconnect(mavenProject, existingModuleFiles);
                updateExistingModules = readPom != false || this.updateModules != false;
                modulesFilesToUpdate = this.collectModuleFilesToUpdate(modulesFilesToReconnect, updateExistingModules != false);
                forceReadModules = this.updateModules != false && forceRead != false;
                $this$map$iv = modulesFilesToUpdate;
                $i$f$map = false;
                var16_19 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var21_27 = (VirtualFile)item$iv$iv;
                    var25_30 = destination$iv$iv;
                    $i$a$-map-MavenProjectsTreeUpdater$update$moduleUpdates$1 = false;
                    var25_30.add(new UpdateSpec((VirtualFile)it, forceReadModules != false));
                }
                moduleUpdates = (List)destination$iv$iv;
                $continuation.L$0 = this;
                $continuation.L$1 = mavenProjectFile;
                $continuation.L$2 = mavenProject;
                $continuation.L$3 = prevChildren;
                $continuation.L$4 = modulesFilesToReconnect;
                $continuation.Z$0 = forceRead;
                $continuation.Z$1 = readPom;
                $continuation.label = 2;
                v2 = this.updateProjects(moduleUpdates, (Continuation<? super Unit>)$continuation);
                if (v2 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl82
            }
            case 2: {
                readPom = $continuation.Z$1;
                forceRead = $continuation.Z$0;
                modulesFilesToReconnect = (List<VirtualFile>)$continuation.L$4;
                prevChildren = (Collection)$continuation.L$3;
                mavenProject = (MavenProject)$continuation.L$2;
                mavenProjectFile = (VirtualFile)$continuation.L$1;
                this = (MavenProjectsTreeUpdater)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl82:
                // 2 sources

                this.reconnectModuleFiles(mavenProject, (List<? extends VirtualFile>)modulesFilesToReconnect);
                childFilesToUpdate = this.collectChildFilesToUpdate(mavenProject, prevChildren);
                $this$map$iv = childFilesToUpdate;
                $i$f$map = false;
                $i$f$mapTo = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var23_32 = (VirtualFile)item$iv$iv;
                    var25_30 = destination$iv$iv;
                    $i$a$-map-MavenProjectsTreeUpdater$update$childUpdates$1 = false;
                    var25_30.add(new UpdateSpec((VirtualFile)it, readPom != false));
                }
                childUpdates = (List)destination$iv$iv;
                $continuation.L$0 = mavenProjectFile;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.Z$0 = forceRead;
                $continuation.label = 3;
                v3 = this.updateProjects(childUpdates, (Continuation<? super Unit>)$continuation);
                if (v3 == var28_6) {
                    return var28_6;
                }
                ** GOTO lbl113
            }
            case 3: {
                forceRead = $continuation.Z$0;
                mavenProjectFile = (VirtualFile)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl113:
                // 2 sources

                MavenLog.LOG.trace("Maven tree updater: finish update " + mavenProjectFile + ", forceRead=" + (forceRead != false));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object updateProjects(@NotNull List<UpdateSpec> specs, @NotNull Continuation<? super Unit> $completion) {
        if (specs.isEmpty()) {
            return Unit.INSTANCE;
        }
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(specs, this, null){
            int label;
            final /* synthetic */ List<UpdateSpec> $specs;
            final /* synthetic */ MavenProjectsTreeUpdater this$0;
            {
                this.$specs = $specs;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$specs, this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ List<UpdateSpec> $specs;
                            final /* synthetic */ MavenProjectsTreeUpdater this$0;
                            {
                                this.$specs = $specs;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$forEach$iv;
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                        Iterable iterable = this.$specs;
                                        MavenProjectsTreeUpdater mavenProjectsTreeUpdater = this.this$0;
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            UpdateSpec it = (UpdateSpec)element$iv;
                                            boolean bl = false;
                                            BuildersKt.launch$default((CoroutineScope)$this$withContext, (CoroutineContext)((CoroutineContext)new CoroutineName("reading " + it.mavenProjectFile())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mavenProjectsTreeUpdater, it, null){
                                                int label;
                                                final /* synthetic */ MavenProjectsTreeUpdater this$0;
                                                final /* synthetic */ UpdateSpec $it;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$it = $it;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - void declaration
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object object) {
                                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)object);
                                                            this.label = 1;
                                                            Object object3 = MavenProjectsTreeUpdater.access$update(this.this$0, this.$it.mavenProjectFile(), this.$it.forceRead(), (Continuation)this);
                                                            if (object3 != object2) return Unit.INSTANCE;
                                                            return object2;
                                                        }
                                                        case 1: {
                                                            void $result;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object3 = $result;
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                @Nullable
                                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)2, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final long getFileTimestamp(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return -1L;
        }
        return file.getTimeStamp();
    }

    private final long getFileTimestamp(File file) {
        return this.getFileTimestamp(file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file));
    }

    private static final Boolean startUpdate$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final MavenProject findOrCreateProject$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MavenProject)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Object access$readPomIfNeeded(MavenProjectsTreeUpdater $this, MavenProject mavenProject2, boolean forceRead, Continuation $completion) {
        return $this.readPomIfNeeded(mavenProject2, forceRead, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$calculateTimestamp(MavenProjectsTreeUpdater $this, MavenProject mavenProject2, Continuation $completion) {
        return $this.calculateTimestamp(mavenProject2, (Continuation<? super MavenProjectTimestamp>)$completion);
    }

    public static final /* synthetic */ long access$getFileTimestamp(MavenProjectsTreeUpdater $this, VirtualFile file) {
        return $this.getFileTimestamp(file);
    }

    public static final /* synthetic */ MavenProjectsTree access$getTree$p(MavenProjectsTreeUpdater $this) {
        return $this.tree;
    }

    public static final /* synthetic */ long access$getFileTimestamp(MavenProjectsTreeUpdater $this, File file) {
        return $this.getFileTimestamp(file);
    }

    public static final /* synthetic */ File access$getUserSettingsFile$p(MavenProjectsTreeUpdater $this) {
        return $this.userSettingsFile;
    }

    public static final /* synthetic */ File access$getGlobalSettingsFile$p(MavenProjectsTreeUpdater $this) {
        return $this.globalSettingsFile;
    }

    public static final /* synthetic */ MavenExplicitProfiles access$getExplicitProfiles$p(MavenProjectsTreeUpdater $this) {
        return $this.explicitProfiles;
    }

    public static final /* synthetic */ Object access$update(MavenProjectsTreeUpdater $this, VirtualFile mavenProjectFile, boolean forceRead, Continuation $completion) {
        return $this.update(mavenProjectFile, forceRead, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsTreeUpdater$UpdateSpec;", "Ljava/lang/Record;", "mavenProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "forceRead", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "()Z", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.maven"})
    @ApiStatus.Internal
    public static final class UpdateSpec
    extends Record {
        @NotNull
        private final VirtualFile mavenProjectFile;
        private final boolean forceRead;

        public UpdateSpec(@NotNull VirtualFile mavenProjectFile, boolean forceRead) {
            Intrinsics.checkNotNullParameter((Object)mavenProjectFile, (String)"mavenProjectFile");
            this.mavenProjectFile = mavenProjectFile;
            this.forceRead = forceRead;
        }

        @NotNull
        public final VirtualFile mavenProjectFile() {
            return this.mavenProjectFile;
        }

        public final boolean forceRead() {
            return this.forceRead;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.mavenProjectFile;
        }

        public final boolean component2() {
            return this.forceRead;
        }

        @NotNull
        public final UpdateSpec copy(@NotNull VirtualFile mavenProjectFile, boolean forceRead) {
            Intrinsics.checkNotNullParameter((Object)mavenProjectFile, (String)"mavenProjectFile");
            return new UpdateSpec(mavenProjectFile, forceRead);
        }

        public static /* synthetic */ UpdateSpec copy$default(UpdateSpec updateSpec, VirtualFile virtualFile, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = updateSpec.mavenProjectFile;
            }
            if ((n & 2) != 0) {
                bl = updateSpec.forceRead;
            }
            return updateSpec.copy(virtualFile, bl);
        }

        @Override
        @NotNull
        public String toString() {
            return "UpdateSpec(mavenProjectFile=" + this.mavenProjectFile + ", forceRead=" + this.forceRead + ")";
        }

        @Override
        public int hashCode() {
            int result2 = this.mavenProjectFile.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.forceRead);
            return result2;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UpdateSpec)) {
                return false;
            }
            UpdateSpec updateSpec = (UpdateSpec)other;
            if (!Intrinsics.areEqual((Object)this.mavenProjectFile, (Object)updateSpec.mavenProjectFile)) {
                return false;
            }
            return this.forceRead == updateSpec.forceRead;
        }
    }
}

