/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenArgumentsCompletionProvider;
import org.jetbrains.idea.maven.execution.MavenPomFileChooserDescriptor;
import org.jetbrains.idea.maven.execution.MavenSelectProjectPopup;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.tasks.TasksBundle;

public class MavenEditGoalDialog
extends DialogWrapper {
    private final Project myProject;
    @Nullable
    private final Collection<String> myHistory;
    private JPanel contentPane;
    private FixedSizeButton showProjectTreeButton;
    private TextFieldWithBrowseButton workDirectoryField;
    private JPanel goalsPanel;
    private JLabel goalsLabel;
    private ComboBox goalsComboBox;
    private EditorTextField goalsEditor;

    public MavenEditGoalDialog(@NotNull Project project2) {
        if (project2 == null) {
            MavenEditGoalDialog.$$$reportNull$$$0(0);
        }
        this(project2, null);
    }

    public MavenEditGoalDialog(@NotNull Project project2, @Nullable Collection<String> history) {
        if (project2 == null) {
            MavenEditGoalDialog.$$$reportNull$$$0(1);
        }
        super(project2, true);
        this.myProject = project2;
        this.myHistory = history;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(TasksBundle.message("maven.tasks.goal.edit", objectArray));
        this.setUpDialog();
        this.setModal(true);
        this.init();
    }

    private void setUpDialog() {
        ComboBox goalComponent;
        if (this.myHistory == null) {
            this.goalsEditor = new EditorTextField("", this.myProject, (FileType)PlainTextFileType.INSTANCE);
            goalComponent = this.goalsEditor;
            this.goalsLabel.setLabelFor((Component)this.goalsEditor);
        } else {
            goalComponent = this.goalsComboBox = new ComboBox((Object[])ArrayUtilRt.toStringArray(this.myHistory));
            this.goalsLabel.setLabelFor((Component)this.goalsComboBox);
            this.goalsComboBox.setLightWeightPopupEnabled(false);
            StringComboboxEditor editor = new StringComboboxEditor(this.myProject, (FileType)PlainTextFileType.INSTANCE, this.goalsComboBox);
            this.goalsComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)editor));
            this.goalsComboBox.setEditable(true);
            this.goalsComboBox.setEditor((ComboBoxEditor)editor);
            this.goalsComboBox.setFocusable(true);
            this.goalsEditor = editor.getEditorComponent();
        }
        this.goalsPanel.add((Component)goalComponent);
        new MavenArgumentsCompletionProvider(this.myProject).apply(this.goalsEditor);
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        this.showProjectTreeButton.setIcon(AllIcons.Nodes.Module);
        MavenSelectProjectPopup.attachToWorkingDirectoryField(projectsManager, this.workDirectoryField.getTextField(), (JButton)this.showProjectTreeButton, (JComponent)(this.goalsComboBox != null ? this.goalsComboBox : this.goalsEditor));
        this.workDirectoryField.addBrowseFolderListener(RunnerBundle.message("maven.select.working.directory", new Object[0]), "", this.myProject, (FileChooserDescriptor)new MavenPomFileChooserDescriptor(this.myProject));
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.workDirectoryField.getText().trim().isEmpty()) {
            return new ValidationInfo(TasksBundle.message("maven.tasks.edit.working.dir.is.empty", new Object[0]), (JComponent)this.workDirectoryField);
        }
        return null;
    }

    @NotNull
    public String getGoals() {
        if (this.goalsComboBox != null) {
            String string = (String)this.goalsComboBox.getEditor().getItem();
            if (string == null) {
                MavenEditGoalDialog.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.goalsEditor.getText();
        if (string == null) {
            MavenEditGoalDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setGoals(@NotNull @NlsSafe String goals) {
        if (goals == null) {
            MavenEditGoalDialog.$$$reportNull$$$0(4);
        }
        if (this.goalsComboBox != null) {
            this.goalsComboBox.setSelectedItem((Object)goals);
        }
        this.goalsEditor.setText(goals);
    }

    @NotNull
    public String getWorkDirectory() {
        String string = this.workDirectoryField.getText();
        if (string == null) {
            MavenEditGoalDialog.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setWorkDirectory(@NotNull @NlsSafe String path2) {
        if (path2 == null) {
            MavenEditGoalDialog.$$$reportNull$$$0(6);
        }
        this.workDirectoryField.setText(path2);
    }

    public void setSelectedMavenProject(@Nullable MavenProject mavenProject2) {
        this.workDirectoryField.setText(mavenProject2 == null ? "" : mavenProject2.getDirectory());
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.goalsComboBox;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        FixedSizeButton fixedSizeButton;
        JLabel jLabel;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(10, 10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "North");
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEditGoalDialog.class).getString("maven.settings.working.directory"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.goalsLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEditGoalDialog.class).getString("maven.settings.command.line"));
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.showProjectTreeButton = fixedSizeButton = new FixedSizeButton();
        fixedSizeButton.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEditGoalDialog.class).getString("maven.settings.edit.goal.select.maven.project"));
        jPanel4.add((Component)fixedSizeButton, "East");
        this.workDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, "Center");
        this.goalsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(600, -1), null));
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenEditGoalDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goals";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenEditGoalDialog";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoals";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setGoals";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setWorkDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

