/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenGoalLocation;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/execution/MavenConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "intellij.maven"})
public final class MavenConfigurationProducer
extends LazyRunConfigurationProducer<MavenRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = MavenRunConfigurationType.getInstance().getConfigurationFactories()[0];
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"get(...)");
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull MavenRunConfiguration configuration, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Location location = context2.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        VirtualFile virtualFile = location2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        if (!MavenUtil.isPomFile(location2.getProject(), file)) {
            return false;
        }
        if (!(location2 instanceof MavenGoalLocation)) {
            return false;
        }
        if (context2.getModule() == null) {
            return false;
        }
        List<String> goals = ((MavenGoalLocation)location2).getGoals();
        MavenExplicitProfiles mavenExplicitProfiles = MavenProjectsManager.getInstance(location2.getProject()).getExplicitProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)mavenExplicitProfiles, (String)"getExplicitProfiles(...)");
        MavenExplicitProfiles profiles2 = mavenExplicitProfiles;
        String string = context2.getModule().getName();
        Intrinsics.checkNotNull(goals);
        configuration.setName(string + " " + CollectionsKt.joinToString$default((Iterable)goals, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null));
        configuration.setRunnerParameters(new MavenRunnerParameters(true, file.getParent().getPath(), file.getName(), goals, profiles2.getEnabledProfiles(), profiles2.getDisabledProfiles()));
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull MavenRunConfiguration configuration, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Location location = context2.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        VirtualFile virtualFile = location2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        if (!MavenUtil.isPomFile(location2.getProject(), file)) {
            return false;
        }
        if (!(location2 instanceof MavenGoalLocation)) {
            return false;
        }
        if (context2.getModule() == null) {
            return false;
        }
        MavenRunnerParameters mavenRunnerParameters = configuration.getRunnerParameters();
        if (!Intrinsics.areEqual((Object)(mavenRunnerParameters != null ? mavenRunnerParameters.getWorkingDirPath() : null), (Object)file.getParent().getPath())) {
            return false;
        }
        MavenRunnerParameters mavenRunnerParameters2 = configuration.getRunnerParameters();
        if (!Intrinsics.areEqual((Object)(mavenRunnerParameters2 != null ? mavenRunnerParameters2.getPomFileName() : null), (Object)file.getName())) {
            return false;
        }
        List<String> list = ((MavenGoalLocation)location2).getGoals();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGoals(...)");
        List<String> newTaskNames = list;
        List<String> list2 = configuration.getRunnerParameters().getGoals();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getGoals(...)");
        List<String> existingTaskNames = list2;
        if (newTaskNames.isEmpty() && existingTaskNames.isEmpty()) {
            return true;
        }
        return Intrinsics.areEqual(new HashSet(newTaskNames), new HashSet(existingTaskNames));
    }
}

