/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings.extract;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.util.Function;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusions;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.refactorings.extract.SelectMavenProjectDialog;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;

public class ExtractManagedDependenciesAction
extends BaseRefactoringAction {
    public ExtractManagedDependenciesAction() {
        this.setInjectedContext(true);
    }

    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(1);
        }
        return new MyRefactoringActionHandler();
    }

    protected boolean isAvailableForFile(PsiFile file) {
        return MavenDomUtil.isMavenFile(file);
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context2) {
        if (element == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(5);
        }
        if (!super.isAvailableOnElementInEditorAndFile(element, editor, file, context2)) {
            return false;
        }
        return ExtractManagedDependenciesAction.findDependencyAndParent(file, editor) != null;
    }

    private static Pair<MavenDomDependency, Set<MavenDomProjectModel>> findDependencyAndParent(PsiFile file, Editor editor) {
        MavenDomDependency dependency = (MavenDomDependency)DomUtil.findDomElement((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), MavenDomDependency.class);
        if (dependency == null || ExtractManagedDependenciesAction.isManagedDependency(dependency)) {
            return null;
        }
        Set<MavenDomProjectModel> parents = ExtractManagedDependenciesAction.getParentProjects(file);
        if (parents.isEmpty()) {
            return null;
        }
        return Pair.create((Object)dependency, parents);
    }

    @NotNull
    private static Set<MavenDomProjectModel> getParentProjects(@NotNull PsiFile file) {
        MavenDomProjectModel model;
        if (file == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(6);
        }
        if ((model = MavenDomUtil.getMavenDomModel(file, MavenDomProjectModel.class)) == null) {
            Set<MavenDomProjectModel> set2 = Collections.emptySet();
            if (set2 == null) {
                ExtractManagedDependenciesAction.$$$reportNull$$$0(7);
            }
            return set2;
        }
        Set<MavenDomProjectModel> set3 = MavenDomProjectProcessorUtils.collectParentProjects(model);
        if (set3 == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(8);
        }
        return set3;
    }

    private static boolean isManagedDependency(@NotNull MavenDomDependency dependency) {
        if (dependency == null) {
            ExtractManagedDependenciesAction.$$$reportNull$$$0(9);
        }
        return MavenDomProjectProcessorUtils.searchManagingDependency(dependency) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/refactorings/extract/ExtractManagedDependenciesAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/extract/ExtractManagedDependenciesAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElements";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentProjects";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isManagedDependency";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class MyRefactoringActionHandler
    implements RefactoringActionHandler {
        private MyRefactoringActionHandler() {
        }

        public void invoke(@NotNull Project project2, Editor editor, PsiFile file, DataContext dataContext) {
            if (project2 == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(0);
            }
            MavenActionsUsagesCollector.trigger(project2, MavenActionsUsagesCollector.EXTRACT_MANAGED_DEPENDENCIES);
            Pair<MavenDomDependency, Set<MavenDomProjectModel>> depAndParents = ExtractManagedDependenciesAction.findDependencyAndParent(file, editor);
            if (depAndParents == null) {
                return;
            }
            Set parent = (Set)depAndParents.second;
            MavenDomDependency dependency = (MavenDomDependency)depAndParents.first;
            Function<MavenDomProjectModel, Set<MavenDomDependency>> funOccurrences = MyRefactoringActionHandler.getOccurencesFunction(dependency);
            ProcessData processData = MyRefactoringActionHandler.getProcessData(project2, parent, funOccurrences, dependency.getExclusions().getXmlElement() != null);
            if (processData == null) {
                return;
            }
            MavenDomProjectModel model = processData.getModel();
            Set<MavenDomDependency> usages = processData.getUsages();
            boolean extractExclusions = processData.isExtractExclusions();
            assert (model != null);
            assert (usages != null);
            WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])MyRefactoringActionHandler.getFiles(file, model, usages)).run(() -> {
                String systemPath;
                String classifier;
                MavenDomDependency addedDependency = model.getDependencyManagement().getDependencies().addDependency();
                addedDependency.getGroupId().setStringValue(dependency.getGroupId().getStringValue());
                addedDependency.getArtifactId().setStringValue(dependency.getArtifactId().getStringValue());
                addedDependency.getVersion().setStringValue(dependency.getVersion().getStringValue());
                String typeValue = dependency.getType().getStringValue();
                dependency.getVersion().undefine();
                if (typeValue != null) {
                    addedDependency.getType().setStringValue(typeValue);
                }
                if ((classifier = dependency.getClassifier().getStringValue()) != null) {
                    addedDependency.getClassifier().setStringValue(classifier);
                }
                if ((systemPath = dependency.getSystemPath().getStringValue()) != null) {
                    addedDependency.getSystemPath().setStringValue(systemPath);
                    dependency.getSystemPath().undefine();
                }
                if (extractExclusions) {
                    MavenDomExclusions addedExclusions = addedDependency.getExclusions();
                    for (MavenDomExclusion exclusion : dependency.getExclusions().getExclusions()) {
                        MavenDomExclusion domExclusion = addedExclusions.addExclusion();
                        domExclusion.getGroupId().setStringValue(exclusion.getGroupId().getStringValue());
                        domExclusion.getArtifactId().setStringValue(exclusion.getArtifactId().getStringValue());
                    }
                    dependency.getExclusions().undefine();
                }
                for (MavenDomDependency usage : usages) {
                    usage.getVersion().undefine();
                }
            });
        }

        private static PsiFile[] getFiles(@NotNull PsiFile file, @NotNull MavenDomProjectModel model, @NotNull Set<? extends MavenDomDependency> usages) {
            if (file == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(1);
            }
            if (model == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(2);
            }
            if (usages == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(3);
            }
            HashSet<PsiFile> files2 = new HashSet<PsiFile>();
            files2.add(file);
            XmlElement xmlElement = model.getXmlElement();
            if (xmlElement != null) {
                files2.add(xmlElement.getContainingFile());
            }
            for (MavenDomDependency mavenDomDependency : usages) {
                XmlElement element = mavenDomDependency.getXmlElement();
                if (element == null) continue;
                files2.add(element.getContainingFile());
            }
            return PsiUtilCore.toPsiFileArray(files2);
        }

        @Nullable
        private static ProcessData getProcessData(@NotNull Project project2, @NotNull Set<MavenDomProjectModel> models, @NotNull Function<MavenDomProjectModel, Set<MavenDomDependency>> funOccurrences, boolean hasExclusions) {
            MavenDomProjectModel model;
            if (project2 == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(4);
            }
            if (models == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(5);
            }
            if (funOccurrences == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(6);
            }
            if (models.size() == 0) {
                return null;
            }
            if (models.size() == 1 && !hasExclusions && ((Set)funOccurrences.fun((Object)(model = models.iterator().next()))).size() == 0) {
                return new ProcessData(model, Collections.emptySet(), false);
            }
            SelectMavenProjectDialog dialog = new SelectMavenProjectDialog(project2, models, funOccurrences, hasExclusions);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                MavenDomProjectModel model2 = dialog.getSelectedProject();
                return new ProcessData(model2, dialog.isReplaceAllOccurrences() ? (Set)funOccurrences.fun((Object)model2) : Collections.emptySet(), dialog.isExtractExclusions());
            }
            return null;
        }

        private static Function<MavenDomProjectModel, Set<MavenDomDependency>> getOccurencesFunction(MavenDomDependency dependency) {
            return model -> {
                DependencyConflictId dependencyId = DependencyConflictId.create(dependency);
                if (dependencyId == null) {
                    return Collections.emptySet();
                }
                return MavenDomProjectProcessorUtils.searchDependencyUsages(model, dependencyId, Collections.singleton(dependency));
            };
        }

        public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, DataContext dataContext) {
            if (project2 == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(7);
            }
            if (elements == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(8);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "models";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "funOccurrences";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/extract/ExtractManagedDependenciesAction$MyRefactoringActionHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFiles";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getProcessData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProcessData {
        private final MavenDomProjectModel myModel;
        private final Set<MavenDomDependency> myUsages;
        private final boolean myExtractExclusions;

        public MavenDomProjectModel getModel() {
            return this.myModel;
        }

        public Set<MavenDomDependency> getUsages() {
            return this.myUsages;
        }

        public boolean isExtractExclusions() {
            return this.myExtractExclusions;
        }

        ProcessData(MavenDomProjectModel model, Set<MavenDomDependency> usages, boolean extractExclusions) {
            this.myModel = model;
            this.myUsages = usages;
            this.myExtractExclusions = extractExclusions;
        }
    }
}

