/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDomConvertersRegistry;
import org.jetbrains.idea.maven.dom.converters.MavenPluginCustomParameterValueConverter;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomConfigurationParameter;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.plugin.MavenDomMojo;
import org.jetbrains.idea.maven.dom.plugin.MavenDomParameter;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;

public final class MavenPluginConfigurationDomExtender
extends DomExtender<MavenDomConfiguration> {
    public static final Key<ParameterData> PLUGIN_PARAMETER_KEY = Key.create((String)"MavenPluginConfigurationDomExtender.PLUGIN_PARAMETER_KEY");
    private static final Set<String> COLLECTIONS_TYPE_NAMES = Set.of("java.util.Collection", "java.util.Set", "java.util.List", "java.util.ArrayList", "java.util.HashSet", "java.util.LinkedList");

    public void registerExtensions(@NotNull MavenDomConfiguration config, @NotNull DomExtensionsRegistrar r) {
        MavenDomPluginModel pluginModel;
        if (config == null) {
            MavenPluginConfigurationDomExtender.$$$reportNull$$$0(0);
        }
        if (r == null) {
            MavenPluginConfigurationDomExtender.$$$reportNull$$$0(1);
        }
        if ((pluginModel = MavenPluginDomUtil.getMavenPluginModel(config)) == null) {
            r.registerCustomChildrenExtension(MavenDomConfigurationParameter.class);
            return;
        }
        boolean isInPluginManagement = MavenPluginConfigurationDomExtender.isInPluginManagement(config);
        for (ParameterData each : MavenPluginConfigurationDomExtender.collectParameters(pluginModel, config)) {
            MavenPluginConfigurationDomExtender.registerPluginParameter(isInPluginManagement, r, each);
        }
    }

    private static boolean isInPluginManagement(MavenDomConfiguration pluginNode) {
        XmlElement xmlElement = pluginNode.getXmlElement();
        if (xmlElement == null) {
            return false;
        }
        PsiElement pluginTag = xmlElement.getParent();
        if (pluginTag == null) {
            return false;
        }
        PsiElement pluginsTag = pluginTag.getParent();
        if (pluginsTag == null) {
            return false;
        }
        PsiElement pluginManagementTag = pluginsTag.getParent();
        return pluginManagementTag instanceof XmlTag && "pluginManagement".equals(((XmlTag)pluginManagementTag).getName());
    }

    private static Collection<ParameterData> collectParameters(MavenDomPluginModel pluginModel, MavenDomConfiguration config) {
        ArrayList<Object> selectedGoals = null;
        MavenDomPluginExecution executionElement = (MavenDomPluginExecution)config.getParentOfType(MavenDomPluginExecution.class, false);
        if (executionElement != null) {
            Object goal;
            selectedGoals = new ArrayList<Object>();
            String id = executionElement.getId().getStringValue();
            String defaultPrefix = "default-";
            if (id != null && id.startsWith(defaultPrefix) && !StringUtil.isEmptyOrSpaces((String)(goal = id.substring(defaultPrefix.length())))) {
                selectedGoals.add(goal);
            }
            for (GenericDomValue genericDomValue : executionElement.getGoals().getGoals()) {
                selectedGoals.add(genericDomValue.getStringValue());
            }
        }
        HashMap<String, ParameterData> namesWithParameters = new HashMap<String, ParameterData>();
        for (MavenDomMojo eachMojo : pluginModel.getMojos().getMojos()) {
            String string = eachMojo.getGoal().getStringValue();
            if (string == null || selectedGoals != null && !selectedGoals.contains(string)) continue;
            for (MavenDomParameter eachParameter : eachMojo.getParameters().getParameters()) {
                String name = eachParameter.getName().getStringValue();
                if (name == null) continue;
                ParameterData data2 = new ParameterData(eachParameter);
                MavenPluginConfigurationDomExtender.fillParameterData(name, data2, eachMojo);
                ParameterData oldParameter = (ParameterData)namesWithParameters.get(name);
                if (oldParameter != null && !MavenPluginConfigurationDomExtender.hasMorePriority(data2, oldParameter, executionElement != null)) continue;
                namesWithParameters.put(name, data2);
            }
        }
        return namesWithParameters.values();
    }

    private static boolean hasMorePriority(ParameterData d1, ParameterData d2, boolean isForExecutionSection) {
        if (!isForExecutionSection) {
            if (StringUtil.isEmptyOrSpaces((String)d1.getMojo().getPhase().getStringValue())) {
                return false;
            }
            if (StringUtil.isEmptyOrSpaces((String)d2.getMojo().getPhase().getStringValue())) {
                return true;
            }
        }
        return d1.getRequiringLevel() > d2.getRequiringLevel();
    }

    private static void fillParameterData(String name, ParameterData data2, MavenDomMojo mojo2) {
        XmlTag config = mojo2.getConfiguration().getXmlTag();
        if (config == null) {
            return;
        }
        for (XmlTag each : config.getSubTags()) {
            if (!name.equals(each.getName())) continue;
            data2.defaultValue = each.getAttributeValue("default-value");
            data2.expression = each.getValue().getTrimmedText();
        }
    }

    private static void registerPluginParameter(boolean isInPluginManagement, DomExtensionsRegistrar r, ParameterData parameter) {
        String paramName = parameter.parameter.getName().getStringValue();
        String alias = parameter.parameter.getAlias().getStringValue();
        MavenPluginConfigurationDomExtender.registerPluginParameter(isInPluginManagement, r, parameter, paramName);
        if (alias != null) {
            MavenPluginConfigurationDomExtender.registerPluginParameter(isInPluginManagement, r, parameter, alias);
        }
    }

    private static void registerPluginParameter(boolean isInPluginManagement, DomExtensionsRegistrar r, final ParameterData data2, final String parameterName) {
        DomExtension e = r.registerFixedNumberChildExtension(new XmlName(parameterName), MavenDomConfigurationParameter.class);
        if (MavenPluginConfigurationDomExtender.isCollection(data2.parameter)) {
            e.addExtender(new DomExtender(){

                public void registerExtensions(@NotNull DomElement domElement, @NotNull DomExtensionsRegistrar registrar) {
                    if (domElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (registrar == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    for (String each : MavenPluginConfigurationDomExtender.collectPossibleNameForCollectionParameter(parameterName)) {
                        DomExtension inner = registrar.registerCollectionChildrenExtension(new XmlName(each), MavenDomConfigurationParameter.class);
                        inner.setDeclaringElement((DomElement)data2.parameter);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "domElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "registrar";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender$1";
                    objectArray[2] = "registerExtensions";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else {
            MavenPluginConfigurationDomExtender.addValueConverter(e, data2.parameter);
            if (!isInPluginManagement) {
                MavenPluginConfigurationDomExtender.addRequiredAnnotation(e, data2);
            }
        }
        e.setDeclaringElement((DomElement)data2.parameter);
        data2.parameter.getXmlElement().putUserData(PLUGIN_PARAMETER_KEY, (Object)data2);
    }

    private static void addValueConverter(DomExtension e, MavenDomParameter parameter) {
        String type2 = parameter.getType().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)type2)) {
            e.setConverter((Converter)new MavenPluginCustomParameterValueConverter(type2), MavenDomConvertersRegistry.getInstance().isSoft(type2));
        }
    }

    private static void addRequiredAnnotation(DomExtension e, ParameterData data2) {
        if (Boolean.parseBoolean(data2.parameter.getRequired().getStringValue()) && StringUtil.isEmptyOrSpaces((String)data2.defaultValue) && StringUtil.isEmptyOrSpaces((String)data2.expression)) {
            e.addCustomAnnotation((Annotation)new Required(){

                public boolean value() {
                    return true;
                }

                public boolean nonEmpty() {
                    return false;
                }

                public boolean identifier() {
                    return false;
                }

                public Class<? extends Annotation> annotationType() {
                    return Required.class;
                }
            });
        }
    }

    public static List<String> collectPossibleNameForCollectionParameter(String parameterName) {
        String singularName = StringUtil.unpluralize((String)parameterName);
        if (singularName == null) {
            singularName = parameterName;
        }
        ArrayList<String> result2 = new ArrayList<String>();
        String[] parts = NameUtil.splitNameIntoWords((String)singularName);
        for (int i2 = 0; i2 < parts.length; ++i2) {
            result2.add(StringUtil.decapitalize((String)StringUtil.join((String[])parts, (int)i2, (int)parts.length, (String)"")));
        }
        return result2;
    }

    private static boolean isCollection(MavenDomParameter parameter) {
        String type2 = parameter.getType().getStringValue();
        if (type2 == null) {
            return false;
        }
        return type2.endsWith("[]") || COLLECTIONS_TYPE_NAMES.contains(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "config";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "r";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender";
        objectArray[2] = "registerExtensions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ParameterData {
        public final MavenDomParameter parameter;
        @Nullable
        @NlsSafe
        public String defaultValue;
        @Nullable
        @NlsSafe
        public String expression;

        private ParameterData(MavenDomParameter parameter) {
            this.parameter = parameter;
        }

        @NotNull
        public MavenDomMojo getMojo() {
            MavenDomMojo mavenDomMojo = (MavenDomMojo)this.parameter.getParent().getParent();
            if (mavenDomMojo == null) {
                ParameterData.$$$reportNull$$$0(0);
            }
            return mavenDomMojo;
        }

        public int getRequiringLevel() {
            if (!Boolean.parseBoolean(this.parameter.getRequired().getStringValue())) {
                return 0;
            }
            if (!StringUtil.isEmptyOrSpaces((String)this.defaultValue) || !StringUtil.isEmptyOrSpaces((String)this.expression)) {
                return 1;
            }
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/MavenPluginConfigurationDomExtender$ParameterData", "getMojo"));
        }
    }
}

