/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenEventHandler;
import org.jetbrains.idea.maven.server.MavenArtifactEvent;
import org.jetbrains.idea.maven.server.MavenServerConsoleEvent;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenLogEventHandler;", "Lorg/jetbrains/idea/maven/buildtool/MavenEventHandler;", "()V", "handleConsoleEvents", "", "consoleEvents", "", "Lorg/jetbrains/idea/maven/server/MavenServerConsoleEvent;", "handleDownloadEvents", "downloadEvents", "Lorg/jetbrains/idea/maven/server/MavenArtifactEvent;", "intellij.maven"})
public final class MavenLogEventHandler
implements MavenEventHandler {
    @NotNull
    public static final MavenLogEventHandler INSTANCE = new MavenLogEventHandler();

    private MavenLogEventHandler() {
    }

    @Override
    public void handleConsoleEvents(@NotNull List<? extends MavenServerConsoleEvent> consoleEvents) {
        Intrinsics.checkNotNullParameter(consoleEvents, (String)"consoleEvents");
        for (MavenServerConsoleEvent mavenServerConsoleEvent : consoleEvents) {
            Throwable throwable;
            String message = mavenServerConsoleEvent.getMessage();
            switch (mavenServerConsoleEvent.getLevel()) {
                case 0: {
                    MavenLog.LOG.debug(message);
                    break;
                }
                case 1: {
                    MavenLog.LOG.info(message);
                    break;
                }
                default: {
                    MavenLog.LOG.warn(message);
                }
            }
            if ((throwable = mavenServerConsoleEvent.getThrowable()) == null) continue;
            MavenLog.LOG.warn(throwable);
        }
    }

    @Override
    public void handleDownloadEvents(@NotNull List<? extends MavenArtifactEvent> downloadEvents) {
        Intrinsics.checkNotNullParameter(downloadEvents, (String)"downloadEvents");
        for (MavenArtifactEvent mavenArtifactEvent : downloadEvents) {
            String id = mavenArtifactEvent.getDependencyId();
            switch (WhenMappings.$EnumSwitchMapping$0[mavenArtifactEvent.getArtifactEventType().ordinal()]) {
                case 1: {
                    MavenLog.LOG.debug("Download started: " + id);
                    break;
                }
                case 2: {
                    MavenLog.LOG.debug("Download completed: " + id);
                    break;
                }
                case 3: {
                    MavenLog.LOG.debug("Download failed: " + id + " \n" + mavenArtifactEvent.getErrorMessage() + " \n" + mavenArtifactEvent.getStackTrace());
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MavenArtifactEvent.ArtifactEventType.values().length];
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_COMPLETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

