/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.lang.java6.ClassLoadingLocks;
import com.intellij.util.lang.java6.ClassPath;
import com.intellij.util.lang.java6.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlClassLoader
extends ClassLoader {
    static final String CLASS_EXTENSION = ".class";
    private static final ThreadLocal<Boolean> ourSkipFindingResource;
    private static final boolean ourClassPathIndexEnabled;
    private static final Set<Class<?>> ourParallelCapableLoaders;
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final ClassLoadingLocks myClassLoadingLocks;
    private final boolean myAllowBootstrapResources;

    private static boolean isUrlNeedsProtectionDomain(@NotNull URL url) {
        String name;
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(0);
        }
        return (name = PathUtilRt.getFileName((String)url.getPath())).endsWith(".jar") && (name.startsWith("bcprov-") || name.startsWith("bcpkix-"));
    }

    void appendToClassPathForInstrumentation(@NotNull String jar) {
        if (jar == null) {
            UrlClassLoader.$$$reportNull$$$0(1);
        }
        try {
            URL url = new File(jar).toURI().toURL();
            this.getClassPath().addURL(url);
            this.myURLs.add(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @NotNull
    private ClassPath getClassPath() {
        ClassPath classPath = this.myClassPath;
        if (classPath == null) {
            UrlClassLoader.$$$reportNull$$$0(2);
        }
        return classPath;
    }

    @NotNull
    public long[] getLoadingStats() {
        long[] lArray = new long[]{ClassPath.getTotalTime(), ClassPath.getTotalRequests()};
        if (lArray == null) {
            UrlClassLoader.$$$reportNull$$$0(3);
        }
        return lArray;
    }

    @NotNull
    public static UrlClassLoader create(List<URL> urls) {
        UrlClassLoader urlClassLoader = UrlClassLoader.build().urls(urls).useCache().allowLock().get();
        if (urlClassLoader == null) {
            UrlClassLoader.$$$reportNull$$$0(4);
        }
        return urlClassLoader;
    }

    @NotNull
    public static Builder build() {
        return new Builder();
    }

    @Deprecated
    public UrlClassLoader(@NotNull ClassLoader parent) {
        if (parent == null) {
            UrlClassLoader.$$$reportNull$$$0(5);
        }
        this(UrlClassLoader.build().urlsFromAppClassLoader(parent).parent(parent.getParent()).allowLock().useCache().usePersistentClasspathIndexForLocalClassDirectories().allowBootstrapResources(Boolean.parseBoolean(System.getProperty("idea.allow.bootstrap.resources", "true"))).useLazyClassloadingCaches(Boolean.parseBoolean(System.getProperty("idea.lazy.classloading.caches", "false"))).autoAssignUrlsWithProtectionDomain());
        try {
            Field f = ClassLoader.class.getDeclaredField("classLoaderValueMap");
            f.setAccessible(true);
            f.set(this, f.get(parent));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private UrlClassLoader(@NotNull Builder builder) {
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(6);
        }
        super(builder.myParent);
        this.myURLs = builder.myURLs;
        this.myClassPath = this.createClassPath(builder);
        this.myAllowBootstrapResources = builder.myAllowBootstrapResources;
        this.myClassLoadingLocks = ourParallelCapableLoaders != null && ourParallelCapableLoaders.contains(this.getClass()) ? new ClassLoadingLocks() : null;
    }

    @NotNull
    private ClassPath createClassPath(@NotNull Builder builder) {
        Set<URL> urlsWithProtectionDomain;
        if (builder == null) {
            UrlClassLoader.$$$reportNull$$$0(7);
        }
        if ((urlsWithProtectionDomain = builder.myURLsWithProtectionDomain) == null) {
            urlsWithProtectionDomain = Collections.emptySet();
        }
        return new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myUsePersistentClasspathIndex, true, builder.myLazyClassloadingCaches, urlsWithProtectionDomain);
    }

    @Deprecated
    public void addURL(@NotNull URL url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(8);
        }
        this.getClassPath().addURL(url);
        this.myURLs.add(url);
    }

    @Override
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        Class<?> clazz;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(9);
        }
        if ((clazz = this._findClass(name)) == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Nullable
    private Class<?> _findClass(@NotNull String name) {
        Resource resource;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(10);
        }
        if ((resource = this.getClassPath().getResource(name.replace('.', '/') + CLASS_EXTENSION)) == null) {
            return null;
        }
        try {
            return this.defineClass(name, resource);
        }
        catch (IOException e) {
            LoggerRt.getInstance(UrlClassLoader.class).error((Throwable)e);
            return null;
        }
    }

    private Class<?> defineClass(@NotNull String name, @NotNull Resource res) throws IOException {
        String pkgName;
        Package pkg;
        int i;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(11);
        }
        if (res == null) {
            UrlClassLoader.$$$reportNull$$$0(12);
        }
        if ((i = name.lastIndexOf(46)) != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, res.getValue(Resource.Attribute.SPEC_TITLE), res.getValue(Resource.Attribute.SPEC_VERSION), res.getValue(Resource.Attribute.SPEC_VENDOR), res.getValue(Resource.Attribute.IMPL_TITLE), res.getValue(Resource.Attribute.IMPL_VERSION), res.getValue(Resource.Attribute.IMPL_VENDOR), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res.getBytes();
        ProtectionDomain protectionDomain = res.getProtectionDomain();
        if (protectionDomain != null) {
            return this._defineClass(name, b, protectionDomain);
        }
        return this._defineClass(name, b);
    }

    private Class<?> _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    private Class<?> _defineClass(String name, byte[] b, @Nullable ProtectionDomain protectionDomain) {
        return this.defineClass(name, b, 0, b.length, protectionDomain);
    }

    @Override
    public URL findResource(String name) {
        if (ourSkipFindingResource.get() != null) {
            return null;
        }
        Resource res = this.findResourceImpl(name);
        return res == null ? null : res.getURL();
    }

    @Nullable
    private Resource findResourceImpl(String name) {
        String n = FileUtilRt.toCanonicalPath((String)name, (char)'/', (boolean)false);
        Resource resource = this.getClassPath().getResource(n);
        if (resource == null && n.startsWith("/")) {
            resource = this.getClassPath().getResource(n.substring(1));
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        if (this.myAllowBootstrapResources) {
            ourSkipFindingResource.set(Boolean.TRUE);
            try {
                InputStream stream = super.getResourceAsStream(name);
                if (stream != null) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
            }
            finally {
                ourSkipFindingResource.set(null);
            }
        }
        try {
            Resource res = this.findResourceImpl(name);
            return res == null ? null : res.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        return this.getClassPath().getResources(name);
    }

    @Override
    @NotNull
    protected Object getClassLoadingLock(String className) {
        Object object = this.myClassLoadingLocks == null ? this : this.myClassLoadingLocks.getOrCreateLock(className);
        if (object == null) {
            UrlClassLoader.$$$reportNull$$$0(13);
        }
        return object;
    }

    static /* synthetic */ boolean access$000() {
        return ourClassPathIndexEnabled;
    }

    static {
        boolean capable;
        ourSkipFindingResource = new ThreadLocal();
        ourClassPathIndexEnabled = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "false"));
        boolean ibmJvm = System.getProperty("java.vm.vendor", "unknown").toLowerCase(Locale.ENGLISH).contains("ibm");
        boolean bl = capable = !ibmJvm;
        if (capable) {
            ourParallelCapableLoaders = Collections.synchronizedSet(new HashSet());
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                if (Boolean.TRUE.equals(registerAsParallelCapable.invoke(null, new Object[0]))) {
                    ourParallelCapableLoaders.add(UrlClassLoader.class);
                }
            }
            catch (Exception exception) {}
        } else {
            ourParallelCapableLoaders = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/java6/UrlClassLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/java6/UrlClassLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingStats";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoadingLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUrlNeedsProtectionDomain";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendToClassPathForInstrumentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createClassPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "_findClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "defineClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        private List<URL> myURLs = Collections.emptyList();
        private Set<URL> myURLsWithProtectionDomain;
        private ClassLoader myParent;
        private boolean myLockJars;
        private boolean myUseCache;
        private boolean myUsePersistentClasspathIndex = UrlClassLoader.access$000();
        private boolean myAllowBootstrapResources;
        private boolean myLazyClassloadingCaches;

        Builder() {
        }

        @NotNull
        public Builder urls(@NotNull List<URL> urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myURLs = urls;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder urls(URL ... urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myURLs = Arrays.asList(urls);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        private Builder urlsFromAppClassLoader(ClassLoader classLoader) {
            if (classLoader instanceof URLClassLoader) {
                return this.urls(((URLClassLoader)classLoader).getURLs());
            }
            String[] parts = System.getProperty("java.class.path").split(File.pathSeparator);
            this.myURLs = new ArrayList<URL>(parts.length);
            for (String s : parts) {
                try {
                    this.myURLs.add(new File(s).toURI().toURL());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this;
        }

        @NotNull
        public Builder parent(ClassLoader parent) {
            this.myParent = parent;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder allowLock() {
            this.myLockJars = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder useCache() {
            this.myUseCache = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder usePersistentClasspathIndexForLocalClassDirectories() {
            this.myUsePersistentClasspathIndex = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder allowBootstrapResources(boolean allowBootstrapResources) {
            this.myAllowBootstrapResources = allowBootstrapResources;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder useLazyClassloadingCaches(boolean pleaseBeLazy) {
            this.myLazyClassloadingCaches = pleaseBeLazy;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder autoAssignUrlsWithProtectionDomain() {
            HashSet<URL> result = new HashSet<URL>();
            for (URL url : this.myURLs) {
                if (!UrlClassLoader.isUrlNeedsProtectionDomain(url)) continue;
                result.add(url);
            }
            this.myURLsWithProtectionDomain = result;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public UrlClassLoader get() {
            return new UrlClassLoader(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/java6/UrlClassLoader$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/java6/UrlClassLoader$Builder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "urls";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowLock";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useCache";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "usePersistentClasspathIndexForLocalClassDirectories";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowBootstrapResources";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useLazyClassloadingCaches";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "autoAssignUrlsWithProtectionDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

