/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors.string;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.editors.string.StringEditorDialog;
import com.intellij.uiDesigner.propertyInspector.properties.IntroStringProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringEditor
extends PropertyEditor<StringDescriptor> {
    private static final Logger LOG = Logger.getInstance(StringEditor.class);
    @Nullable
    private final IntroStringProperty myProperty;
    private final TextFieldWithBrowseButton myTfWithButton;
    private StringDescriptor myValue;
    private final Project myProject;
    private RadComponent myComponent;
    private boolean myTextFieldModified = false;

    public StringEditor(Project project) {
        this(project, null);
    }

    public StringEditor(Project project, IntroStringProperty property) {
        this.myProject = project;
        this.myProperty = property;
        this.myTfWithButton = new TextFieldWithBrowseButton((ActionListener)new MyActionListener());
        this.myTfWithButton.getTextField().setBorder(null);
        JTextField textField = this.myTfWithButton.getTextField();
        textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringEditor.this.fireValueCommitted(false, false);
            }
        });
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                SwingUtilities.invokeLater(() -> StringEditor.this.preferredSizeChanged());
                StringEditor.this.myTextFieldModified = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/propertyInspector/editors/string/StringEditor$2", "textChanged"));
            }
        });
        MyCancelEditingAction cancelEditingAction = new MyCancelEditingAction();
        cancelEditingAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)this.myTfWithButton);
    }

    public Dimension getPreferredSize() {
        return this.myTfWithButton.getPreferredSize();
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)this.myTfWithButton);
    }

    private void setValue(StringDescriptor descriptor) {
        this.myValue = descriptor;
        JTextField textField = this.myTfWithButton.getTextField();
        if (descriptor != null) {
            String value = descriptor.getValue();
            if (value != null) {
                textField.setEditable(true);
                textField.setText(value);
                textField.selectAll();
                this.myTextFieldModified = false;
            } else {
                textField.setEditable(false);
                textField.setBackground(UIUtil.getTextFieldBackground());
                textField.setText("[" + descriptor.getKey() + " / " + descriptor.getDottedBundleName() + "]");
            }
        } else {
            textField.setEditable(true);
            textField.setText(null);
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent(@NotNull JComponent component) {
        if (component == null) {
            StringEditor.$$$reportNull$$$0(0);
        }
        return ((TextFieldWithBrowseButton)component).getTextField();
    }

    @Override
    public JComponent getComponent(RadComponent component, StringDescriptor value, InplaceContext inplaceContext) {
        this.myComponent = component;
        this.setValue(value);
        this.myTfWithButton.getTextField().setBorder(null);
        if (inplaceContext != null && inplaceContext.isStartedByTyping()) {
            this.myTfWithButton.setText(Character.toString(inplaceContext.getStartChar()));
        }
        return this.myTfWithButton;
    }

    @Override
    public StringDescriptor getValue() {
        if (this.myValue == null || this.myValue.getValue() != null && this.myTextFieldModified) {
            String value = this.myTfWithButton.getText();
            if (this.myValue == null && value.isEmpty()) {
                return null;
            }
            StringDescriptor stringDescriptor = StringDescriptor.create((String)value);
            if (this.myValue != null && this.myValue.isNoI18n()) {
                stringDescriptor.setNoI18n(true);
            }
            return stringDescriptor;
        }
        return this.myValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/propertyInspector/editors/string/StringEditor", "getPreferredFocusedComponent"));
    }

    private final class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiEditor guiEditor = DesignerToolWindowManager.getInstance(StringEditor.this.myProject).getActiveFormEditor();
            LOG.assertTrue(guiEditor != null);
            StringEditorDialog dialog = new StringEditorDialog(StringEditor.this.myTfWithButton.getTextField(), StringEditor.this.getValue(), guiEditor.getStringDescriptorLocale(), guiEditor);
            CommandProcessor.getInstance().executeCommand(StringEditor.this.myProject, () -> {
                if (!guiEditor.ensureEditable()) {
                    return;
                }
                if (!dialog.showAndGet()) {
                    return;
                }
                StringDescriptor descriptor = dialog.getDescriptor();
                if (descriptor == null) {
                    return;
                }
                StringEditor.this.setValue(descriptor);
                StringEditor.this.fireValueCommitted(true, false);
                if (StringEditor.this.myProperty != null) {
                    StringEditor.this.myProperty.refreshValue(StringEditor.this.myComponent);
                }
                guiEditor.refreshAndSave(false);
            }, UIDesignerBundle.message("command.edit.string.property", new Object[0]), null);
        }
    }

    private final class MyCancelEditingAction
    extends AnAction {
        private MyCancelEditingAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCancelEditingAction.$$$reportNull$$$0(0);
            }
            StringEditor.this.fireEditingCancelled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/propertyInspector/editors/string/StringEditor$MyCancelEditingAction", "actionPerformed"));
        }
    }
}

