/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.ide.util.TreeFileChooser;
import com.intellij.ide.util.TreeFileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ResourceFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.ImageFileFilter;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.lw.IconDescriptor;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.properties.IntroIconProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class IconEditor
extends PropertyEditor<IconDescriptor> {
    private final TextFieldWithBrowseButton myTextField = new TextFieldWithBrowseButton();
    private IconDescriptor myValue;
    private RadComponent myComponent;

    public IconEditor() {
        this.myTextField.getTextField().setBorder(null);
        this.myTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String resourceName;
                VirtualFile iconVFile;
                TreeFileChooserFactory factory = TreeFileChooserFactory.getInstance((Project)IconEditor.this.getModule().getProject());
                PsiFile iconFile = null;
                if (IconEditor.this.myValue != null && (iconVFile = ResourceFileUtil.findResourceFileInScope((String)IconEditor.this.myValue.getIconPath(), (Project)IconEditor.this.getModule().getProject(), (GlobalSearchScope)IconEditor.this.getModule().getModuleWithDependenciesAndLibrariesScope(true))) != null) {
                    iconFile = PsiManager.getInstance((Project)IconEditor.this.getModule().getProject()).findFile(iconVFile);
                }
                TreeFileChooser fileChooser = factory.createFileChooser(UIDesignerBundle.message("title.choose.icon.file", new Object[0]), iconFile, null, (TreeFileChooser.PsiFileFilter)new ImageFileFilter(IconEditor.this.getModule()), false, true);
                fileChooser.showDialog();
                PsiFile file = fileChooser.getSelectedFile();
                if (file != null && (resourceName = FormEditingUtil.buildResourceName(file)) != null) {
                    IconDescriptor descriptor = new IconDescriptor(resourceName);
                    IntroIconProperty.loadIconFromFile(file.getVirtualFile(), descriptor);
                    IconEditor.this.myValue = descriptor;
                    IconEditor.this.myTextField.setText(descriptor.getIconPath());
                }
            }
        });
    }

    private Module getModule() {
        return this.myComponent.getModule();
    }

    @Override
    public IconDescriptor getValue() throws Exception {
        if (this.myTextField.getText().isEmpty()) {
            return null;
        }
        IconDescriptor descriptor = new IconDescriptor(this.myTextField.getText());
        IntroIconProperty.ensureIconLoaded(this.getModule(), descriptor);
        return descriptor;
    }

    @Override
    public JComponent getComponent(RadComponent component, IconDescriptor value, InplaceContext inplaceContext) {
        this.myValue = value;
        this.myComponent = component;
        if (this.myValue != null) {
            this.myTextField.setText(this.myValue.getIconPath());
        } else {
            this.myTextField.setText("");
        }
        return this.myTextField;
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI((Component)this.myTextField);
    }
}

