/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class AbstractTextFieldEditor<V>
extends PropertyEditor<V> {
    protected final JTextField myTf = new JTextField();

    protected AbstractTextFieldEditor() {
        this.myTf.addActionListener(new MyActionListener());
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.myTf);
    }

    protected void setValueFromComponent(RadComponent component, V value) {
        this.myTf.setText(value == null ? "" : value.toString());
    }

    @Override
    public JComponent getComponent(RadComponent ignored, V value, InplaceContext inplaceContext) {
        this.setValueFromComponent(ignored, value);
        if (inplaceContext != null) {
            this.myTf.setBorder(UIUtil.getTextFieldBorder());
            if (inplaceContext.isStartedByTyping()) {
                this.myTf.setText(Character.toString(inplaceContext.getStartChar()));
            }
        } else {
            this.myTf.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        }
        return this.myTf;
    }

    protected final class MyActionListener
    implements ActionListener {
        protected MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractTextFieldEditor.this.fireValueCommitted(true, false);
        }
    }
}

