/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.make;

import com.intellij.uiDesigner.compiler.GridBagConverter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.make.FormSourceCodeGenerator;
import com.intellij.uiDesigner.make.LayoutSourceGenerator;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public final class GridBagLayoutSourceGenerator
extends LayoutSourceGenerator {
    private boolean myHaveGbc = false;
    @NonNls
    private static final Int2ObjectMap<String> myFillMap = new Int2ObjectOpenHashMap();
    @NonNls
    private static final Int2ObjectMap<String> myAnchorMap = new Int2ObjectOpenHashMap();

    @Override
    public void generateContainerLayout(LwContainer container, FormSourceCodeGenerator generator, String variable) {
        generator.startMethodCall(variable, "setLayout");
        generator.startConstructor(GridBagLayout.class.getName());
        generator.endConstructor();
        generator.endMethod();
    }

    @Override
    public void generateComponentLayout(LwComponent component, FormSourceCodeGenerator generator, String variable, String parentVariable) {
        GridBagConstraints gbc = component.getCustomLayoutConstraints() instanceof GridBagConstraints ? (GridBagConstraints)component.getCustomLayoutConstraints() : new GridBagConstraints();
        GridBagConverter.constraintsToGridBag((GridConstraints)component.getConstraints(), (GridBagConstraints)gbc);
        this.generateGridBagConstraints(generator, gbc, variable, parentVariable);
    }

    private void generateConversionResult(FormSourceCodeGenerator generator, GridBagConverter.Result result, String variable, String parentVariable) {
        GridBagLayoutSourceGenerator.checkSetSize(generator, variable, "setMinimumSize", result.minimumSize);
        GridBagLayoutSourceGenerator.checkSetSize(generator, variable, "setPreferredSize", result.preferredSize);
        GridBagLayoutSourceGenerator.checkSetSize(generator, variable, "setMaximumSize", result.maximumSize);
        this.generateGridBagConstraints(generator, result.constraints, variable, parentVariable);
    }

    private void generateGridBagConstraints(FormSourceCodeGenerator generator, GridBagConstraints constraints, String variable, String parentVariable) {
        if (!this.myHaveGbc) {
            generator.append("java.awt.GridBagConstraints gbc;\n");
            this.myHaveGbc = true;
        }
        generator.append("gbc = new java.awt.GridBagConstraints();\n");
        GridBagConstraints defaults = new GridBagConstraints();
        if (defaults.gridx != constraints.gridx) {
            GridBagLayoutSourceGenerator.setIntField(generator, "gridx", constraints.gridx);
        }
        if (defaults.gridy != constraints.gridy) {
            GridBagLayoutSourceGenerator.setIntField(generator, "gridy", constraints.gridy);
        }
        if (defaults.gridwidth != constraints.gridwidth) {
            GridBagLayoutSourceGenerator.setIntField(generator, "gridwidth", constraints.gridwidth);
        }
        if (defaults.gridheight != constraints.gridheight) {
            GridBagLayoutSourceGenerator.setIntField(generator, "gridheight", constraints.gridheight);
        }
        if (defaults.weightx != constraints.weightx) {
            GridBagLayoutSourceGenerator.setDoubleField(generator, "weightx", constraints.weightx);
        }
        if (defaults.weighty != constraints.weighty) {
            GridBagLayoutSourceGenerator.setDoubleField(generator, "weighty", constraints.weighty);
        }
        if (defaults.anchor != constraints.anchor) {
            GridBagLayoutSourceGenerator.setIntField(generator, "anchor", constraints.anchor, myAnchorMap);
        }
        if (defaults.fill != constraints.fill) {
            GridBagLayoutSourceGenerator.setIntField(generator, "fill", constraints.fill, myFillMap);
        }
        if (defaults.ipadx != constraints.ipadx) {
            GridBagLayoutSourceGenerator.setIntField(generator, "ipadx", constraints.ipadx);
        }
        if (defaults.ipady != constraints.ipady) {
            GridBagLayoutSourceGenerator.setIntField(generator, "ipady", constraints.ipady);
        }
        if (!defaults.insets.equals(constraints.insets)) {
            generator.append("gbc.insets=");
            generator.newInsets(constraints.insets);
        }
        generator.startMethodCall(parentVariable, "add");
        generator.pushVar(variable);
        generator.pushVar("gbc");
        generator.endMethod();
    }

    private static void setIntField(FormSourceCodeGenerator generator, @NonNls String fieldName, int value) {
        generator.append("gbc.");
        generator.append(fieldName);
        generator.append("=");
        generator.append(value);
        generator.append(";\n");
    }

    private static void setIntField(FormSourceCodeGenerator generator, @NonNls String fieldName, int value, Int2ObjectMap<String> map) {
        generator.append("gbc.");
        generator.append(fieldName);
        generator.append("=");
        if (map.containsKey(value)) {
            generator.append((String)map.get(value));
        } else {
            generator.append(value);
        }
        generator.append(";\n");
    }

    private static void setDoubleField(FormSourceCodeGenerator generator, @NonNls String fieldName, double value) {
        generator.append("gbc.");
        generator.append(fieldName);
        generator.append("=");
        generator.append(value);
        generator.append(";\n");
    }

    private static void checkSetSize(FormSourceCodeGenerator generator, String variable, @NonNls String methodName, Dimension dimension) {
        if (dimension != null) {
            generator.startMethodCall(variable, methodName);
            generator.newDimension(dimension);
            generator.endMethod();
        }
    }

    @Override
    public String mapComponentClass(String componentClassName) {
        if (componentClassName.equals(Spacer.class.getName())) {
            return JPanel.class.getName();
        }
        return super.mapComponentClass(componentClassName);
    }

    static {
        myFillMap.put(2, (Object)"java.awt.GridBagConstraints.HORIZONTAL");
        myFillMap.put(3, (Object)"java.awt.GridBagConstraints.VERTICAL");
        myFillMap.put(1, (Object)"java.awt.GridBagConstraints.BOTH");
        myAnchorMap.put(18, (Object)"java.awt.GridBagConstraints.NORTHWEST");
        myAnchorMap.put(11, (Object)"java.awt.GridBagConstraints.NORTH");
        myAnchorMap.put(12, (Object)"java.awt.GridBagConstraints.NORTHEAST");
        myAnchorMap.put(13, (Object)"java.awt.GridBagConstraints.EAST");
        myAnchorMap.put(14, (Object)"java.awt.GridBagConstraints.SOUTHEAST");
        myAnchorMap.put(15, (Object)"java.awt.GridBagConstraints.SOUTH");
        myAnchorMap.put(16, (Object)"java.awt.GridBagConstraints.SOUTHWEST");
        myAnchorMap.put(17, (Object)"java.awt.GridBagConstraints.WEST");
    }
}

