/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.ResetValueAction;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class Java15FormInspection
extends BaseFormInspection {
    public Java15FormInspection() {
        super("Since15");
    }

    @Override
    protected void checkComponentProperties(Module module2, @NotNull IComponent component, FormErrorCollector collector) {
        if (component == null) {
            Java15FormInspection.$$$reportNull$$$0(0);
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
        PsiManager psiManager = PsiManager.getInstance((Project)module2.getProject());
        PsiClass aClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(component.getComponentClassName(), scope);
        if (aClass == null) {
            return;
        }
        for (IProperty prop : component.getModifiedProperties()) {
            LanguageLevel languageLevel;
            PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)aClass, (String)prop.getName(), (boolean)false, (boolean)true);
            if (getter == null || LanguageLevelUtil.getLastIncompatibleLanguageLevel((PsiMember)getter, (LanguageLevel)(languageLevel = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module2))) == null) continue;
            this.registerError(component, collector, prop, "@since " + LanguageLevelUtil.getJdkName((LanguageLevel)languageLevel));
        }
    }

    private void registerError(IComponent component, FormErrorCollector collector, IProperty prop, @NonNls String api) {
        collector.addError(this.getID(), component, prop, UIDesignerBundle.message("inspection.java15form.problem.descriptor", api), (editor, component1) -> new RemoveUIPropertyFix(editor, component1, (Property)prop));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/Java15FormInspection", "checkComponentProperties"));
    }

    private static class RemoveUIPropertyFix
    extends QuickFix {
        private final Property myProperty;

        RemoveUIPropertyFix(GuiEditor editor, RadComponent component, Property property) {
            super(editor, UIDesignerBundle.message("remove.property.quickfix", new Object[0]), component);
            this.myProperty = property;
        }

        @Override
        public void run() {
            ResetValueAction.doResetValue(Collections.singletonList(this.myComponent), this.myProperty, this.myEditor);
        }
    }
}

