/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.uiDesigner.SelectionWatcher;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.FeedbackPainter;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.ListenerNavigateButton;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.PlatformColors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActiveDecorationLayer
extends JComponent
implements FeedbackLayer {
    private static final Logger LOG = Logger.getInstance(ActiveDecorationLayer.class);
    private final GuiEditor myEditor;
    private final JToolTip myToolTip;
    private final Map<RadComponent, ListenerNavigateButton> myNavigateButtons;
    private final FeedbackPainterPanel myFeedbackPainterPanel;
    private final RectangleFeedbackPainter myRectangleFeedbackPainter;

    ActiveDecorationLayer(@NotNull GuiEditor editor) {
        if (editor == null) {
            ActiveDecorationLayer.$$$reportNull$$$0(0);
        }
        this.myNavigateButtons = new HashMap<RadComponent, ListenerNavigateButton>();
        this.myFeedbackPainterPanel = new FeedbackPainterPanel();
        this.myRectangleFeedbackPainter = new RectangleFeedbackPainter();
        this.myEditor = editor;
        this.myToolTip = new JToolTip();
    }

    public void installSelectionWatcher() {
        new MyNavigateButtonSelectionWatcher(this.myEditor).setupListeners();
    }

    @Override
    public void paint(Graphics g) {
        this.layoutListenerNavigateButtons();
        this.paintChildren(g);
    }

    private void layoutListenerNavigateButtons() {
        for (Map.Entry<RadComponent, ListenerNavigateButton> e : this.myNavigateButtons.entrySet()) {
            RadComponent c = e.getKey();
            ListenerNavigateButton btn = e.getValue();
            if (!btn.isVisible()) continue;
            Rectangle rc = SwingUtilities.convertRectangle(c.getDelegee().getParent(), c.getBounds(), this);
            btn.setLocation(rc.x, rc.y + rc.height);
        }
    }

    @Override
    public void putFeedback(Component relativeTo, Rectangle rc, String tooltipText) {
        this.putFeedback(relativeTo, rc, this.myRectangleFeedbackPainter, tooltipText);
    }

    @Override
    public void putFeedback(Component relativeTo, Rectangle rc, FeedbackPainter feedbackPainter, String tooltipText) {
        rc = SwingUtilities.convertRectangle(relativeTo, rc, this);
        this.myFeedbackPainterPanel.setBounds(rc);
        this.myFeedbackPainterPanel.setPainter(feedbackPainter != null ? feedbackPainter : this.myRectangleFeedbackPainter);
        Point pntMouse = this.myEditor.getGlassLayer().getLastMousePosition();
        this.putToolTip(this, new Point(pntMouse.x + 20, pntMouse.y + 30), tooltipText);
        if (this.myFeedbackPainterPanel.getParent() != this) {
            this.add(this.myFeedbackPainterPanel);
            this.repaint();
        }
    }

    private void putToolTip(Component relativeTo, Point pnt, @Nullable @NlsSafe String text) {
        if (text == null) {
            if (this.myToolTip.getParent() == this) {
                this.remove(this.myToolTip);
                this.repaint();
            }
        } else {
            String oldText = this.myToolTip.getTipText();
            this.myToolTip.setTipText(text);
            pnt = SwingUtilities.convertPoint(relativeTo, pnt, this);
            Dimension prefSize = this.myToolTip.getPreferredSize();
            pnt.x = Math.min(pnt.x, this.getBounds().width - prefSize.width);
            pnt.y = Math.min(pnt.y, this.getBounds().height - prefSize.height);
            this.myToolTip.setBounds(pnt.x, pnt.y, prefSize.width, prefSize.height);
            if (this.myToolTip.getParent() != this) {
                this.add(this.myToolTip);
                this.repaint();
            } else if (!text.equals(oldText)) {
                this.myToolTip.repaint();
            }
        }
    }

    @Override
    public void removeFeedback() {
        boolean needRepaint = false;
        if (this.myFeedbackPainterPanel.getParent() == this) {
            this.remove(this.myFeedbackPainterPanel);
            needRepaint = true;
        }
        if (this.myToolTip.getParent() == this) {
            this.remove(this.myToolTip);
            needRepaint = true;
        }
        if (needRepaint) {
            this.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/designSurface/ActiveDecorationLayer", "<init>"));
    }

    private static class FeedbackPainterPanel
    extends JPanel {
        private FeedbackPainter myFeedbackPainter;

        FeedbackPainterPanel() {
            this.setOpaque(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Stroke savedStroke = g2d.getStroke();
            Color savedColor = g2d.getColor();
            try {
                this.myFeedbackPainter.paintFeedback(g2d, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
            finally {
                g2d.setStroke(savedStroke);
                g2d.setColor(savedColor);
            }
        }

        public void setPainter(FeedbackPainter feedbackPainter) {
            this.myFeedbackPainter = feedbackPainter;
        }
    }

    private static class RectangleFeedbackPainter
    implements FeedbackPainter {
        private RectangleFeedbackPainter() {
        }

        @Override
        public void paintFeedback(Graphics2D g2d, Rectangle rc) {
            g2d.setColor(PlatformColors.BLUE);
            g2d.setStroke(new BasicStroke(2.5f));
            g2d.drawRect(rc.x + 1, rc.y + 1, rc.x + rc.width - 2, rc.y + rc.height - 2);
        }
    }

    private class MyNavigateButtonSelectionWatcher
    extends SelectionWatcher {
        MyNavigateButtonSelectionWatcher(GuiEditor editor) {
            super(editor);
        }

        @Override
        protected void selectionChanged(RadComponent component, boolean selected) {
            ListenerNavigateButton btn = ActiveDecorationLayer.this.myNavigateButtons.get(component);
            if (selected) {
                ReadAction.nonBlocking(() -> component.getBinding() != null ? ListenerNavigateButton.prepareActionGroup(component) : null).finishOnUiThread(ModalityState.nonModal(), group -> {
                    if (group != null && group.getChildrenCount() > 0) {
                        ListenerNavigateButton navigateButton = btn;
                        if (navigateButton == null) {
                            navigateButton = new ListenerNavigateButton(component);
                            ActiveDecorationLayer.this.myNavigateButtons.put(component, navigateButton);
                        }
                        ActiveDecorationLayer.this.add(navigateButton);
                        navigateButton.setVisible(true);
                    } else if (btn != null) {
                        btn.setVisible(false);
                    }
                }).submit((Executor)AppExecutorUtil.getAppExecutorService());
            } else if (btn != null) {
                btn.setVisible(false);
            }
        }
    }
}

